/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;

public final class UriPaths {
    private UriPaths() {
    }

    public static URI toDirectory(URI path) {
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isStorageObject() && !resourceId.isDirectory()) {
            resourceId = resourceId.toDirectoryId();
            path = UriPaths.fromResourceId(resourceId, false);
        }
        return path;
    }

    public static URI getParentPath(URI path) {
        Preconditions.checkNotNull(path);
        if (path.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
            return null;
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        String objectName = resourceId.getObjectName();
        int index = StringPaths.isDirectoryPath(objectName) ? objectName.lastIndexOf("/", objectName.length() - 2) : objectName.lastIndexOf("/");
        return index < 0 ? UriPaths.fromStringPathComponents(resourceId.getBucketName(), null, true) : UriPaths.fromStringPathComponents(resourceId.getBucketName(), objectName.substring(0, index + 1), false);
    }

    public static URI fromResourceId(StorageResourceId resourceId, boolean allowEmptyObjectName) {
        return UriPaths.fromStringPathComponents(resourceId.getBucketName(), resourceId.getObjectName(), allowEmptyObjectName);
    }

    public static URI fromStringPathComponents(String bucketName, String objectName, boolean allowEmptyObjectName) {
        if (allowEmptyObjectName && bucketName == null && objectName == null) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        String authority = StringPaths.validateBucketName(bucketName);
        String path = "/" + StringPaths.validateObjectName(objectName, allowEmptyObjectName);
        try {
            return new URI("gs", authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid bucket name (%s) or object name (%s)", bucketName, objectName), e);
        }
    }
}

