from ...abc import Expression

from ..value.valueexpr import VALUE


class IF(Expression):
	"""
	Checks "if" condition passes - if so, proceeds with "then" expression, otherwise with "else"
	"""

	Attributes = {
		"Test": ["bool"],  # Test expression MUST return boolean
		"Then": None,      # Determined in initialize()
		"Else": None,      # Determined in initialize()
	}

	Category = 'Statements'


	def __init__(self, app, *, arg_test, arg_then=True, arg_else=False):
		super().__init__(app)

		if isinstance(arg_test, Expression):
			self.Test = arg_test
		else:
			self.Test = VALUE(app, value=arg_test)

		if isinstance(arg_then, Expression):
			self.Then = arg_then
		else:
			self.Then = VALUE(app, value=arg_then)

		if isinstance(arg_else, Expression):
			self.Else = arg_else
		else:
			self.Else = VALUE(app, value=arg_else)

		self.Attributes = IF.Attributes.copy()


	def initialize(self):
		# Then and else expression must return the same type
		assert(self.Then.get_outlet_type() == self.Else.get_outlet_type())
		self.Attributes["Then"] = self.Then.get_outlet_type()
		self.Attributes["Else"] = self.Else.get_outlet_type()


	def __call__(self, context, event, *args, **kwargs):
		if self.Test(context, event, *args, **kwargs):
			return self.Then(context, event, *args, **kwargs)
		else:
			return self.Else(context, event, *args, **kwargs)


	def get_outlet_type(self):
		return self.Then.get_outlet_type()
