# Generated by Django 4.1.4 on 2022-12-30 14:28

from django.db import migrations, models
import django.db.models.deletion
import inbox.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Mailbox",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="Name")),
                (
                    "uri",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="Example: imap+ssl://myusername:mypassword@someserver <br /><br />Internet transports include 'imap' and 'pop3'; common local file transports include 'maildir', 'mbox', and less commonly 'babyl', 'mh', and 'mmdf'. <br /><br />Be sure to urlencode your username and password should they contain illegal characters (like @, :, etc).",
                        max_length=255,
                        null=True,
                        verbose_name="URI",
                    ),
                ),
                (
                    "from_email",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="Example: MailBot &lt;mailbot@yourdomain.com&gt;<br />'From' header to set for outgoing email.<br /><br />If you do not use this e-mail inbox for outgoing mail, this setting is unnecessary.<br />If you send e-mail without setting this, your 'From' header will'be set to match the setting `DEFAULT_FROM_EMAIL`.",
                        max_length=255,
                        null=True,
                        verbose_name="From email",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        blank=True,
                        default=True,
                        help_text="Check this e-mail inbox for new e-mail messages during polling cycles.  This checkbox does not have an effect upon whether mail is collected here when this mailbox receives mail from a pipe, and does not affect whether e-mail messages can be dispatched from this mailbox. ",
                        verbose_name="Active",
                    ),
                ),
                (
                    "last_polling",
                    models.DateTimeField(
                        blank=True,
                        help_text="The time of last successful polling for messages.It is blank for new mailboxes and is not set for mailboxes that only receive messages via a pipe.",
                        null=True,
                        verbose_name="Last polling",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mailbox",
                "verbose_name_plural": "Mailboxes",
            },
        ),
        migrations.CreateModel(
            name="Message",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("subject", models.CharField(max_length=255, verbose_name="Subject")),
                (
                    "message_id",
                    models.CharField(max_length=255, verbose_name="Message ID"),
                ),
                (
                    "from_header",
                    models.CharField(max_length=255, verbose_name="From header"),
                ),
                ("to_header", models.TextField(verbose_name="To header")),
                (
                    "outgoing",
                    models.BooleanField(
                        blank=True, default=False, verbose_name="Outgoing"
                    ),
                ),
                ("body", models.TextField(verbose_name="Body")),
                (
                    "encoded",
                    models.BooleanField(
                        default=False,
                        help_text="True if the e-mail body is Base64 encoded",
                        verbose_name="Encoded",
                    ),
                ),
                (
                    "processed",
                    models.DateTimeField(auto_now_add=True, verbose_name="Processed"),
                ),
                (
                    "read",
                    models.DateTimeField(
                        blank=True, default=None, null=True, verbose_name="Read"
                    ),
                ),
                (
                    "eml",
                    models.FileField(
                        help_text="Original full content of message",
                        null=True,
                        upload_to="messages",
                        verbose_name="Raw message contents",
                    ),
                ),
                (
                    "in_reply_to",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="replies",
                        to="inbox.message",
                        verbose_name="In reply to",
                    ),
                ),
                (
                    "mailbox",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="messages",
                        to="inbox.mailbox",
                        verbose_name="Mailbox",
                    ),
                ),
            ],
            options={
                "verbose_name": "E-mail message",
                "verbose_name_plural": "E-mail messages",
            },
        ),
        migrations.CreateModel(
            name="MessageAttachment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "headers",
                    models.TextField(blank=True, null=True, verbose_name="Headers"),
                ),
                (
                    "document",
                    models.FileField(
                        upload_to=inbox.utils.get_attachment_save_path,
                        verbose_name="Document",
                    ),
                ),
                (
                    "message",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attachments",
                        to="inbox.message",
                        verbose_name="Message",
                    ),
                ),
            ],
            options={
                "verbose_name": "Message attachment",
                "verbose_name_plural": "Message attachments",
            },
        ),
    ]
