# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2016-12-06 15:38
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
from csgoogleanalytics.forms import CredentialsField


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        #        ('auth', '0008_alter_user_username_max_length'),
        #        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name="AllowedPattern",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("pattern", models.CharField(max_length=255)),
                ("is_valid", models.BooleanField(default=False)),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="sites.Site"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Analytics",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=255)),
                ("pageviews", models.IntegerField(default=0)),
                ("path", models.CharField(blank=True, max_length=255, null=True)),
                ("date_added", models.DateTimeField(auto_now_add=True)),
                ("start_date", models.DateTimeField()),
                ("end_date", models.DateTimeField()),
                (
                    "delta",
                    models.IntegerField(
                        choices=[(31, b"Month"), (7, b"Week"), (1, b"Day")]
                    ),
                ),
                ("is_valid", models.BooleanField(default=False)),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="sites.Site"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CredentialsModel",
            fields=[
                (
                    "id",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "credential",
                    CredentialsField(null=True),
                ),
            ],
        ),
    ]
