<a id="mypy-boto3-redshift-data"></a>

# mypy-boto3-redshift-data

[![PyPI - mypy-boto3-redshift-data](https://img.shields.io/pypi/v/mypy-boto3-redshift-data.svg?color=blue)](https://pypi.org/project/mypy-boto3-redshift-data)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-redshift-data.svg?color=blue)](https://pypi.org/project/mypy-boto3-redshift-data)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-redshift-data?color=blue)](https://pypistats.org/packages/mypy-boto3-redshift-data)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.RedshiftDataAPIService 1.18.62](https://boto3.amazonaws.com/v1/documentation/api/1.18.62/reference/services/redshift-data.html#RedshiftDataAPIService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-redshift-data docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_redshift_data/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-redshift-data](#mypy-boto3-redshift-data)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `RedshiftDataAPIService` service.

```bash
python -m pip install boto3-stubs[redshift-data]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[redshift-data]` in your environment:
  `python -m pip install 'boto3-stubs[redshift-data]'`

Both type checking and auto-complete should work for `RedshiftDataAPIService`
service. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[redshift-data]` in your environment:
  `python -m pip install 'boto3-stubs[redshift-data]'`

Both type checking and auto-complete should work for `RedshiftDataAPIService`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[redshift-data]` in your environment:
  `python -m pip install 'boto3-stubs[redshift-data]'`
- Run `mypy` as usual

Type checking should work for `RedshiftDataAPIService` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[redshift-data]` in your environment:
  `python -m pip install 'boto3-stubs[redshift-data]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `RedshiftDataAPIService` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`RedshiftDataAPIServiceClient` provides annotations for
`boto3.client("redshift-data")`.

```python
import boto3

from mypy_boto3_redshift_data import RedshiftDataAPIServiceClient

client: RedshiftDataAPIServiceClient = boto3.client("redshift-data")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RedshiftDataAPIServiceClient = session.client("redshift-data")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_redshift_data.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_redshift_data import RedshiftDataAPIServiceClient
from mypy_boto3_redshift_data.paginator import (
    DescribeTablePaginator,
    GetStatementResultPaginator,
    ListDatabasesPaginator,
    ListSchemasPaginator,
    ListStatementsPaginator,
    ListTablesPaginator,
)

client: RedshiftDataAPIServiceClient = boto3.client("redshift-data")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_table_paginator: DescribeTablePaginator = client.get_paginator("describe_table")
get_statement_result_paginator: GetStatementResultPaginator = client.get_paginator("get_statement_result")
list_databases_paginator: ListDatabasesPaginator = client.get_paginator("list_databases")
list_schemas_paginator: ListSchemasPaginator = client.get_paginator("list_schemas")
list_statements_paginator: ListStatementsPaginator = client.get_paginator("list_statements")
list_tables_paginator: ListTablesPaginator = client.get_paginator("list_tables")
```

<a id="literals"></a>

### Literals

`mypy_boto3_redshift_data.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_redshift_data.literals import (
    DescribeTablePaginatorName,
    GetStatementResultPaginatorName,
    ListDatabasesPaginatorName,
    ListSchemasPaginatorName,
    ListStatementsPaginatorName,
    ListTablesPaginatorName,
    StatementStatusStringType,
    StatusStringType,
    ServiceName,
    PaginatorName,
)

def check_value(value: DescribeTablePaginatorName) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_redshift_data.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_redshift_data.type_defs import (
    BatchExecuteStatementInputRequestTypeDef,
    BatchExecuteStatementOutputTypeDef,
    CancelStatementRequestRequestTypeDef,
    CancelStatementResponseTypeDef,
    ColumnMetadataTypeDef,
    DescribeStatementRequestRequestTypeDef,
    DescribeStatementResponseTypeDef,
    DescribeTableRequestRequestTypeDef,
    DescribeTableResponseTypeDef,
    ExecuteStatementInputRequestTypeDef,
    ExecuteStatementOutputTypeDef,
    FieldTypeDef,
    GetStatementResultRequestRequestTypeDef,
    GetStatementResultResponseTypeDef,
    ListDatabasesRequestRequestTypeDef,
    ListDatabasesResponseTypeDef,
    ListSchemasRequestRequestTypeDef,
    ListSchemasResponseTypeDef,
    ListStatementsRequestRequestTypeDef,
    ListStatementsResponseTypeDef,
    ListTablesRequestRequestTypeDef,
    ListTablesResponseTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadataTypeDef,
    SqlParameterTypeDef,
    StatementDataTypeDef,
    SubStatementDataTypeDef,
    TableMemberTypeDef,
)

def get_structure() -> BatchExecuteStatementInputRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-redshift-data` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-redshift-data docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_redshift_data/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
