"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transport = exports.transportDefaults = exports.FLUSH_METRICS_TO_LOGS_ENV_VAR = exports.SITE_URL_ENV_VAR = exports.KMS_API_KEY_ENV_VAR = exports.API_KEY_SECRET_ARN_ENV_VAR = exports.API_KEY_ENV_VAR = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
const loglevel_1 = require("loglevel");
const constants_1 = require("./constants");
exports.API_KEY_ENV_VAR = "DD_API_KEY";
exports.API_KEY_SECRET_ARN_ENV_VAR = "DD_API_KEY_SECRET_ARN";
exports.KMS_API_KEY_ENV_VAR = "DD_KMS_API_KEY";
exports.SITE_URL_ENV_VAR = "DD_SITE";
exports.FLUSH_METRICS_TO_LOGS_ENV_VAR = "DD_FLUSH_TO_LOG";
exports.transportDefaults = {
    site: "datadoghq.com",
    flushMetricsToLogs: true,
    enableDatadogTracing: true,
};
/**
 * @stability stable
 */
class Transport {
    /**
     * @stability stable
     */
    constructor(flushMetricsToLogs, site, apiKey, apiKeySecretArn, apiKmsKey, extensionLayerVersion) {
        if (flushMetricsToLogs === undefined) {
            loglevel_1.default.debug(`No value provided for flushMetricsToLogs, defaulting to ${exports.transportDefaults.flushMetricsToLogs}`);
            this.flushMetricsToLogs = exports.transportDefaults.flushMetricsToLogs;
        }
        else {
            this.flushMetricsToLogs = flushMetricsToLogs;
        }
        this.extensionLayerVersion = extensionLayerVersion;
        // If the extension is used, metrics will be submitted via the extension.
        if (this.extensionLayerVersion !== undefined) {
            loglevel_1.default.debug(`Using extension version ${this.extensionLayerVersion}, metrics will be submitted via the extension`);
            this.flushMetricsToLogs = false;
        }
        if (site === undefined) {
            loglevel_1.default.debug(`No value provided for site, defaulting to ${exports.transportDefaults.site}`);
            this.site = exports.transportDefaults.site;
        }
        else {
            this.site = site;
        }
        this.apiKey = apiKey;
        this.apiKeySecretArn = apiKeySecretArn;
        this.apiKmsKey = apiKmsKey;
    }
    /**
     * @stability stable
     */
    applyEnvVars(lambdas) {
        loglevel_1.default.debug(`Setting Datadog transport environment variables...`);
        lambdas.forEach((lam) => {
            lam.addEnvironment(exports.FLUSH_METRICS_TO_LOGS_ENV_VAR, this.flushMetricsToLogs.toString());
            if (this.site !== undefined && this.flushMetricsToLogs === false) {
                lam.addEnvironment(exports.SITE_URL_ENV_VAR, this.site);
            }
            if (this.apiKey !== undefined) {
                lam.addEnvironment(exports.API_KEY_ENV_VAR, this.apiKey);
            }
            if (this.apiKeySecretArn !== undefined) {
                const isNode = constants_1.runtimeLookup[lam.runtime.name] === constants_1.RuntimeType.NODE;
                const isSendingSynchronousMetrics = this.extensionLayerVersion === undefined && !this.flushMetricsToLogs;
                if (isSendingSynchronousMetrics && isNode) {
                    throw new Error(`\`apiKeySecretArn\` is not supported for Node runtimes when using Synchronous Metrics. Use either \`apiKey\` or \`apiKmsKey\`.`);
                }
                lam.addEnvironment(exports.API_KEY_SECRET_ARN_ENV_VAR, this.apiKeySecretArn);
            }
            if (this.apiKmsKey !== undefined) {
                lam.addEnvironment(exports.KMS_API_KEY_ENV_VAR, this.apiKmsKey);
            }
        });
    }
}
exports.Transport = Transport;
_a = JSII_RTTI_SYMBOL_1;
Transport[_a] = { fqn: "datadog-cdk-constructs.Transport", version: "0.7.0" };
//# sourceMappingURL=data:application/json;base64,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