"""Initial schema with ProjectMemoryDB and ArtifactMetaDB

Revision ID: 07663acc4960
Revises: 
Create Date: 2025-04-20 17:28:46.979075

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel


# revision identifiers, used by Alembic.
revision: str = '07663acc4960'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('projectmemorydb',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('name', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('language', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('purpose', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('target_audience', sqlmodel.sql.sqltypes.AutoString(), nullable=True),
    sa.Column('objectives', sa.JSON(), nullable=True),
    sa.Column('taxonomy_version', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('last_updated_at', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_projectmemorydb_id'), 'projectmemorydb', ['id'], unique=False)
    op.create_index(op.f('ix_projectmemorydb_name'), 'projectmemorydb', ['name'], unique=True)
    op.create_table('artifactmetadb',
    sa.Column('id', sa.UUID(), nullable=False),
    sa.Column('project_memory_id', sa.UUID(), nullable=False),
    sa.Column('name', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('bucket', sa.Enum('INITIATE_CORE_SETUP', 'INITIATE_INITIAL_PRODUCT_DOCS', 'ELABORATE_DISCOVERY_AND_RESEARCH', 'ELABORATE_IDEATION_AND_DESIGN', 'ELABORATE_SPECIFICATION_AND_PLANNING', 'ELABORATE_CORE_AND_SUPPORT', 'GOVERN_CORE_SYSTEM', 'GOVERN_STANDARDS_METHODOLOGIES', 'GOVERN_VERIFICATION_VALIDATION', 'GOVERN_MEMORY_TEMPLATES', 'GOVERN_TOOLING_SCRIPTS', 'GENERATE_CORE_FUNCTIONALITY', 'GENERATE_SUPPORTING_ELEMENTS', 'MAINTAIN_CORE_FUNCTIONALITY', 'MAINTAIN_SUPPORTING_ELEMENTS', 'DEPLOY_PIPELINES_AND_AUTOMATION', 'DEPLOY_INFRASTRUCTURE_AND_CONFIG', 'DEPLOY_GUIDES_AND_CHECKLISTS', 'DEPLOY_SECURITY', 'OPERATE_RUNBOOKS_AND_SOPS', 'OPERATE_MONITORING_AND_ALERTING', 'OPERATE_MAINTENANCE', 'ITERATE_LEARNING_AND_ANALYSIS', 'ITERATE_PLANNING_AND_RETROSPECTION', 'UNKNOWN', name='bucket'), nullable=False),
    sa.Column('path', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.Column('status', sa.Enum('PENDING', 'IN_PROGRESS', 'COMPLETED', name='documentstatus'), nullable=False),
    sa.ForeignKeyConstraint(['project_memory_id'], ['projectmemorydb.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_artifactmetadb_bucket'), 'artifactmetadb', ['bucket'], unique=False)
    op.create_index(op.f('ix_artifactmetadb_id'), 'artifactmetadb', ['id'], unique=False)
    op.create_index(op.f('ix_artifactmetadb_name'), 'artifactmetadb', ['name'], unique=False)
    op.create_index(op.f('ix_artifactmetadb_path'), 'artifactmetadb', ['path'], unique=False)
    op.create_index(op.f('ix_artifactmetadb_project_memory_id'), 'artifactmetadb', ['project_memory_id'], unique=False)
    op.create_index(op.f('ix_artifactmetadb_status'), 'artifactmetadb', ['status'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_artifactmetadb_status'), table_name='artifactmetadb')
    op.drop_index(op.f('ix_artifactmetadb_project_memory_id'), table_name='artifactmetadb')
    op.drop_index(op.f('ix_artifactmetadb_path'), table_name='artifactmetadb')
    op.drop_index(op.f('ix_artifactmetadb_name'), table_name='artifactmetadb')
    op.drop_index(op.f('ix_artifactmetadb_id'), table_name='artifactmetadb')
    op.drop_index(op.f('ix_artifactmetadb_bucket'), table_name='artifactmetadb')
    op.drop_table('artifactmetadb')
    op.drop_index(op.f('ix_projectmemorydb_name'), table_name='projectmemorydb')
    op.drop_index(op.f('ix_projectmemorydb_id'), table_name='projectmemorydb')
    op.drop_table('projectmemorydb')
    # ### end Alembic commands ###
