# Plantilla Simplificada: Documentación de Bug

## Información General
- **Nombre del Producto**: [Nombre del producto afectado]
- **ID del Bug**: [Identificador único del bug]
- **Fecha de Reporte**: [Fecha cuando se reportó]
- **Reportado por**: [Persona que reportó el bug]
- **Asignado a**: [Persona responsable de la resolución]
- **Versión Afectada**: [Versión(es) donde ocurre el bug]
- **Prioridad**: [Alta/Media/Baja]
- **Severidad**: [Crítica/Alta/Media/Baja]
- **Estado**: [Reportado/En análisis/En desarrollo/Resuelto/Verificado/Cerrado]

## Descripción del Bug (MECE)
- **Resumen**: [Descripción concisa del problema]
- **Comportamiento Esperado**: [Cómo debería funcionar correctamente]
- **Comportamiento Actual**: [Cómo está funcionando incorrectamente]
- **Impacto**: 
  - **Impacto en Usuario**: [Cómo afecta a los usuarios]
  - **Impacto en Negocio**: [Repercusiones para el negocio]
  - **Alcance**: [Número de usuarios/clientes afectados]

## Pasos para Reproducir
1. [Paso 1]
2. [Paso 2]
3. [Paso 3]
...

## Contexto Adicional
- **Entorno**: [Detalles del entorno donde ocurre - sistema operativo, navegador, etc.]
- **Consistencia**: [Siempre ocurre / Intermitente / Ocurre bajo condiciones específicas]
- **Adjuntos**: [Enlaces a capturas de pantalla, logs, videos, etc.]
- **Información de Usuario**: [Datos sobre el usuario afectado, si relevante]

## Análisis de Causa Raíz
- **Componente Afectado**: [Módulo/componente específico donde está el problema]
- **Causa Técnica**: [Explicación técnica de por qué ocurre el bug]
- **Factores Contribuyentes**: [Otros factores que contribuyen al problema]
- **¿Regresión?**: [Sí/No - ¿Es un problema que antes funcionaba correctamente?]
- **Commit/Cambio Relacionado**: [Si es regresión, referencia al cambio que lo introdujo]

## Plan de Solución
- **Enfoque de Corrección**: [Descripción de cómo se planea resolver]
- **Archivos a Modificar**: [Lista de archivos que requieren cambios]
- **Cambios en la Base de Datos**: [Si aplican]
- **Riesgos de la Corrección**: [Posibles efectos secundarios]
- **Estimación de Esfuerzo**: [Tiempo estimado para la resolución]

## Verificación
- **Plan de Testing**: [Cómo se verificará que el bug está resuelto]
- **Casos de Prueba**: [Tests específicos a realizar]
- **Criterios de Aceptación**: [Condiciones para considerar el bug como resuelto]

## Prevención
- **Causa de no Detección**: [Por qué no se detectó antes en pruebas]
- **Mejoras en Proceso**: [Cambios en el proceso para prevenir bugs similares]
- **Mejoras en Testing**: [Nuevos casos de prueba a añadir]

## Resolución
- **Solución Implementada**: [Descripción de la solución aplicada]
- **Pull Request/Commit**: [Referencias a los cambios en el código]
- **Versión Corregida**: [Versión donde se incluye la corrección]
- **Notas para Release**: [Texto a incluir en notas de la versión]

## Lecciones Aprendidas
- **Observaciones**: [Reflexiones sobre el bug y su solución]
- **Acciones Preventivas**: [Acciones a tomar para evitar bugs similares]
- **Conocimiento Adquirido**: [Nuevos conocimientos obtenidos]

---

Esta plantilla simplificada sigue principios MECE (Mutuamente Excluyente, Colectivamente Exhaustivo) para documentar un bug de manera completa y estructurada, facilitando su análisis, resolución y prevención de problemas similares en el futuro. 