# Index of Simplified Templates

This directory contains simplified templates for documenting different types of tasks in existing software projects. Unlike the complete templates oriented towards product development from scratch, these templates are optimized for:

1. **Speed**: They require less time to complete
2. **Focus**: They concentrate on the most relevant information for existing projects
3. **Practicality**: They avoid unnecessary sections for smaller, incremental changes
4. **Team Consistency**: They ensure critical information is always documented

## Available Templates

1. **[Feature Documentation](feature_documentation.md)** - For documenting new features or significant improvements in an existing product.

2. **[Bug Documentation](bug_documentation.md)** - For documenting errors, their analysis, solution, and prevention.

3. **[Quick Task Documentation](quick_task_documentation.md)** - Ultra simplified version for small maintenance tasks, optimizations, or configurations.

4. **[Source Verification Template](source_verification_template.md)** - For systematically verifying external information sources used in documentation.

## When to Use Each Template

- **Feature Documentation**: For significant new functionalities or major changes to existing ones. This template ensures all aspects of the new feature are considered: from user requirements to technical implementation details.

- **Bug Documentation**: For tracking, analyzing, and resolving bugs. This template helps understand the root cause, impacts, and ensures proper verification of the fix.

- **Quick Task Documentation**: For minor changes, optimizations, configurations, or refactorings that don't warrant extensive documentation.

- **Source Verification**: When including statistical data, market information, or other external sources that require systematic verification and documentation.

## MECE Principles Application

Although simplified, these templates maintain the MECE principle (Mutually Exclusive, Collectively Exhaustive):

- **Mutually Exclusive**: Each section covers a specific aspect of the task without overlap
- **Collectively Exhaustive**: All relevant aspects are covered, leaving no gaps
- **Appropriate Detail Level**: The depth of information is appropriate for the task complexity

## Template Customization

These templates are starting points and can be adapted according to:

- **Project Type**: Web, mobile, desktop applications
- **Team Size**: Small teams may simplify further, larger teams might need more detail
- **Development Methodology**: Agile, waterfall, or other approaches
- **Regulatory Requirements**: Projects with compliance needs may require additional sections
- **Integration Needs**: Projects with many integrations might need more detailed dependency sections

## Best Practices

- Keep documentation concise and focused
- Update documentation if requirements or approach change
- Link to related documentation when appropriate
- Use clear, specific language
- Include measurable criteria when possible

This simplified structure allows maintaining adequate documentation without the overhead of a complete product development process, balancing the need for documentation with development agility. 