# Project Progress Tracking Template

## General Project Information

- **Project Name**: [Name]
- **Start Date**: [Date]
- **Target Completion Date**: [Date]
- **Project Leader**: [Name]
- **Current Status**: [In Planning/In Development/In Testing/In Review/Completed]

## Executive Summary

[Brief description of the current project status, main achievements, challenges, and next steps]

## Status by Phase (MECE)

### Phase 1: [Phase Name]

- **Status**: [Not Started/In Progress/Completed]
- **Progress**: [Percentage completed]
- **Planned Start Date**: [Date]
- **Actual Start Date**: [Date]
- **Planned End Date**: [Date]
- **Actual/Projected End Date**: [Date]
- **Completed Milestones**:
  - [x] [Milestone 1]
  - [x] [Milestone 2]
- **Pending Milestones**:
  - [ ] [Milestone 3] - Deadline: [Date]
  - [ ] [Milestone 4] - Deadline: [Date]
- **Blockers**:
  - [Description of blocker 1] - Status: [Active/Resolved] - Responsible: [Name]
  - [Description of blocker 2] - Status: [Active/Resolved] - Responsible: [Name]

### Phase 2: [Phase Name]

...

## Status by Hexagon (MECE)

### User Management

- **Global Status**: [Percentage completed]
- **Status by Layer**:
  - **Domain**: [Percentage completed]
  - **Application**: [Percentage completed]
  - **Infrastructure**: [Percentage completed]
  - **Interfaces**: [Percentage completed]
- **Implemented Features**:
  - [x] [Feature 1]
  - [x] [Feature 2]
- **Pending Features**:
  - [ ] [Feature 3] - Target Sprint: [Number]
  - [ ] [Feature 4] - Target Sprint: [Number]
- **Technical Debt**:
  - [Description of technical debt 1] - Priority: [High/Medium/Low]
  - [Description of technical debt 2] - Priority: [High/Medium/Low]
- **Test Coverage**: [Global percentage]

### Problem Management

...

### Problem Solving

...

### Classification Management

...

### Project Management

...

### Critic Management

...

### Evaluation Management

...

### LLM Processing

...

### Shared

...

## Progress Metrics (MECE)

### Time Metrics

- **Completed Sprints**: [Number]
- **Remaining Sprints**: [Number]
- **Days Behind/Ahead**: [Number of days]
- **Completion Trend**: [Ahead/On schedule/Delayed] - [Number of days]

### Scope Metrics

- **Planned User Stories**: [Number]
- **Completed User Stories**: [Number]
- **Scope Changes**: [Number of changes]
- **Requirements Completeness**: [Percentage]

### Quality Metrics

- **Global Test Coverage**: [Percentage]
- **Defects Found**: [Number]
- **Defects Resolved**: [Number]
- **Open Critical Defects**: [Number]
- **Accumulated Technical Debt**: [Estimation]

### Team Metrics

- **Average Velocity**: [Story points/sprint]
- **Velocity Trend**: [Increasing/Stable/Decreasing]
- **Capacity Used**: [Percentage]
- **Team Stability**: [Retention percentage]

## Risks and Issues

### Current Risks

- **Risk 1**: [Description]
  - **Probability**: [High/Medium/Low]
  - **Impact**: [High/Medium/Low]
  - **Mitigation Strategy**: [Description]
  - **Responsible**: [Name]
  - **Review Date**: [Date]

- **Risk 2**: [Description]
  ...

### Active Issues

- **Issue 1**: [Description]
  - **Impact**: [High/Medium/Low]
  - **Action Plan**: [Description]
  - **Responsible**: [Name]
  - **Deadline**: [Date]
  - **Status**: [New/In Progress/Pending Verification]

- **Issue 2**: [Description]
  ...

## Pending Decisions

- **Decision 1**: [Description]
  - **Context**: [Relevant information]
  - **Options**: [Available options]
  - **Decision Maker**: [Name]
  - **Deadline**: [Date]
  - **Delay Impact**: [Description]

- **Decision 2**: [Description]
  ...

## Plan for the Next Period

- **Main Objectives**:
  - [Objective 1]
  - [Objective 2]
- **Planned Milestones**:
  - [Milestone 1] - Date: [Date]
  - [Milestone 2] - Date: [Date]
- **Required Resources**:
  - [Resource 1]
  - [Resource 2]
- **Anticipated Changes**:
  - [Change 1]
  - [Change 2]

## Lessons Learned

- [Lesson 1]
- [Lesson 2]
- [Lesson 3]

---

This template follows MECE principles by organizing progress tracking into mutually exclusive categories (general information, status by phases, status by hexagon, metrics, risks/issues, decisions, and future plan) and collectively exhaustive (covering all critical aspects for effective tracking of a software project).
