# Meeting Notes Template

## General Information

- **Date**: [Date and time of the meeting]
- **Duration**: [Duration of the meeting]
- **Meeting Type**: [Planning / Review / Retrospective / Daily / Technical / Stakeholders]
- **Participants**: [List of participants]
- **Facilitator**: [Name of the facilitator]
- **Secretary**: [Name of the person responsible for taking notes]

## Agenda

1. [Topic 1]
2. [Topic 2]
3. [Topic 3]
4. ...

## Topics Discussed (MECE)

### 1. [Topic 1]

- **Context**: [Relevant information about the topic]
- **Discussion**:
  - [Key point discussed 1]
  - [Key point discussed 2]
  - [Key point discussed 3]
- **Decisions**:
  - [Decision made 1]
  - [Decision made 2]
- **Actions**:
  - [ ] [Action 1] - Responsible: [Name] - Deadline: [Date]
  - [ ] [Action 2] - Responsible: [Name] - Deadline: [Date]
- **Open Issues**:
  - [Unresolved issue 1]
  - [Unresolved issue 2]

### 2. [Topic 2]

...

## Project Status Update

### Hexagon Status

- **User Management**:
  - **Progress**: [Percentage completed]
  - **Achieved Milestones**: [Completed milestones]
  - **Blockers**: [Current blockers]
  - **Next Steps**: [Next objectives]

- **Problem Management**:
  - **Progress**: [Percentage completed]
  - **Achieved Milestones**: [Completed milestones]
  - **Blockers**: [Current blockers]
  - **Next Steps**: [Next objectives]

### Current Sprint Status

- **Days Remaining**: [Number of days until the end of the sprint]
- **Burndown**: [Current status vs. planned]
- **Completed Tasks**: [Number and percentage]
- **Tasks In Progress**: [Number and percentage]
- **Blocked Tasks**: [Number and percentage]

### Quality Metrics

- **Test Coverage**: [Global percentage]
- **Technical Debt**: [Current estimation]
- **Open Defects**: [Number of unresolved defects]
- **Pending Pull Requests**: [Number of PRs under review]

## Architectural Decisions

- **Decision 1**: [Description of the decision]
  - **Context**: [Problem being addressed]
  - **Options Considered**: [Alternatives evaluated]
  - **Decision Made**: [Selected option]
  - **Justification**: [Reasons for selection]
  - **Consequences**: [Positive and negative implications]
  - **Status**: [Proposed/Accepted/Implemented/Replaced]

- **Decision 2**: [Description of the decision]
  - ...

## Identified Risks

- **Risk 1**: [Description of the risk]
  - **Probability**: [High/Medium/Low]
  - **Impact**: [High/Medium/Low]
  - **Mitigation Strategy**: [Plan to reduce probability or impact]
  - **Responsible**: [Person in charge of monitoring]

- **Risk 2**: [Description of the risk]
  - ...

## Highlights

- **Achievements**: [Significant achievements since the last meeting]
- **Concerns**: [Main concerns of the team]
- **Learnings**: [Lessons learned]

## Next Meeting

- **Date**: [Date and time of the next meeting]
- **Proposed Topics**:
  - [Topic 1]
  - [Topic 2]

## Attachments

- [Link to relevant diagrams or documents]
- [Link to shared presentations]
- [Link to prototypes or demos]

---

This template follows MECE principles by organizing meeting notes into mutually exclusive categories (general information, agenda, topics discussed, project status, architectural decisions, risks, and highlights) and collectively exhaustive (covering all relevant aspects of a project meeting, from planning to follow-up and documentation of decisions).
