# Task Management Template

## General Sprint Information

- **Sprint Number**: [Number]
- **Dates**: [Start date - End date]
- **Sprint Objective**: [Description of the main objective]
- **Team Capacity**: [Number of story points/hours available]
- **Team**: [Assigned team members]

## Task Categorization (MECE)

### By Priority

- **MANDATORY**: [Tasks that must be completed no matter what]
- **HIGH**: [Tasks critical for the business/project]
- **MEDIUM**: [Important but non-critical tasks]
- **LOW**: [Tasks that can be postponed if necessary]

### By Type

- **New Functionality**: [Development of new features]
- **Enhancement**: [Improvements to existing functionalities]
- **Bug Fix**: [Resolution of identified bugs]
- **Technical Debt**: [Improvements in code quality/architecture]
- **Research**: [Analysis or proof of concepts]
- **Documentation**: [Creation or updating of documentation]

### By Architecture Layer

- **Domain**: [Tasks related to the domain layer]
- **Application**: [Tasks related to the application layer]
- **Infrastructure**: [Tasks related to the infrastructure layer]
- **Interfaces**: [Tasks related to the interface layer]
- **Cross-cutting**: [Tasks affecting multiple layers]

### By Hexagon

- **User Management**: [Tasks from the user management hexagon]
- **Problem Management**: [Tasks from the problem management hexagon]
- **Problem Solving**: [Tasks from the problem solving hexagon]
- **Classification Management**: [Tasks from the classification management hexagon]
- **Project Management**: [Tasks from the project management hexagon]
- **Critic Management**: [Tasks from the critic management hexagon]
- **Evaluation Management**: [Tasks from the evaluation hexagon]
- **LLM Processing**: [Tasks from the LLM processing hexagon]
- **Shared**: [Tasks from the shared hexagon]

## Task List

### [ID-001] - [Task Title]

- **Description**: [Detailed description of the task]
- **Categorization**:
  - **Priority**: [MANDATORY/HIGH/MEDIUM/LOW]
  - **Type**: [Task type]
  - **Layer**: [Architecture layer]
  - **Hexagon**: [Related hexagon]
- **Estimation**: [Story points/hours]
- **Assigned to**: [Name of the responsible person]
- **Status**: [To do/In progress/In review/Completed]
- **Dependencies**: [IDs of tasks this depends on]
- **Acceptance Criteria**:
  - [ ] [Criterion 1]
  - [ ] [Criterion 2]
  - [ ] [Criterion 3]
- **Subtasks**:
  - [ ] [Subtask 1]
  - [ ] [Subtask 2]
  - [ ] [Subtask 3]

### [ID-002] - [Task Title]

...

## Testing Plan

### Required Tests by Task

- **[ID-001]**:
  - [ ] Unit tests for [specific function/class]
  - [ ] Integration tests for [specific component]
  - [ ] Acceptance tests for [specific functionality]

### Test Coverage

- **Domain**: [Target percentage] - [Current percentage]
- **Application**: [Target percentage] - [Current percentage]
- **Infrastructure**: [Target percentage] - [Current percentage]
- **Interfaces**: [Target percentage] - [Current percentage]

## Sprint Metrics

- **Planned Velocity**: [Planned story points/hours]
- **Actual Velocity**: [Completed story points/hours]
- **Added Technical Debt**: [Story points/hours of new technical debt]
- **Paid Technical Debt**: [Story points/hours of resolved technical debt]
- **Defect Rate**: [Number of defects found / completed story points]

## Impediments

- **Impediment 1**: [Description]
  - **Impact**: [Affected tasks]
  - **Mitigation Plan**: [Actions to resolve it]
  - **Status**: [Active/Resolved]
- **Impediment 2**: [Description]
  - ...

---

This template follows MECE principles by categorizing tasks in a mutually exclusive (by priority, type, layer, and hexagon) and collectively exhaustive manner (covering all aspects of task management, from planning to tracking and metrics).
