# Service Blueprint Template

## General Information

- **Project Name**: [Name]
- **Creation Date**: [Date]
- **Responsible**: [Name of the responsible person]
- **Version**: [Version number]
- **Mapped Service**: [Name of the service/process]

## Purpose of the Service Blueprint

[Brief description of the purpose of this service blueprint and how it will be used in the project]

## Scope

- **Starting Point**: [Where the service begins]
- **End Point**: [Where the service ends]
- **Covered Channels**: [Channels included in this blueprint]
- **Primary Users**: [Main users of the service]
- **Expected Value**: [Value that the service should provide]

## Blueprint Structure (MECE)

The following sections show each phase of the service with its components across different layers:

### Service Phases (Horizontal Axis)

- **Phase 1**: [Name - Ex: Discovery]
- **Phase 2**: [Name - Ex: Onboarding]
- **Phase 3**: [Name - Ex: Usage]
- **Phase 4**: [Name - Ex: Support]
- **Phase 5**: [Name - Ex: Loyalty]

### Service Layers (Vertical Axis)

1. **Physical Evidence** (tangible elements visible to the user)
2. **User Actions** (actions performed by the user)
3. **Frontstage** (employee/system actions visible to the user)
4. **Backstage** (employee/system actions not visible to the user)
5. **Support Processes** (internal systems and processes needed)

## Breakdown by Phase (MECE)

### Phase 1: [Name - Ex: Discovery]

#### Physical Evidence

- **Evidence 1**: [Description]
  - **Format**: [Digital/Physical]
  - **Channel**: [Where it appears]
  - **Purpose**: [What it communicates or facilitates]
  
- **Evidence 2**: [Description]
  - ...

#### User Actions

- **Action 1**: [Description]
  - **Channel**: [Where it occurs]
  - **Frequency**: [How often it occurs]
  - **Trigger**: [What motivates this action]
  - **Complexity**: [High/Medium/Low]
  
- **Action 2**: [Description]
  - ...

#### Frontstage (Interaction Line)

- **Interaction 1**: [Description]
  - **Actor**: [Person or system that interacts with the user]
  - **Type**: [Digital/Personal/Physical]
  - **Purpose**: [Objective of this interaction]
  - **Typical Duration**: [How long it lasts]
  
- **Interaction 2**: [Description]
  - ...

#### Backstage (Visibility Line)

- **Process 1**: [Description]
  - **Actor**: [Who performs it]
  - **Trigger**: [What activates it]
  - **Result**: [What it produces]
  - **Technology Used**: [What systems are used]
  
- **Process 2**: [Description]
  - ...

#### Support Processes (Internal Line)

- **Process 1**: [Description]
  - **System/Department**: [Responsible]
  - **Required Inputs**: [What it needs to function]
  - **Outputs**: [What it produces]
  - **Dependencies**: [What it depends on]
  
- **Process 2**: [Description]
  - ...

### Phase 2: [Name - Ex: Onboarding]

...

### Phase 3: [Name - Ex: Usage]

...

### Phase 4: [Name - Ex: Support]

...

### Phase 5: [Name - Ex: Loyalty]

...

## Failure Points and Opportunities (MECE)

### Identified Failure Points

- **Failure 1**: [Description]
  - **Location**: [Phase and layer where it occurs]
  - **Frequency**: [How often it occurs]
  - **Severity**: [High/Medium/Low]
  - **Impact on User**: [How it affects the user]
  - **Impact on Business**: [How it affects the business]
  - **Root Causes**: [Underlying reasons]
  
- **Failure 2**: [Description]
  - ...

### Waiting Moments

- **Wait 1**: [Description]
  - **Location**: [Phase and layer where it occurs]
  - **Typical Duration**: [How long it lasts]
  - **Type**: [Active (user participates) / Passive (user waits)]
  - **Perception**: [How the user perceives it]
  - **Current Mitigation**: [How it is currently managed]
  
- **Wait 2**: [Description]
  - ...

### Redundancies

- **Redundancy 1**: [Description]
  - **Location**: [Phase and layer where it occurs]
  - **Impact**: [How it affects the service]
  - **Reason**: [Why it exists]
  
- **Redundancy 2**: [Description]
  - ...

### Improvement Opportunities

- **Opportunity 1**: [Description]
  - **Location**: [Phase and layer where it would apply]
  - **Expected Benefits**: [Improvements it would generate]
  - **Implementation Complexity**: [High/Medium/Low]
  - **Estimated Impact**: [High/Medium/Low]
  
- **Opportunity 2**: [Description]
  - ...

## Metrics and KPIs by Phase (MECE)

### Phase 1 Metrics

- **KPI 1**: [Name]
  - **Definition**: [How it is calculated]
  - **Current Value**: [Current measurement]
  - **Target**: [Desired value]
  - **Owner**: [Who is responsible]
  - **Data Source**: [Where the data comes from]
  
- **KPI 2**: [Name]
  - ...

### Phase 2 Metrics

...

## Technology and Systems (MECE)

### Front-End Systems

- **System 1**: [Name]
  - **Purpose**: [What it is used for]
  - **Users**: [Who uses it]
  - **Integration with Other Systems**: [Connections]
  - **Limitations**: [Known restrictions]
  
- **System 2**: [Name]
  - ...

### Back-End Systems

- **System 1**: [Name]
  - **Purpose**: [What it is used for]
  - **Users**: [Who uses it]
  - **Managed Data**: [What information it handles]
  - **Integration with Other Systems**: [Connections]
  - **Limitations**: [Known restrictions]
  
- **System 2**: [Name]
  - ...

### Integrations

- **Integration 1**: [Between which systems]
  - **Type**: [API, batch, manual, etc.]
  - **Frequency**: [Real-time, daily, etc.]
  - **Exchanged Data**: [What information is shared]
  - **Failure Points**: [Where it can fail]
  
- **Integration 2**: [Between which systems]
  - ...

## Service Variations (MECE)

### By User Segment

- **Segment 1**: [Name]
  - **Key Differences**: [How the service varies]
  - **Reason**: [Why it is different]
  
- **Segment 2**: [Name]
  - ...

### By Channel

- **Channel 1**: [Name]
  - **Key Differences**: [How the service varies]
  - **Limitations**: [Channel-specific restrictions]
  
- **Channel 2**: [Name]
  - ...

### By Region/Market

- **Region 1**: [Name]
  - **Key Differences**: [How the service varies]
  - **Regulatory/Cultural Reasons**: [Causes of variation]
  
- **Region 2**: [Name]
  - ...

## Action Plan (MECE)

### Immediate Improvements

- **Improvement 1**: [Description]
  - **Location**: [Phase and layer where it applies]
  - **Implementation**: [How it will be implemented]
  - **Responsible**: [Who will implement it]
  - **Timeframe**: [When it should be implemented]
  - **Success Metrics**: [How success will be measured]
  
- **Improvement 2**: [Description]
  - ...

### Medium-Term Improvements

- **Improvement 1**: [Description]
  - ...

### Long-Term Improvements

- **Improvement 1**: [Description]
  - ...

### Prioritization

- **Prioritization Matrix**: [Criteria and scores]
- **Recommended Sequence**: [Suggested implementation order]
- **Dependencies**: [Which improvements depend on others]

## Appendices

- **Visual Blueprint Diagram**: [Link to the diagram]
- **User Research**: [Links to relevant research]
- **Related Journey Maps**: [Links to journey maps]
- **Systems Documentation**: [Links to technical documentation]

---

This template follows MECE principles by organizing the service blueprint into mutually exclusive and collectively exhaustive layers and phases, ensuring that all aspects of the service are mapped from the user experience to the internal processes.
