# Problem Definition Template

## General Information

- **Project Name**: [Name]
- **Date**: [Date]
- **Responsible**: [Name of the responsible person]
- **Team**: [Team members]

## Problem Context (MECE)

### Background

- **Current Situation**: [Description of the existing situation]
- **Problem History**: [How the problem has evolved]
- **Previous Solution Attempts**: [Previous solutions and their results]
- **Known Constraints**: [Existing limitations]
- **Stakeholders Involved**: [People affected or interested]

### Problem Evidence

- **Quantitative Data**: [Statistics, metrics, indicators]
- **Qualitative Data**: [Testimonials, observations, interviews]
- **Economic Impact**: [Costs associated with the problem]
- **Impact on Users**: [How it affects users]
- **Impact on Business**: [How it affects the business]
- **Relevant Trends**: [Trends related to the problem]

## Problem Definition (MECE)

### Problem Statement

- **Clear Statement**: [Concise statement of the problem]
- **Scope**: [Problem boundaries - what is included and what is excluded]
- **Affected People**: [Who experiences this problem]
- **Context of Occurrence**: [When and where it occurs]
- **Frequency**: [How often it occurs]
- **Severity**: [How severe it is]

### Root Cause Analysis

- **Primary Causes**:
  - **Cause 1**: [Description]
    - **Evidence**: [Data supporting this cause]
    - **Relationships**: [Connections with other causes]
  - **Cause 2**: [Description]
    - ...

- **Secondary Causes**:
  - **Cause 1**: [Description]
    - **Evidence**: [Data supporting this cause]
    - **Relationships**: [Connections with other causes]
  - **Cause 2**: [Description]
    - ...

- **Cause-Effect Diagram**: [Description of the Ishikawa/fishbone diagram]

### Problem Impact

- **Impact on Users**:
  - **Segment 1**: [How it impacts this segment]
  - **Segment 2**: [How it impacts this segment]

- **Impact on Business**:
  - **Financial**: [Financial impact]
  - **Operational**: [Impact on operations]
  - **Reputational**: [Impact on reputation/brand]
  - **Strategic**: [Impact on strategic objectives]

- **Costs of Not Solving**:
  - **Short-term Costs**: [Immediate costs]
  - **Long-term Costs**: [Future costs]
  - **Intangible Costs**: [Non-quantifiable costs]

## Evaluation Framework

### Success Criteria

- **Criterion 1**: [Description]
  - **Metric**: [How it will be measured]
  - **Current Value**: [Current value]
  - **Target Value**: [Desired value]
  - **Justification**: [Why this criterion is important]

- **Criterion 2**: [Description]
  - ...

### Constraints and Limitations

- **Technical Constraints**: [Technical limitations]
- **Resource Constraints**: [Budget, personnel limitations, etc.]
- **Time Constraints**: [Deadlines or timeframes]
- **Regulatory Constraints**: [Legal or regulatory requirements]
- **Organizational Constraints**: [Internal policies or procedures]

### Special Considerations

- **Potential Risks**: [Risks associated with solving this problem]
- **Interdependencies**: [Relationship with other problems or projects]
- **Critical Success Factors**: [Elements necessary to solve the problem]
- **Assumptions**: [Important assumptions made]

## Opportunities and Solution Space

### Identified Opportunities

- **Opportunity 1**: [Description]
  - **Advantages**: [Potential benefits]
  - **Challenges**: [Potential difficulties]
  - **Benefited Segments**: [Who would benefit]
  - **Potential Value**: [Value that could be generated]

- **Opportunity 2**: [Description]
  - ...

### Potential Approaches

- **Approach 1**: [General description of the approach]
  - **Advantages**: [Benefits of this approach]
  - **Disadvantages**: [Disadvantages of this approach]
  - **Feasibility**: [High/Medium/Low]
  - **Required Resources**: [What would be needed]

- **Approach 2**: [General description of the approach]
  - ...

### Benchmarking

- **Competitor Solution 1**: [How a competitor solves this problem]
  - **Strengths**: [What they do well]
  - **Weaknesses**: [What could be improved]
  - **Learnings**: [What we can learn]

- **Competitor Solution 2**: [How another competitor solves this problem]
  - ...

## Prioritization and Recommendations

### Opportunity Assessment

- **Prioritization Matrix**: [Criteria and scores]
- **Final Ranking**: [Ordered opportunities]
- **Justification**: [Reasons for this prioritization]

### Recommendations

- **Recommended Approach**: [Which approach is recommended]
- **Justification**: [Why this approach is recommended]
- **Next Steps**: [Immediate actions to take]
- **Preliminary Roadmap**: [General timeline vision]
- **Required Resources**: [What resources would be needed]

## Appendices

- **Data Sources**: [References of sources used]
- **Complete Interviews**: [Link to transcripts]
- **Detailed Analyses**: [Link to additional analyses]
- **Research Material**: [Link to materials used]
- **Diagrams and Models**: [Link to visual representations]

---

This template follows MECE principles by dividing the problem definition into mutually exclusive categories (context, definition, evaluation framework, opportunities, and prioritization) and collectively exhaustive (covering all aspects necessary to fully understand a problem and establish the basis for its solution).
