# User Research Template

## General Information

- **Project Name**: [Name]
- **Research Date**: [Date]
- **Responsible**: [Name of the responsible person]
- **Research Team**: [Team members]

## Research Objectives (MECE)

- **Primary Objectives**: [Main objectives of the research]
- **Secondary Objectives**: [Additional objectives]
- **Questions to Answer**: [Key questions the research should answer]
- **Expected Results**: [What is expected to be obtained from this research]

## Research Methodology

### Qualitative Methods

- **In-depth Interviews**: [Number, participant profile, structure]
- **Contextual Observation**: [Contexts observed, duration, focus]
- **Focus Groups**: [Number, size, composition, topics]
- **User Diaries**: [Duration, number of participants, instructions]
- **Usability Tests**: [Type of tests, evaluated tasks, metrics]

### Quantitative Methods

- **Surveys**: [Sample size, distribution method, response rate]
- **Usage Data Analysis**: [Data sources, metrics analyzed, period]
- **Card Sorting**: [Type (open/closed), number of participants, items]
- **Comparative Evaluations**: [Products compared, criteria, methodology]
- **A/B Testing**: [Variables tested, sample size, duration]

### Tools Used

- **Recruitment Tools**: [Tools used to recruit participants]
- **Analysis Software**: [Tools for data analysis]
- **Testing Tools**: [Software for usability testing]
- **Survey Platforms**: [Tools used for surveys]
- **Recording Tools**: [Equipment to document sessions]

## User Profiles (MECE)

### User Profile 1: [Profile Name]

- **Demographic Description**:
  - **Age**: [Age range]
  - **Gender**: [Distribution]
  - **Location**: [Geographic distribution]
  - **Education Level**: [Distribution]
  - **Income Level**: [Range]
  - **Occupation**: [Types of occupations]

- **Behavior**:
  - **Main Goals**: [What they seek to achieve]
  - **Frequent Tasks**: [Tasks they perform regularly]
  - **Context of Use**: [Where, when and how they would use the product]
  - **Frequency of Use**: [How often they would use the product]
  - **Devices Used**: [What devices they mainly use]
  - **Behavior Patterns**: [Observed patterns]

- **Attitudes and Motivations**:
  - **Main Motivations**: [What motivates them]
  - **Concerns**: [What worries them]
  - **Values**: [Values important to them]
  - **Aspirations**: [What they aspire to achieve]
  - **Aversions**: [What they avoid]
  - **Brand Preferences**: [Preferred brands]

- **Needs and Pain Points**:
  - **Unmet Needs**: [Needs not covered]
  - **Pain Points**: [Frustrations and problems]
  - **Obstacles**: [Barriers they face]
  - **Current Solutions**: [How they currently solve the problem]
  - **Limitations**: [Restrictions they have]
  - **Success Criteria**: [How they measure success]

### User Profile 2: [Profile Name]

...

## Key Findings (MECE)

### Behavior Patterns

- **Pattern 1**: [Description of the pattern]
  - **Evidence**: [Data supporting this pattern]
  - **Implications**: [What it means for the design]
  - **Affected Segments**: [Which profiles exhibit this pattern]
  
- **Pattern 2**: [Description of the pattern]
  - ...

### Identified Needs

- **Need 1**: [Description of the need]
  - **Priority**: [High/Medium/Low]
  - **Evidence**: [Data supporting this need]
  - **Affected Segments**: [Which profiles present this need]
  - **Opportunities**: [Possible solutions]
  
- **Need 2**: [Description of the need]
  - ...

### Barriers and Frustrations

- **Barrier 1**: [Description of the barrier]
  - **Impact**: [High/Medium/Low]
  - **Evidence**: [Data supporting this barrier]
  - **Affected Segments**: [Which profiles face this barrier]
  - **Possible Solutions**: [How it could be overcome]
  
- **Barrier 2**: [Description of the barrier]
  - ...

### Expectations and Aspirations

- **Expectation 1**: [Description of the expectation]
  - **Evidence**: [Data supporting this expectation]
  - **Related Segments**: [Which profiles have this expectation]
  - **Opportunities**: [How to meet this expectation]
  
- **Expectation 2**: [Description of the expectation]
  - ...

## Journey Map Analysis

### Journey Map for Profile 1: [Profile Name]

- **Stage 1**: [Stage name]
  - **Actions**: [What the user does]
  - **Thoughts**: [What the user thinks]
  - **Feelings**: [How the user feels]
  - **Pain Points**: [Frustrations at this stage]
  - **Opportunities**: [Possible improvements]
  
- **Stage 2**: [Stage name]
  - ...

- **Critical Moments**:
  - **Moment 1**: [Description of the critical moment]
  - **Moment 2**: [Description of the critical moment]

### Journey Map for Profile 2: [Profile Name]

...

## Insights and Opportunities

### Key Insights

- **Insight 1**: [Description of the insight]
  - **Evidence**: [Data supporting this insight]
  - **Implications**: [What it means for the product]
  - **Related Segments**: [Which profiles relate to this insight]
  
- **Insight 2**: [Description of the insight]
  - ...

### Design Opportunities

- **Opportunity 1**: [Description of the opportunity]
  - **Target Profile**: [Profile(s) for whom it is relevant]
  - **Potential Impact**: [High/Medium/Low]
  - **Implementation Complexity**: [High/Medium/Low]
  - **Relationship with Needs**: [Needs it addresses]
  
- **Opportunity 2**: [Description of the opportunity]
  - ...

### Opportunity Prioritization

- **Prioritization Matrix**: [Criteria used to prioritize]
- **Priority Opportunities**: [Prioritized list]
- **Justification**: [Reasons for this prioritization]

## Design Recommendations

- **Recommendation 1**: [Description of the recommendation]
  - **Justification**: [Why it is recommended]
  - **Application**: [Where to apply it in the product]
  - **Considerations**: [Aspects to take into account]
  
- **Recommendation 2**: [Description of the recommendation]
  - ...

## Next Steps

- **Additional Research**: [Areas requiring more research]
- **Necessary Validations**: [Aspects to validate]
- **Next Activities**: [Next planned activities]
- **Timeline**: [Proposed dates]

## Appendices

- **Interview Guides**: [Link to the guides used]
- **Transcripts**: [Link to transcripts]
- **Raw Data**: [Link to unprocessed data]
- **Recordings**: [Link to session recordings]
- **Visual Materials**: [Link to materials used]
- **Complete Surveys**: [Link to complete surveys]

---

This template follows MECE principles by dividing user research into mutually exclusive categories (methodology, user profiles, findings, journey maps, insights/opportunities, and recommendations) and collectively exhaustive (covering all critical aspects to understand users and their needs).
