---
title: "Market Research"
date: {{DATE}}
author: {{AUTHOR}}
status: "Draft"
version: "1.0"
last_updated: {{DATE}}
tags: ["market", "research", "analysis"]
---

# Market Research Template

## General Information

- **Project Name**: [Name]
- **Research Date**: [Date]
- **Responsible**: [Name of the responsible person]
- **Research Team**: [Team members]

## Research Objectives (MECE)

- **Primary Objectives**: [Main objectives of the research]
- **Secondary Objectives**: [Additional objectives]
- **Questions to Answer**: [Key questions the research should answer]
- **Expected Results**: [What is expected to be obtained from this research]

## Market Analysis

### Market Size and Growth

- **Current Size**: [Market value in figures]
- **Growth Rate**: [Annual growth percentage]
- **5-Year Projections**: [Market size projection]
- **Growth Factors**: [Key factors driving growth]
- **Growth Barriers**: [Factors limiting growth]

### Market Segmentation

- **Segment 1**: [Segment name]
  - **Description**: [Segment description]
  - **Size**: [Segment size]
  - **Key Characteristics**: [Distinctive characteristics]
  - **Specific Needs**: [Particular needs of this segment]
  - **Growth Potential**: [Potential of this segment]
  
- **Segment 2**: [Segment name]
  - ...

### Market Trends

- **Trend 1**: [Description of the trend]
  - **Impact**: [High/Medium/Low]
  - **Time Horizon**: [Short/Medium/Long term]
  - **Implications**: [How this trend affects the project]
  
- **Trend 2**: [Description of the trend]
  - ...

## Competition Analysis

### Direct Competitors

- **Competitor 1**: [Name]
  - **Description**: [Brief description]
  - **Market Share**: [Estimated percentage]
  - **Strengths**: [Main strengths]
  - **Weaknesses**: [Main weaknesses]
  - **Value Proposition**: [Their main value proposition]
  - **Pricing Strategy**: [How they set their prices]
  - **Distribution Channels**: [How they reach their customers]
  
- **Competitor 2**: [Name]
  - ...

### Indirect Competitors

- **Competitor 1**: [Name]
  - **Description**: [Brief description]
  - **Alternative Solution**: [How they solve the problem differently]
  - **Impact on Our Market**: [How they affect our target market]
  
- **Competitor 2**: [Name]
  - ...

### Competitive Map

- **Comparison Axes**: [Define the main axes for comparing competitors]
- **Competitor Positioning**: [Relative position of each competitor]
- **Differentiation Opportunities**: [Uncovered spaces in the market]
- **Competitive Threats**: [Main threats from competition]

## Customer Analysis

### Customer Profiles

- **Profile 1**: [Profile name]
  - **Demographics**: [Demographic characteristics]
  - **Behavior**: [Behavior patterns]
  - **Needs**: [Main needs]
  - **Pain Points**: [Problems or frustrations]
  - **Expectations**: [What they expect from a solution]
  - **Decision Process**: [How they make purchasing decisions]
  
- **Profile 2**: [Profile name]
  - ...

### Qualitative Research

- **Interviews Conducted**: [Number and type of interviews]
- **Key Findings**: [Main discoveries]
- **Relevant Quotes**: [Important verbatim quotes]
- **Identified Patterns**: [Patterns of behavior or needs]
- **Insights**: [Insights derived from the research]

### Quantitative Research

- **Surveys Conducted**: [Number and type of surveys]
- **Key Metrics**: [Main metrics obtained]
- **Significant Correlations**: [Important correlations]
- **Identified Segments**: [Segments derived from analysis]
- **Statistical Conclusions**: [Data-based conclusions]

## Opportunity Analysis

### Identified Opportunities

- **Opportunity 1**: [Description of the opportunity]
  - **Target Segment**: [Segment to which it applies]
  - **Estimated Size**: [Potential size]
  - **Entry Barriers**: [Difficulties in leveraging it]
  - **Success Factors**: [Elements necessary for success]
  
- **Opportunity 2**: [Description of the opportunity]
  - ...

### Prioritization of Opportunities

- **Evaluation Criteria**: [Criteria used to prioritize]
- **Evaluation Matrix**: [Score of each opportunity according to criteria]
- **Priority Opportunities**: [Prioritized list of opportunities]
- **Justification**: [Reasons for this prioritization]

## Strategic Recommendations

- **Segments to Prioritize**: [Which market segments to prioritize]
- **Recommended Value Proposition**: [Suggested value proposition]
- **Key Differentiators**: [How to differentiate from competition]
- **Go-to-Market Approach**: [Recommended strategy to reach the market]
- **Pricing Considerations**: [Recommendations on pricing]
- **Risks to Consider**: [Potential risks identified]

## Next Steps

- **Additional Research Required**: [Areas requiring further research]
- **Necessary Validations**: [Hypotheses that need validation]
- **Immediate Actions**: [Actions to take immediately]
- **Suggested Timeline**: [Recommended timeframes]

## Appendices

- **Data Sources**: [References to sources used]
- **Detailed Methodology**: [Description of the methodology used]
- **Complete Data**: [Link to complete data]
- **Transcribed Interviews**: [Link to transcriptions]
- **Research Materials**: [Link to materials used]

---

This template follows MECE principles by dividing market research into mutually exclusive categories (market analysis, competition, customers, and opportunities) and collectively exhaustive (covering all relevant aspects to understand the market potential of a product).
