from typing import Any, Callable, Protocol
from webcompy.elements._dom_objs import DOMNode, DOMEvent

class PyScriptBrowserModule(Protocol):
    pyodide: Any
    addEventListener: Any
    alert: Any
    app: Any
    atob: Any
    blur: Any
    btoa: Any
    caches: Any
    cancelAnimationFrame: Any
    cancelIdleCallback: Any
    captureEvents: Any
    chrome: Any
    clearInterval: Any
    clearTimeout: Any
    clientInformation: Any
    close: Any
    closed: Any
    confirm: Any
    console: Any
    constructor: Any
    cookieStore: Any
    createImageBitmap: Any
    crossOriginIsolated: Any
    crypto: Any
    customElements: Any
    decodeURI: Any
    decodeURIComponent: Any
    defaultStatus: Any
    defaultstatus: Any
    devicePixelRatio: Any
    dispatchEvent: Any
    document: Any
    encodeURI: Any
    encodeURIComponent: Any
    escape: Any
    eval: Any
    event: Any
    external: Any
    fetch: Any
    find: Any
    focus: Any
    frameElement: Any
    frames: Any
    getComputedStyle: Any
    getScreenDetails: Any
    getSelection: Any
    globalThis: Any
    hasOwnProperty: Any
    history: Any
    indexedDB: Any
    innerHeight: Any
    innerWidth: Any
    isFinite: Any
    isNaN: Any
    isPrototypeOf: Any
    isSecureContext: Any
    length: Any
    loadPyodide: Any
    localStorage: Any
    location: Any
    locationbar: Any
    matchMedia: Any
    menubar: Any
    moveBy: Any
    moveTo: Any
    name: Any
    navigator: Any
    object_entries: Any
    object_keys: Any
    object_values: Any
    offscreenBuffering: Any
    onabort: Any
    onafterprint: Any
    onanimationend: Any
    onanimationiteration: Any
    onanimationstart: Any
    onappinstalled: Any
    onauxclick: Any
    onbeforeinstallprompt: Any
    onbeforeprint: Any
    onbeforeunload: Any
    onbeforexrselect: Any
    onblur: Any
    oncancel: Any
    oncanplay: Any
    oncanplaythrough: Any
    onchange: Any
    onclick: Any
    onclose: Any
    oncontextlost: Any
    oncontextmenu: Any
    oncontextrestored: Any
    oncuechange: Any
    ondblclick: Any
    ondevicemotion: Any
    ondeviceorientation: Any
    ondeviceorientationabsolute: Any
    ondrag: Any
    ondragend: Any
    ondragenter: Any
    ondragleave: Any
    ondragover: Any
    ondragstart: Any
    ondrop: Any
    ondurationchange: Any
    onemptied: Any
    onended: Any
    onerror: Any
    onfocus: Any
    onformdata: Any
    ongotpointercapture: Any
    onhashchange: Any
    oninput: Any
    oninvalid: Any
    onkeydown: Any
    onkeypress: Any
    onkeyup: Any
    onlanguagechange: Any
    onload: Any
    onloadeddata: Any
    onloadedmetadata: Any
    onloadstart: Any
    onlostpointercapture: Any
    onmessage: Any
    onmessageerror: Any
    onmousedown: Any
    onmouseenter: Any
    onmouseleave: Any
    onmousemove: Any
    onmouseout: Any
    onmouseover: Any
    onmouseup: Any
    onmousewheel: Any
    onoffline: Any
    ononline: Any
    onpagehide: Any
    onpageshow: Any
    onpause: Any
    onplay: Any
    onplaying: Any
    onpointercancel: Any
    onpointerdown: Any
    onpointerenter: Any
    onpointerleave: Any
    onpointermove: Any
    onpointerout: Any
    onpointerover: Any
    onpointerrawupdate: Any
    onpointerup: Any
    onpopstate: Any
    onprogress: Any
    onratechange: Any
    onrejectionhandled: Any
    onreset: Any
    onresize: Any
    onscroll: Any
    onsearch: Any
    onsecuritypolicyviolation: Any
    onseeked: Any
    onseeking: Any
    onselect: Any
    onselectionchange: Any
    onselectstart: Any
    onslotchange: Any
    onstalled: Any
    onstorage: Any
    onsubmit: Any
    onsuspend: Any
    ontimeupdate: Any
    ontoggle: Any
    ontransitioncancel: Any
    ontransitionend: Any
    ontransitionrun: Any
    ontransitionstart: Any
    onunhandledrejection: Any
    onunload: Any
    onvolumechange: Any
    onwaiting: Any
    onwebkitanimationend: Any
    onwebkitanimationiteration: Any
    onwebkitanimationstart: Any
    onwebkittransitionend: Any
    onwheel: Any
    open: Any
    openDatabase: Any
    opener: Any
    origin: Any
    originAgentCluster: Any
    outerHeight: Any
    outerWidth: Any
    pageXOffset: Any
    pageYOffset: Any
    parent: Any
    parseFloat: Any
    parseInt: Any
    performance: Any
    personalbar: Any
    postMessage: Any
    print: Any
    prompt: Any
    propertyIsEnumerable: Any
    queueMicrotask: Any
    releaseEvents: Any
    removeEventListener: Any
    reportError: Any
    requestAnimationFrame: Any
    requestIdleCallback: Any
    resizeBy: Any
    resizeTo: Any
    scheduler: Any
    screen: Any
    screenLeft: Any
    screenTop: Any
    screenX: Any
    screenY: Any
    scroll: Any
    scrollBy: Any
    scrollTo: Any
    scrollX: Any
    scrollY: Any
    scrollbars: Any
    self: Any
    sessionStorage: Any
    setInterval: Any
    setTimeout: Any
    showDirectoryPicker: Any
    showOpenFilePicker: Any
    showSaveFilePicker: Any
    speechSynthesis: Any
    status: Any
    statusbar: Any
    stop: Any
    structuredClone: Any
    styleMedia: Any
    toLocaleString: Any
    toString: Any
    to_py: Any
    toolbar: Any
    top: Any
    trustedTypes: Any
    typeof: Any
    undefined: Any
    unescape: Any
    valueOf: Any
    visualViewport: Any
    webkitCancelAnimationFrame: Any
    webkitMediaStream: Any
    webkitRTCPeerConnection: Any
    webkitRequestAnimationFrame: Any
    webkitRequestFileSystem: Any
    webkitResolveLocalFileSystemURL: Any
    webkitSpeechGrammar: Any
    webkitSpeechGrammarList: Any
    webkitSpeechRecognition: Any
    webkitSpeechRecognitionError: Any
    webkitSpeechRecognitionEvent: Any
    webkitStorageInfo: Any
    webkitURL: Any
    window: Any
    AbortController: Any
    AbortSignal: Any
    AbsoluteOrientationSensor: Any
    AbstractRange: Any
    Accelerometer: Any
    AggregateError: Any
    AnalyserNode: Any
    Animation: Any
    AnimationEffect: Any
    AnimationEvent: Any
    AnimationPlaybackEvent: Any
    AnimationTimeline: Any
    Array: Any
    ArrayBuffer: Any
    Atomics: Any
    Attr: Any
    Audio: Any
    AudioBuffer: Any
    AudioBufferSourceNode: Any
    AudioContext: Any
    AudioData: Any
    AudioDecoder: Any
    AudioDestinationNode: Any
    AudioEncoder: Any
    AudioListener: Any
    AudioNode: Any
    AudioParam: Any
    AudioParamMap: Any
    AudioProcessingEvent: Any
    AudioScheduledSourceNode: Any
    AudioWorklet: Any
    AudioWorkletNode: Any
    AuthenticatorAssertionResponse: Any
    AuthenticatorAttestationResponse: Any
    AuthenticatorResponse: Any
    BackgroundFetchManager: Any
    BackgroundFetchRecord: Any
    BackgroundFetchRegistration: Any
    BarProp: Any
    BaseAudioContext: Any
    BatteryManager: Any
    BeforeInstallPromptEvent: Any
    BeforeUnloadEvent: Any
    BigInt: Any
    BigInt64Array: Any
    BigUint64Array: Any
    BiquadFilterNode: Any
    Blob: Any
    BlobEvent: Any
    Bluetooth: Any
    BluetoothCharacteristicProperties: Any
    BluetoothDevice: Any
    BluetoothRemoteGATTCharacteristic: Any
    BluetoothRemoteGATTDescriptor: Any
    BluetoothRemoteGATTServer: Any
    BluetoothRemoteGATTService: Any
    BluetoothUUID: Any
    Boolean: Any
    BroadcastChannel: Any
    ByteLengthQueuingStrategy: Any
    CDATASection: Any
    CSS: Any
    CSSAnimation: Any
    CSSConditionRule: Any
    CSSCounterStyleRule: Any
    CSSFontFaceRule: Any
    CSSFontPaletteValuesRule: Any
    CSSGroupingRule: Any
    CSSImageValue: Any
    CSSImportRule: Any
    CSSKeyframeRule: Any
    CSSKeyframesRule: Any
    CSSKeywordValue: Any
    CSSLayerBlockRule: Any
    CSSLayerStatementRule: Any
    CSSMathClamp: Any
    CSSMathInvert: Any
    CSSMathMax: Any
    CSSMathMin: Any
    CSSMathNegate: Any
    CSSMathProduct: Any
    CSSMathSum: Any
    CSSMathValue: Any
    CSSMatrixComponent: Any
    CSSMediaRule: Any
    CSSNamespaceRule: Any
    CSSNumericArray: Any
    CSSNumericValue: Any
    CSSPageRule: Any
    CSSPerspective: Any
    CSSPositionValue: Any
    CSSPropertyRule: Any
    CSSRotate: Any
    CSSRule: Any
    CSSRuleList: Any
    CSSScale: Any
    CSSSkew: Any
    CSSSkewX: Any
    CSSSkewY: Any
    CSSStyleDeclaration: Any
    CSSStyleRule: Any
    CSSStyleSheet: Any
    CSSStyleValue: Any
    CSSSupportsRule: Any
    CSSTransformComponent: Any
    CSSTransformValue: Any
    CSSTransition: Any
    CSSTranslate: Any
    CSSUnitValue: Any
    CSSUnparsedValue: Any
    CSSVariableReferenceValue: Any
    Cache: Any
    CacheStorage: Any
    CanvasCaptureMediaStreamTrack: Any
    CanvasFilter: Any
    CanvasGradient: Any
    CanvasPattern: Any
    CanvasRenderingContext2D: Any
    ChannelMergerNode: Any
    ChannelSplitterNode: Any
    CharacterData: Any
    Clipboard: Any
    ClipboardEvent: Any
    ClipboardItem: Any
    CloseEvent: Any
    Comment: Any
    CompositionEvent: Any
    CompressionStream: Any
    ConstantSourceNode: Any
    ConvolverNode: Any
    CookieChangeEvent: Any
    CookieStore: Any
    CookieStoreManager: Any
    CountQueuingStrategy: Any
    Credential: Any
    CredentialsContainer: Any
    Crypto: Any
    CryptoKey: Any
    CustomElementRegistry: Any
    CustomEvent: Any
    CustomStateSet: Any
    DOMError: Any
    DOMException: Any
    DOMImplementation: Any
    DOMMatrix: Any
    DOMMatrixReadOnly: Any
    DOMParser: Any
    DOMPoint: Any
    DOMPointReadOnly: Any
    DOMQuad: Any
    DOMRect: Any
    DOMRectList: Any
    DOMRectReadOnly: Any
    DOMStringList: Any
    DOMStringMap: Any
    DOMTokenList: Any
    DataTransfer: Any
    DataTransferItem: Any
    DataTransferItemList: Any
    DataView: Any
    Date: Any
    DecompressionStream: Any
    DelayNode: Any
    DelegatedInkTrailPresenter: Any
    DeviceMotionEvent: Any
    DeviceMotionEventAcceleration: Any
    DeviceMotionEventRotationRate: Any
    DeviceOrientationEvent: Any
    Document: Any
    DocumentFragment: Any
    DocumentTimeline: Any
    DocumentType: Any
    DragEvent: Any
    DynamicsCompressorNode: Any
    Element: Any
    ElementInternals: Any
    EncodedAudioChunk: Any
    EncodedVideoChunk: Any
    Error: Any
    ErrorEvent: Any
    EvalError: Any
    Event: Any
    EventCounts: Any
    EventSource: Any
    EventTarget: Any
    External: Any
    EyeDropper: Any
    FeaturePolicy: Any
    FederatedCredential: Any
    File: Any
    FileList: Any
    FileReader: Any
    FileSystemDirectoryHandle: Any
    FileSystemFileHandle: Any
    FileSystemHandle: Any
    FileSystemWritableFileStream: Any
    FinalizationRegistry: Any
    Float32Array: Any
    Float64Array: Any
    FocusEvent: Any
    FontFace: Any
    FontFaceSetLoadEvent: Any
    FormData: Any
    FormDataEvent: Any
    FragmentDirective: Any
    Function: Any
    GainNode: Any
    Gamepad: Any
    GamepadButton: Any
    GamepadEvent: Any
    GamepadHapticActuator: Any
    Geolocation: Any
    GeolocationCoordinates: Any
    GeolocationPosition: Any
    GeolocationPositionError: Any
    GravitySensor: Any
    Gyroscope: Any
    HID: Any
    HIDConnectionEvent: Any
    HIDDevice: Any
    HIDInputReportEvent: Any
    HTMLAllCollection: Any
    HTMLAnchorElement: Any
    HTMLAreaElement: Any
    HTMLAudioElement: Any
    HTMLBRElement: Any
    HTMLBaseElement: Any
    HTMLBodyElement: Any
    HTMLButtonElement: Any
    HTMLCanvasElement: Any
    HTMLCollection: Any
    HTMLDListElement: Any
    HTMLDataElement: Any
    HTMLDataListElement: Any
    HTMLDetailsElement: Any
    HTMLDialogElement: Any
    HTMLDirectoryElement: Any
    HTMLDivElement: Any
    HTMLDocument: Any
    HTMLElement: Any
    HTMLEmbedElement: Any
    HTMLFieldSetElement: Any
    HTMLFontElement: Any
    HTMLFormControlsCollection: Any
    HTMLFormElement: Any
    HTMLFrameElement: Any
    HTMLFrameSetElement: Any
    HTMLHRElement: Any
    HTMLHeadElement: Any
    HTMLHeadingElement: Any
    HTMLHtmlElement: Any
    HTMLIFrameElement: Any
    HTMLImageElement: Any
    HTMLInputElement: Any
    HTMLLIElement: Any
    HTMLLabelElement: Any
    HTMLLegendElement: Any
    HTMLLinkElement: Any
    HTMLMapElement: Any
    HTMLMarqueeElement: Any
    HTMLMediaElement: Any
    HTMLMenuElement: Any
    HTMLMetaElement: Any
    HTMLMeterElement: Any
    HTMLModElement: Any
    HTMLOListElement: Any
    HTMLObjectElement: Any
    HTMLOptGroupElement: Any
    HTMLOptionElement: Any
    HTMLOptionsCollection: Any
    HTMLOutputElement: Any
    HTMLParagraphElement: Any
    HTMLParamElement: Any
    HTMLPictureElement: Any
    HTMLPreElement: Any
    HTMLProgressElement: Any
    HTMLQuoteElement: Any
    HTMLScriptElement: Any
    HTMLSelectElement: Any
    HTMLSlotElement: Any
    HTMLSourceElement: Any
    HTMLSpanElement: Any
    HTMLStyleElement: Any
    HTMLTableCaptionElement: Any
    HTMLTableCellElement: Any
    HTMLTableColElement: Any
    HTMLTableElement: Any
    HTMLTableRowElement: Any
    HTMLTableSectionElement: Any
    HTMLTemplateElement: Any
    HTMLTextAreaElement: Any
    HTMLTimeElement: Any
    HTMLTitleElement: Any
    HTMLTrackElement: Any
    HTMLUListElement: Any
    HTMLUnknownElement: Any
    HTMLVideoElement: Any
    HashChangeEvent: Any
    Headers: Any
    History: Any
    IDBCursor: Any
    IDBCursorWithValue: Any
    IDBDatabase: Any
    IDBFactory: Any
    IDBIndex: Any
    IDBKeyRange: Any
    IDBObjectStore: Any
    IDBOpenDBRequest: Any
    IDBRequest: Any
    IDBTransaction: Any
    IDBVersionChangeEvent: Any
    IIRFilterNode: Any
    IdleDeadline: Any
    Image: Any
    ImageBitmap: Any
    ImageBitmapRenderingContext: Any
    ImageCapture: Any
    ImageData: Any
    ImageDecoder: Any
    ImageTrack: Any
    ImageTrackList: Any
    Infinity: Any
    Ink: Any
    InputDeviceCapabilities: Any
    InputDeviceInfo: Any
    InputEvent: Any
    Int16Array: Any
    Int32Array: Any
    Int8Array: Any
    IntersectionObserver: Any
    IntersectionObserverEntry: Any
    Intl: Any
    JSON: Any
    Keyboard: Any
    KeyboardEvent: Any
    KeyboardLayoutMap: Any
    KeyframeEffect: Any
    LargestContentfulPaint: Any
    LayoutShift: Any
    LayoutShiftAttribution: Any
    LinearAccelerationSensor: Any
    Location: Any
    Lock: Any
    LockManager: Any
    MIDIAccess: Any
    MIDIConnectionEvent: Any
    MIDIInput: Any
    MIDIInputMap: Any
    MIDIMessageEvent: Any
    MIDIOutput: Any
    MIDIOutputMap: Any
    MIDIPort: Any
    Map: Any
    Math: Any
    MediaCapabilities: Any
    MediaDeviceInfo: Any
    MediaDevices: Any
    MediaElementAudioSourceNode: Any
    MediaEncryptedEvent: Any
    MediaError: Any
    MediaKeyMessageEvent: Any
    MediaKeySession: Any
    MediaKeyStatusMap: Any
    MediaKeySystemAccess: Any
    MediaKeys: Any
    MediaList: Any
    MediaMetadata: Any
    MediaQueryList: Any
    MediaQueryListEvent: Any
    MediaRecorder: Any
    MediaSession: Any
    MediaSource: Any
    MediaStream: Any
    MediaStreamAudioDestinationNode: Any
    MediaStreamAudioSourceNode: Any
    MediaStreamEvent: Any
    MediaStreamTrack: Any
    MediaStreamTrackEvent: Any
    MediaStreamTrackGenerator: Any
    MediaStreamTrackProcessor: Any
    MessageChannel: Any
    MessageEvent: Any
    MessagePort: Any
    MimeType: Any
    MimeTypeArray: Any
    MouseEvent: Any
    MutationEvent: Any
    MutationObserver: Any
    MutationRecord: Any
    NaN: Any
    NamedNodeMap: Any
    NavigationPreloadManager: Any
    Navigator: Any
    NavigatorManagedData: Any
    NavigatorUAData: Any
    NetworkInformation: Any
    Node: Any
    NodeFilter: Any
    NodeIterator: Any
    NodeList: Any
    Notification: Any
    Number: Any
    OTPCredential: Any
    Object: Any
    OfflineAudioCompletionEvent: Any
    OfflineAudioContext: Any
    OffscreenCanvas: Any
    OffscreenCanvasRenderingContext2D: Any
    Option: Any
    OrientationSensor: Any
    OscillatorNode: Any
    OverconstrainedError: Any
    PERSISTENT: Any
    PageTransitionEvent: Any
    PannerNode: Any
    PasswordCredential: Any
    Path2D: Any
    PaymentAddress: Any
    PaymentInstruments: Any
    PaymentManager: Any
    PaymentMethodChangeEvent: Any
    PaymentRequest: Any
    PaymentRequestUpdateEvent: Any
    PaymentResponse: Any
    Performance: Any
    PerformanceElementTiming: Any
    PerformanceEntry: Any
    PerformanceEventTiming: Any
    PerformanceLongTaskTiming: Any
    PerformanceMark: Any
    PerformanceMeasure: Any
    PerformanceNavigation: Any
    PerformanceNavigationTiming: Any
    PerformanceObserver: Any
    PerformanceObserverEntryList: Any
    PerformancePaintTiming: Any
    PerformanceResourceTiming: Any
    PerformanceServerTiming: Any
    PerformanceTiming: Any
    PeriodicSyncManager: Any
    PeriodicWave: Any
    PermissionStatus: Any
    Permissions: Any
    PictureInPictureEvent: Any
    PictureInPictureWindow: Any
    Plugin: Any
    PluginArray: Any
    PointerEvent: Any
    PopStateEvent: Any
    Presentation: Any
    PresentationAvailability: Any
    PresentationConnection: Any
    PresentationConnectionAvailableEvent: Any
    PresentationConnectionCloseEvent: Any
    PresentationConnectionList: Any
    PresentationReceiver: Any
    PresentationRequest: Any
    ProcessingInstruction: Any
    Profiler: Any
    ProgressEvent: Any
    Promise: Any
    PromiseRejectionEvent: Any
    Proxy: Any
    PublicKeyCredential: Any
    PushManager: Any
    PushSubscription: Any
    PushSubscriptionOptions: Any
    RTCCertificate: Any
    RTCDTMFSender: Any
    RTCDTMFToneChangeEvent: Any
    RTCDataChannel: Any
    RTCDataChannelEvent: Any
    RTCDtlsTransport: Any
    RTCEncodedAudioFrame: Any
    RTCEncodedVideoFrame: Any
    RTCError: Any
    RTCErrorEvent: Any
    RTCIceCandidate: Any
    RTCIceTransport: Any
    RTCPeerConnection: Any
    RTCPeerConnectionIceErrorEvent: Any
    RTCPeerConnectionIceEvent: Any
    RTCRtpReceiver: Any
    RTCRtpSender: Any
    RTCRtpTransceiver: Any
    RTCSctpTransport: Any
    RTCSessionDescription: Any
    RTCStatsReport: Any
    RTCTrackEvent: Any
    RadioNodeList: Any
    Range: Any
    RangeError: Any
    ReadableByteStreamController: Any
    ReadableStream: Any
    ReadableStreamBYOBReader: Any
    ReadableStreamBYOBRequest: Any
    ReadableStreamDefaultController: Any
    ReadableStreamDefaultReader: Any
    ReferenceError: Any
    Reflect: Any
    RegExp: Any
    RelativeOrientationSensor: Any
    RemotePlayback: Any
    ReportingObserver: Any
    Request: Any
    ResizeObserver: Any
    ResizeObserverEntry: Any
    ResizeObserverSize: Any
    Response: Any
    SVGAElement: Any
    SVGAngle: Any
    SVGAnimateElement: Any
    SVGAnimateMotionElement: Any
    SVGAnimateTransformElement: Any
    SVGAnimatedAngle: Any
    SVGAnimatedBoolean: Any
    SVGAnimatedEnumeration: Any
    SVGAnimatedInteger: Any
    SVGAnimatedLength: Any
    SVGAnimatedLengthList: Any
    SVGAnimatedNumber: Any
    SVGAnimatedNumberList: Any
    SVGAnimatedPreserveAspectRatio: Any
    SVGAnimatedRect: Any
    SVGAnimatedString: Any
    SVGAnimatedTransformList: Any
    SVGAnimationElement: Any
    SVGCircleElement: Any
    SVGClipPathElement: Any
    SVGComponentTransferFunctionElement: Any
    SVGDefsElement: Any
    SVGDescElement: Any
    SVGElement: Any
    SVGEllipseElement: Any
    SVGFEBlendElement: Any
    SVGFEColorMatrixElement: Any
    SVGFEComponentTransferElement: Any
    SVGFECompositeElement: Any
    SVGFEConvolveMatrixElement: Any
    SVGFEDiffuseLightingElement: Any
    SVGFEDisplacementMapElement: Any
    SVGFEDistantLightElement: Any
    SVGFEDropShadowElement: Any
    SVGFEFloodElement: Any
    SVGFEFuncAElement: Any
    SVGFEFuncBElement: Any
    SVGFEFuncGElement: Any
    SVGFEFuncRElement: Any
    SVGFEGaussianBlurElement: Any
    SVGFEImageElement: Any
    SVGFEMergeElement: Any
    SVGFEMergeNodeElement: Any
    SVGFEMorphologyElement: Any
    SVGFEOffsetElement: Any
    SVGFEPointLightElement: Any
    SVGFESpecularLightingElement: Any
    SVGFESpotLightElement: Any
    SVGFETileElement: Any
    SVGFETurbulenceElement: Any
    SVGFilterElement: Any
    SVGForeignObjectElement: Any
    SVGGElement: Any
    SVGGeometryElement: Any
    SVGGradientElement: Any
    SVGGraphicsElement: Any
    SVGImageElement: Any
    SVGLength: Any
    SVGLengthList: Any
    SVGLineElement: Any
    SVGLinearGradientElement: Any
    SVGMPathElement: Any
    SVGMarkerElement: Any
    SVGMaskElement: Any
    SVGMatrix: Any
    SVGMetadataElement: Any
    SVGNumber: Any
    SVGNumberList: Any
    SVGPathElement: Any
    SVGPatternElement: Any
    SVGPoint: Any
    SVGPointList: Any
    SVGPolygonElement: Any
    SVGPolylineElement: Any
    SVGPreserveAspectRatio: Any
    SVGRadialGradientElement: Any
    SVGRect: Any
    SVGRectElement: Any
    SVGSVGElement: Any
    SVGScriptElement: Any
    SVGSetElement: Any
    SVGStopElement: Any
    SVGStringList: Any
    SVGStyleElement: Any
    SVGSwitchElement: Any
    SVGSymbolElement: Any
    SVGTSpanElement: Any
    SVGTextContentElement: Any
    SVGTextElement: Any
    SVGTextPathElement: Any
    SVGTextPositioningElement: Any
    SVGTitleElement: Any
    SVGTransform: Any
    SVGTransformList: Any
    SVGUnitTypes: Any
    SVGUseElement: Any
    SVGViewElement: Any
    Scheduler: Any
    Scheduling: Any
    Screen: Any
    ScreenDetailed: Any
    ScreenDetails: Any
    ScreenOrientation: Any
    ScriptProcessorNode: Any
    SecurityPolicyViolationEvent: Any
    Selection: Any
    Sensor: Any
    SensorErrorEvent: Any
    Serial: Any
    SerialPort: Any
    ServiceWorker: Any
    ServiceWorkerContainer: Any
    ServiceWorkerRegistration: Any
    Set: Any
    ShadowRoot: Any
    SharedWorker: Any
    SourceBuffer: Any
    SourceBufferList: Any
    SpeechSynthesisErrorEvent: Any
    SpeechSynthesisEvent: Any
    SpeechSynthesisUtterance: Any
    StaticRange: Any
    StereoPannerNode: Any
    Storage: Any
    StorageEvent: Any
    StorageManager: Any
    String: Any
    StylePropertyMap: Any
    StylePropertyMapReadOnly: Any
    StyleSheet: Any
    StyleSheetList: Any
    SubmitEvent: Any
    SubtleCrypto: Any
    Symbol: Any
    SyncManager: Any
    SyntaxError: Any
    TEMPORARY: Any
    TaskAttributionTiming: Any
    TaskController: Any
    TaskPriorityChangeEvent: Any
    TaskSignal: Any
    Text: Any
    TextDecoder: Any
    TextDecoderStream: Any
    TextEncoder: Any
    TextEncoderStream: Any
    TextEvent: Any
    TextMetrics: Any
    TextTrack: Any
    TextTrackCue: Any
    TextTrackCueList: Any
    TextTrackList: Any
    TimeRanges: Any
    Touch: Any
    TouchEvent: Any
    TouchList: Any
    TrackEvent: Any
    TransformStream: Any
    TransitionEvent: Any
    TreeWalker: Any
    TrustedHTML: Any
    TrustedScript: Any
    TrustedScriptURL: Any
    TrustedTypePolicy: Any
    TrustedTypePolicyFactory: Any
    TypeError: Any
    UIEvent: Any
    URIError: Any
    URL: Any
    URLPattern: Any
    URLSearchParams: Any
    USB: Any
    USBAlternateInterface: Any
    USBConfiguration: Any
    USBConnectionEvent: Any
    USBDevice: Any
    USBEndpoint: Any
    USBInTransferResult: Any
    USBInterface: Any
    USBIsochronousInTransferPacket: Any
    USBIsochronousInTransferResult: Any
    USBIsochronousOutTransferPacket: Any
    USBIsochronousOutTransferResult: Any
    USBOutTransferResult: Any
    Uint16Array: Any
    Uint32Array: Any
    Uint8Array: Any
    Uint8ClampedArray: Any
    UserActivation: Any
    VTTCue: Any
    ValidityState: Any
    VideoColorSpace: Any
    VideoDecoder: Any
    VideoEncoder: Any
    VideoFrame: Any
    VideoPlaybackQuality: Any
    VirtualKeyboard: Any
    VirtualKeyboardGeometryChangeEvent: Any
    VisualViewport: Any
    WakeLock: Any
    WakeLockSentinel: Any
    WaveShaperNode: Any
    WeakMap: Any
    WeakRef: Any
    WeakSet: Any
    WebAssembly: Any
    WebGL2RenderingContext: Any
    WebGLActiveInfo: Any
    WebGLBuffer: Any
    WebGLContextEvent: Any
    WebGLFramebuffer: Any
    WebGLProgram: Any
    WebGLQuery: Any
    WebGLRenderbuffer: Any
    WebGLRenderingContext: Any
    WebGLSampler: Any
    WebGLShader: Any
    WebGLShaderPrecisionFormat: Any
    WebGLSync: Any
    WebGLTexture: Any
    WebGLTransformFeedback: Any
    WebGLUniformLocation: Any
    WebGLVertexArrayObject: Any
    WebKitCSSMatrix: Any
    WebKitMutationObserver: Any
    WebSocket: Any
    WebTransport: Any
    WebTransportBidirectionalStream: Any
    WebTransportDatagramDuplexStream: Any
    WebTransportError: Any
    WheelEvent: Any
    Window: Any
    Worker: Any
    Worklet: Any
    WritableStream: Any
    WritableStreamDefaultController: Any
    WritableStreamDefaultWriter: Any
    XMLDocument: Any
    XMLHttpRequest: Any
    XMLHttpRequestEventTarget: Any
    XMLHttpRequestUpload: Any
    XMLSerializer: Any
    XPathEvaluator: Any
    XPathExpression: Any
    XPathResult: Any
    XRAnchor: Any
    XRAnchorSet: Any
    XRBoundedReferenceSpace: Any
    XRCPUDepthInformation: Any
    XRDOMOverlayState: Any
    XRDepthInformation: Any
    XRFrame: Any
    XRHand: Any
    XRHitTestResult: Any
    XRHitTestSource: Any
    XRInputSource: Any
    XRInputSourceArray: Any
    XRInputSourceEvent: Any
    XRInputSourcesChangeEvent: Any
    XRJointPose: Any
    XRJointSpace: Any
    XRLayer: Any
    XRLightEstimate: Any
    XRLightProbe: Any
    XRPose: Any
    XRRay: Any
    XRReferenceSpace: Any
    XRReferenceSpaceEvent: Any
    XRRenderState: Any
    XRRigidTransform: Any
    XRSession: Any
    XRSessionEvent: Any
    XRSpace: Any
    XRSystem: Any
    XRTransientInputHitTestResult: Any
    XRTransientInputHitTestSource: Any
    XRView: Any
    XRViewerPose: Any
    XRViewport: Any
    XRWebGLBinding: Any
    XRWebGLDepthInformation: Any
    XRWebGLLayer: Any
    XSLTProcessor: Any

class BrythonBrowserModule(Protocol):
    class javascript(Protocol):
        py2js: Callable[[str], str]
        NULL: Any
        UNDEFINED: Any
        this: Any
        JSON: Any
        Math: Any
        RegExp: Any
        String: Any
    def alert(self, message: str) -> None:
        """A function that prints the message in a pop-up window.

        Args:
            message (str)
        """
        ...
    def confirm(self, message: str) -> bool:
        """A function that prints the message in a window, and two buttons (ok/cancel).
        Returns True if ok, False if cancel.

        Args:
            message (str)

        Returns:
            bool
        """
        ...
    def prompt(self, message: str, default: str = ...) -> str:
        """A function that prints the message in a window, and an entry field.
        Returns the entered value; if no value was entered, return default if defined, else the empty string.

        Args:
            message (str)
            default (str, optional): Defaults to "".

        Returns:
            str: the entered value
        """
        ...
    def load(self, script_url: str) -> None:
        """Load the Javascript library at address script_url.
        This function uses a blocking HttpClient call.
        It must be used when one can't load the Javascript library in the html page by <script src="prog.js"></script>.
        The names inserted by the library inside the global Javascript namespace are available
        in the Brython script as attributes of the window object.

        Args:
            script_url (str)
        """
        ...
    def run_script(self, src: str, name: str = ...) -> None:
        """this function executes the Python source code in src with an optional name.
        It can be used as an alternative to exec(),
        with the benefit that the indexedDB cache is used for importing modules from the standard library.

        Args:
            src (str): Python source code
        """
    def bind(
        self, target_element: "DOMNode", event: Callable[["DOMEvent"], None]
    ) -> None:
        """A function used as a decorator for event binding.

        Args:
            target_element (DOMNode)
            event (Callable[[DOMEvent], None])
        """
    def __getattr__(self, _: str) -> Any: ...

    console: Any
    document: DOMNode
    local_storage: Any
    markdown: Any
    object_storage: Any
    session_storage: Any
    svg: Any
    timer: Any
    websocket: Any
    window: Any
    worker: Any

browser_pyscript: PyScriptBrowserModule | None
browser_brython: BrythonBrowserModule | None
browser: Any | None
