# graphical_password
Модуль для Python, обеспечивающий информационную безопасность пользователей путем графической аутентификации. \
Проект доступен в open-source по ссылке https://github.com/macarell228/graphical_password

**Что умеет наша библиотека?**
> Хранит на серверах github сеты из 10 картинок в формате .avif в категориях: с бабочками (butterflies), с овощами (vegetables) или с котами (cats). Эти картинки можно взять в качестве набора для создания графического ключа. Как использовать:
> 
> `image_examples.get_link(имя_набора, номер_картинки (нумерация с 0))`

> Oбъединяет картинки в группы для удобной работы с ними. Как использовать:
>
> `group = Group_Image()`\
> `for picture_path in LIST_OF_YOUR_PICTURE_PATHS:` \
> `    group.add_to_group(Image(picture_path))` \
> `# Ваш пользователь выбрал картинку в группе под номером добавления 0 (нумерация с нуля)` \
> `group.trigger(0)` \
> `# Ваш пользователь выбрал еще несколько картинок в такой последовательности` \
> `group.trigger(3)` \
> `group.trigger(2)` \
> `group.trigger(6)` \
> `# Ваш пользователь снял выбор картинки с номером 2` \
> `group.trigger(2)` 

> Генерирует и хэширует (алгоритм sha-256 c солью) пароль по выбранным картинкам. Как использовать:
>
> `group.get_password()`

> Обрабатывает возникающие ошибки и дает понятные объяснения. Использовать не надо. В случае ошибки Python Вас об этом уведомит. (класс нашей ошибки - GPerror) \

**Пример использования библиотеки:**
> 
> `group = Group_Image()` \
> `for number in range(10):` \
> `    picture_path = get_link('cats', number)`\
> `    group.add_to_group(Image(picture_path))`\
> `# здесь код, в котором вы визуализируете данные для пользователя и настраиваете его взаимодействие с интерфейсом` \
> `# используете group.trigger(num)`\
> `password = group.get_password()`