# pytuist

A TUI (terminal user interface) for pytest

I personally love TUI tools - so why not learn how to make my own and create something that would be valuable for my day-to-day work?

## Installation

```
pip install pytuist
```

**Note** this package is only available for Windows at the moment. I will look to add support for Linux and MacOS in the future.

If someone could show me how on earth I specify that with Poetry, that would be great.

## Usage

Within a project with tests conforming to [pytest](https://docs.pytest.org/en/7.2.x/ "pytest homepage") requirements, run `pytuist` to start the UI within the active terminal:

```plaintext
╭─────────────────────────────────────────────────────────────────────────────────────────── pytuist ───────────────────────────────────────────────────────────────────────────────────────────╮
│ arrows: navigate | enter: expand/collapse | space: run | q: quit                                                                                                                              │
╰───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯
╭──────────────────── Tests ────────────────────╮ ╭────────────────────────────────────────────────────────────────── Output ───────────────────────────────────────────────────────────────────╮
│ test                                      [-] │ │ Run a test to see the output here                                                                                                           │
│ ├── test_root                             [-] │ ╰─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯
│ │   └── test_in_root                      [-] │
│ ├── test_root_again                       [-] │
│ │   └── test_another_in_root              [-] │
│ ├── child                                 [-] │
│ │   ├── test_child                        [-] │
│ │   │   ├── test_child                    [-] │
│ │   │   └── test_another_in_child         [-] │
│ │   └── grandchild                        [-] │
│ │       ├── test_another_grandchild       [-] │
│ │       │   ├── test_another_grandchild   [-] │
│ │       │   └── test_that_fails           [-] │
│ │       └── test_grandchild               [-] │
│ │           └── test_grandchild           [-] │
│ └── unit                                  [-] │
│     └── actual_test                       [-] │
│         ├── test_construct_test_hierarchy [-] │
│         └── test_render                   [-] │
╰───────────────────────────────────────────────╯
```

Navigate using arrow keys, press enter to expand/collapse folders, and space to run a test. Output generated by pytest will be shown in the output panel.

## Future Work

Current functionality is known to be minimal (and Windows-only), and I hope to continue expanding upon it and making the user experience as easy as possible.

I'm sure there are plenty of configurations where the intended highlighting and functionality doesn't work, so feel free to let me know what horrible bugs you encounter if you'd like to.

This was largely a project to help me become familiar with [rich](https://github.com/Textualize/rich "rich repo") and create TUI apps, so we'll see where it goes from here.
