# Foxglove - a firefox proxy profile manager

Foxglove is a Firefox profile and ssh proxy manager with two purposes:

1. Generate Firefox profiles with preferences that I consider desirable for the
   majority of use cases. These disable, where possible, Firefox's built-in
   advertising and pop-ups, telemetry, experiments, and similar features.

2. Optionally ssh to a remote host and configure the Firefox profile to use
   that connection as a SOCKS proxy.

Profiles generated by foxglove are stored in `~/.foxglove`.

```
usage: foxglove [-h] [--config path] [--chrome path] [--content path] [--options string] [-d] [-e] profile [host]

foxglove - a Firefox profile and proxy manager

positional arguments:
  profile           The name of the foxglove-managed profile to use or create
  host              ssh server hostname. If this option is given, foxglove will attempt to use ssh(1) with no additional arguments to
                    connect to the host and configure the browser to use it as a SOCKS proxy

optional arguments:
  -h, --help        show this help message and exit
  --config path     path to a specific ssh config file to use
  --chrome path     path to a userChrome.css file to add to the Firefox profile
  --content path    path to a userContent.css file to add to the Firefox profile
  --options string  additional options to pass to firefox. Space-separated options should be entered as a single (e.g., double-quoted)
                    argument. (--no-remote, --new-instance, and --profile <path> will be automatically prepended)
  -d                dry run (don't launch Firefox)
  -e                ephemeral browser profile (delete on exit)
```

To use the "host" argument, you would typically specify a Host entry in your
`~/.ssh/config` with the corresponding name and configure the username, etc. so
that you can ssh without additional arguments. The remote host must allow port forwarding.

Foxglove launches the browser via a subprocess call to "firefox". Setting PATH
prior to running foxglove can be used to launch a specific version of Firefox.

All foxglove data including profiles is stored in `~/.foxglove`, which will be
created on first run. Foxglove will not touch your regular Firefox profiles in
any way.

## user.js preferences
These settings have changed substantially during Firefox's development, so some
may be unsupported or meaningless in current versions.

Preference changes made to a foxglove-managed profile will reset to the value
in prefs.js on the next run. To retain changes, you can either use the
generated profile as a normal Firefox profile without foxglove, or modify your
installation of foxglove's prefs.js file with your desired preferences.

Some foxglove defaults to consider changing:

| Key                               | Default | Foxglove | Comments                                       |
| --------------------------------- | ------- | -------- | -----------------------------------------------|
| dom.event.clipboardevents.enabled | true    | false    | May break some sites                           |
| privacy.resistFingerprinting      | false   | false    | May break some sites; can be counterproductive |
| privacy.donottrackheader.enabled  | false   | true     | May be used for fingerprinting                 |
| network.trr.mode                  | 0       | 0        | TRRs can interfere with test environments      |
