"""
Documentation for command line tools
====================================

This module only contains the documentation of the subcommands used in the
command line interface.
For all the subcommands, a short help identical to that generated by the
`-h` option is shown. In addition, if present, the docstring of the
function is also shown here.

_subparsers_help_
"""

import re
import inspect
from .cli import _create_eparser

# Then we process the docstring in order to include the generated documentation
def _process_doc(doc):
    eparser = _create_eparser("bussilab")
    _subparsers_help_ = ""
    for name in eparser.subparsers_help.keys():
        _subparsers_help_ = (
            _subparsers_help_+"## "+name+"\n```text\n"+eparser.subparsers_help[name]+"```\n"
        )
        _subparsers_help_ = (
            _subparsers_help_+"\n" +
            inspect.cleandoc(eparser.subparsers_doc[name])+"\n"
        )
    doc = re.sub("_subparsers_help_", _subparsers_help_, doc)
    return doc

__doc__ = _process_doc(__doc__)
