from pathlib import Path

DOCKER_FOLDER_NAME = "docker"

REPO_ROOT_DIR_PATH = Path(__file__).resolve().parent.parent

TEMPLATES_FOLDER_NAME = "templates"
TEMPLATES_DIR_PATH = REPO_ROOT_DIR_PATH / TEMPLATES_FOLDER_NAME

DAGS_FOLDER_TEMPLATE_STRING = "DAGS_FOLDER"
TESTS_FOLDER_TEMPLATE_STRING = "TESTS_FOLDER"

DOCKER_COMPOSE_YML_FILE_NAME = "docker-compose.yml"
DOCKER_COMPOSE_YML_TEMPLATE_FILE_NAME = f"{DOCKER_COMPOSE_YML_FILE_NAME}.template"

DOCKER_COMPOSE_TESTS_YML_FILE_NAME = "docker-compose-tests.yml"
DOCKER_COMPOSE_TESTS_YML_TEMPLATE_FILE_NAME = (
    f"{DOCKER_COMPOSE_TESTS_YML_FILE_NAME}.template"
)

DOCKER_COMPOSE_DEV_YML_FILE_NAME = "docker-compose-dev.yml"
DOCKER_COMPOSE_DEV_YML_TEMPLATE_FILE_NAME = (
    f"{DOCKER_COMPOSE_DEV_YML_FILE_NAME}.template"
)

DOCKER_COMPOSE_MANUAL_TESTING_YML_FILE_NAME = "docker-compose-manual-testing.yml"
DOCKER_COMPOSE_MANUAL_TESTING_YML_TEMPLATE_FILE_NAME = (
    f"{DOCKER_COMPOSE_MANUAL_TESTING_YML_FILE_NAME}.template"
)

TEMPLATE_MAP = {
    DOCKER_COMPOSE_YML_TEMPLATE_FILE_NAME: DOCKER_COMPOSE_YML_FILE_NAME,
    DOCKER_COMPOSE_TESTS_YML_TEMPLATE_FILE_NAME: DOCKER_COMPOSE_TESTS_YML_FILE_NAME,
    DOCKER_COMPOSE_DEV_YML_TEMPLATE_FILE_NAME: DOCKER_COMPOSE_DEV_YML_FILE_NAME,
    DOCKER_COMPOSE_MANUAL_TESTING_YML_TEMPLATE_FILE_NAME: DOCKER_COMPOSE_MANUAL_TESTING_YML_FILE_NAME,
}

AIRFLOW_CONNECTIONS_AND_VARIABLES_SEEDER_FOLDER_NAME = (
    "airflow-connections-and-variables-seeder"
)

CONNECTIONS_YML_TEMPLATE_FILE_NAME = "connections.yml.template"
CONNECTIONS_YML_FILE_NAME = "connections.yml"

VARIABLES_JSON_TEMPLATE_FILE_NAME = "variables.json.template"
VARIABLES_JSON_FILE_NAME = "variables.json"

SEEDER_TEMPLATE_MAP = {
    CONNECTIONS_YML_TEMPLATE_FILE_NAME: CONNECTIONS_YML_FILE_NAME,
    VARIABLES_JSON_TEMPLATE_FILE_NAME: VARIABLES_JSON_FILE_NAME,
}

ENVRC_TEMPLATE_FILE_NAME = ".envrc.template"
ENVRC_FILE_NAME = ".envrc"
