"""
    Lookup/Ibis web service API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.2
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.lookup_client.api_client import ApiClient, Endpoint as _Endpoint
from identitylib.lookup_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from identitylib.lookup_client.model.group_all_groups_default_response import GroupAllGroupsDefaultResponse
from identitylib.lookup_client.model.group_get_cancelled_members200_response import GroupGetCancelledMembers200Response
from identitylib.lookup_client.model.group_search_count200_response import GroupSearchCount200Response
from identitylib.lookup_client.model.institution_all_attribute_schemes200_response import InstitutionAllAttributeSchemes200Response
from identitylib.lookup_client.model.institution_all_insts200_response import InstitutionAllInsts200Response
from identitylib.lookup_client.model.institution_get_attribute200_response import InstitutionGetAttribute200Response
from identitylib.lookup_client.model.institution_get_attributes200_response import InstitutionGetAttributes200Response
from identitylib.lookup_client.model.institution_get_contact_rows200_response import InstitutionGetContactRows200Response
from identitylib.lookup_client.model.institution_get_inst200_response import InstitutionGetInst200Response


class InstitutionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.institution_all_attribute_schemes_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllAttributeSchemes200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/all-attr-schemes',
                'operation_id': 'institution_all_attribute_schemes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_all_insts_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllInsts200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/all-insts',
                'operation_id': 'institution_all_insts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'include_cancelled',
                    'fetch',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'include_cancelled':
                        (bool,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'include_cancelled': 'includeCancelled',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'include_cancelled': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_get_attribute_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionGetAttribute200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/{instid}/{attrid}',
                'operation_id': 'institution_get_attribute',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instid',
                    'attrid',
                ],
                'required': [
                    'instid',
                    'attrid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instid':
                        (str,),
                    'attrid':
                        (int,),
                },
                'attribute_map': {
                    'instid': 'instid',
                    'attrid': 'attrid',
                },
                'location_map': {
                    'instid': 'path',
                    'attrid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_get_attributes_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionGetAttributes200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/{instid}/get-attributes',
                'operation_id': 'institution_get_attributes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instid',
                    'attrs',
                ],
                'required': [
                    'instid',
                    'attrs',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instid':
                        (str,),
                    'attrs':
                        (str,),
                },
                'attribute_map': {
                    'instid': 'instid',
                    'attrs': 'attrs',
                },
                'location_map': {
                    'instid': 'path',
                    'attrs': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_get_cancelled_members_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/{instid}/cancelled-members',
                'operation_id': 'institution_get_cancelled_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instid',
                    'fetch',
                ],
                'required': [
                    'instid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'instid': 'instid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'instid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_get_contact_rows_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionGetContactRows200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/{instid}/contact-rows',
                'operation_id': 'institution_get_contact_rows',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instid',
                    'fetch',
                ],
                'required': [
                    'instid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'instid': 'instid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'instid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_get_inst_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionGetInst200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/{instid}',
                'operation_id': 'institution_get_inst',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instid',
                    'fetch',
                ],
                'required': [
                    'instid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'instid': 'instid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'instid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_get_members_endpoint = _Endpoint(
            settings={
                'response_type': (GroupGetCancelledMembers200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/{instid}/members',
                'operation_id': 'institution_get_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instid',
                    'fetch',
                ],
                'required': [
                    'instid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instid':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'instid': 'instid',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'instid': 'path',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_list_insts_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllInsts200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/list',
                'operation_id': 'institution_list_insts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'instids',
                    'fetch',
                ],
                'required': [
                    'instids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'instids':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'instids': 'instids',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'instids': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_modified_insts_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllInsts200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/modified-insts',
                'operation_id': 'institution_modified_insts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'min_tx_id',
                    'max_tx_id',
                    'instids',
                    'include_cancelled',
                    'contact_row_changes',
                    'membership_changes',
                    'fetch',
                ],
                'required': [
                    'min_tx_id',
                    'max_tx_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'min_tx_id':
                        (int,),
                    'max_tx_id':
                        (int,),
                    'instids':
                        (str,),
                    'include_cancelled':
                        (bool,),
                    'contact_row_changes':
                        (bool,),
                    'membership_changes':
                        (bool,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'min_tx_id': 'minTxId',
                    'max_tx_id': 'maxTxId',
                    'instids': 'instids',
                    'include_cancelled': 'includeCancelled',
                    'contact_row_changes': 'contactRowChanges',
                    'membership_changes': 'membershipChanges',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'min_tx_id': 'query',
                    'max_tx_id': 'query',
                    'instids': 'query',
                    'include_cancelled': 'query',
                    'contact_row_changes': 'query',
                    'membership_changes': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_search_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionAllInsts200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/search',
                'operation_id': 'institution_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query',
                    'approx_matches',
                    'include_cancelled',
                    'attributes',
                    'offset',
                    'limit',
                    'order_by',
                    'fetch',
                ],
                'required': [
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'approx_matches':
                        (bool,),
                    'include_cancelled':
                        (bool,),
                    'attributes':
                        (str,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'order_by':
                        (str,),
                    'fetch':
                        (str,),
                },
                'attribute_map': {
                    'query': 'query',
                    'approx_matches': 'approxMatches',
                    'include_cancelled': 'includeCancelled',
                    'attributes': 'attributes',
                    'offset': 'offset',
                    'limit': 'limit',
                    'order_by': 'orderBy',
                    'fetch': 'fetch',
                },
                'location_map': {
                    'query': 'query',
                    'approx_matches': 'query',
                    'include_cancelled': 'query',
                    'attributes': 'query',
                    'offset': 'query',
                    'limit': 'query',
                    'order_by': 'query',
                    'fetch': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.institution_search_count_endpoint = _Endpoint(
            settings={
                'response_type': (GroupSearchCount200Response,),
                'auth': [
                    'APIGatewayAuth',
                    'APIGatewayAuth'
                ],
                'endpoint_path': '/inst/search-count',
                'operation_id': 'institution_search_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'query',
                    'approx_matches',
                    'include_cancelled',
                    'attributes',
                ],
                'required': [
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'query':
                        (str,),
                    'approx_matches':
                        (bool,),
                    'include_cancelled':
                        (bool,),
                    'attributes':
                        (str,),
                },
                'attribute_map': {
                    'query': 'query',
                    'approx_matches': 'approxMatches',
                    'include_cancelled': 'includeCancelled',
                    'attributes': 'attributes',
                },
                'location_map': {
                    'query': 'query',
                    'approx_matches': 'query',
                    'include_cancelled': 'query',
                    'attributes': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def institution_all_attribute_schemes(
        self,
        **kwargs
    ):
        """Return a list of all the institution attribute schemes available.  # noqa: E501

        Return a list of all the institution attribute schemes available. The `schemeid` values of these schemes may be used in the `fetch` parameter of other methods that return institutions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_all_attribute_schemes(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllAttributeSchemes200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.institution_all_attribute_schemes_endpoint.call_with_http_info(**kwargs)

    def institution_all_insts(
        self,
        **kwargs
    ):
        """Return a list of all institutions.  # noqa: E501

        Return a list of all institutions.  By default, only a few basic details about each institution are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_all_insts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            include_cancelled (bool): Whether or not to include cancelled institutions. By default, only live institutions are returned.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllInsts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.institution_all_insts_endpoint.call_with_http_info(**kwargs)

    def institution_get_attribute(
        self,
        instid,
        attrid,
        **kwargs
    ):
        """Get a specific attribute of an institution.  # noqa: E501

        Get a specific attribute of an institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_get_attribute(instid, attrid, async_req=True)
        >>> result = thread.get()

        Args:
            instid (str): The ID of the institution.
            attrid (int): The ID of the attribute to fetch.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionGetAttribute200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instid'] = \
            instid
        kwargs['attrid'] = \
            attrid
        return self.institution_get_attribute_endpoint.call_with_http_info(**kwargs)

    def institution_get_attributes(
        self,
        instid,
        attrs,
        **kwargs
    ):
        """Get one or more (possibly multi-valued) attributes of an institution.  # noqa: E501

        Get one or more (possibly multi-valued) attributes of an institution. The returned attributes are sorted by attribute scheme precedence and then attribute precedence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_get_attributes(instid, attrs, async_req=True)
        >>> result = thread.get()

        Args:
            instid (str): The ID of the institution.
            attrs (str): The attribute scheme(s) to fetch. This may include any number of the attributes or pseudo-attributes, but it may not include references or attribute chains (see the documentation for the `fetch` parameter in this class).

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionGetAttributes200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instid'] = \
            instid
        kwargs['attrs'] = \
            attrs
        return self.institution_get_attributes_endpoint.call_with_http_info(**kwargs)

    def institution_get_cancelled_members(
        self,
        instid,
        **kwargs
    ):
        """Get all the cancelled members of the specified institution.  # noqa: E501

        Get all the cancelled members of the specified institution.  By default, only a few basic details about each member are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each person.  NOTE: This method returns only cancelled people. It does not include people who were removed from the institution. Cancelled people are no longer considered to be current staff, students or accredited visitors, and are no longer regarded as belonging to any groups or institutions. The list returned here reflects their institutional memberships just before they were cancelled, and so is out-of-date data that should be used with caution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_get_cancelled_members(instid, async_req=True)
        >>> result = thread.get()

        Args:
            instid (str): The ID of the institution.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch for each person.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instid'] = \
            instid
        return self.institution_get_cancelled_members_endpoint.call_with_http_info(**kwargs)

    def institution_get_contact_rows(
        self,
        instid,
        **kwargs
    ):
        """Get all the contact rows of the specified institution.  # noqa: E501

        Get all the contact rows of the specified institution.  Any addresses, email addresses, phone numbers and web pages associated with the contact rows are automatically returned, as well as any people referred to by the contact rows.  If any of the contact rows refer to people, then only a few basic details about each person are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each person.  NOTE: This method will not include cancelled people.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_get_contact_rows(instid, async_req=True)
        >>> result = thread.get()

        Args:
            instid (str): The ID of the institution.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch for any people referred to by any of the contact rows.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionGetContactRows200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instid'] = \
            instid
        return self.institution_get_contact_rows_endpoint.call_with_http_info(**kwargs)

    def institution_get_inst(
        self,
        instid,
        **kwargs
    ):
        """Get the institution with the specified ID.  # noqa: E501

        Get the institution with the specified ID.  By default, only a few basic details about the institution are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of the institution.  NOTE: The institution returned may be a cancelled institution. It is the caller's repsonsibility to check its cancelled flag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_get_inst(instid, async_req=True)
        >>> result = thread.get()

        Args:
            instid (str): The ID of the institution to fetch.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionGetInst200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instid'] = \
            instid
        return self.institution_get_inst_endpoint.call_with_http_info(**kwargs)

    def institution_get_members(
        self,
        instid,
        **kwargs
    ):
        """Get all the members of the specified institution.  # noqa: E501

        Get all the members of the specified institution.  By default, only a few basic details about each member are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references of each person.  NOTE: This method will not include cancelled people.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_get_members(instid, async_req=True)
        >>> result = thread.get()

        Args:
            instid (str): The ID of the institution.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch for each person.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupGetCancelledMembers200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instid'] = \
            instid
        return self.institution_get_members_endpoint.call_with_http_info(**kwargs)

    def institution_list_insts(
        self,
        instids,
        **kwargs
    ):
        """Get the institutions with the specified IDs.  # noqa: E501

        Get the institutions with the specified IDs.  By default, only a few basic details about each institution are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  The results are sorted by ID.  NOTE: The URL path length is limited to around 8000 characters, and an instid is up to 8 characters long. Allowing for comma separators and URL encoding, this limits the number of institutions that this method may fetch to around 700.  NOTE: The institutions returned may include cancelled institutions. It is the caller's repsonsibility to check their cancelled flags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_list_insts(instids, async_req=True)
        >>> result = thread.get()

        Args:
            instids (str): A comma-separated list of instids.

        Keyword Args:
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllInsts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['instids'] = \
            instids
        return self.institution_list_insts_endpoint.call_with_http_info(**kwargs)

    def institution_modified_insts(
        self,
        min_tx_id,
        max_tx_id,
        **kwargs
    ):
        """Find all institutions modified between the specified pair of transactions.  # noqa: E501

        Find all institutions modified between the specified pair of transactions.  The transaction IDs specified should be the IDs from two different requests for the last (most recent) transaction ID, made at different times, that returned different values, indicating that some Lookup data was modified in the period between the two requests. This method then determines which (if any) institutions were affected.  By default, only a few basic details about each institution are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  NOTE: All data returned reflects the latest available data about each institution. It is not possible to query for old data, or more detailed information about the specific changes made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_modified_insts(min_tx_id, max_tx_id, async_req=True)
        >>> result = thread.get()

        Args:
            min_tx_id (int): Include modifications made in transactions after (but not including) this one.
            max_tx_id (int): Include modifications made in transactions up to and including this one.

        Keyword Args:
            instids (str): Only include institutions with instids in this list. By default, all modified institutions will be included.. [optional]
            include_cancelled (bool): Include cancelled institutions. By default, cancelled institutions are excluded.. [optional]
            contact_row_changes (bool): Include institutions whose contact rows have changed. By default, changes to institution contact rows are not taken into consideration.. [optional]
            membership_changes (bool): Include institutions whose members have changed. By default, changes to institutional memberships are not taken into consideration.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllInsts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['min_tx_id'] = \
            min_tx_id
        kwargs['max_tx_id'] = \
            max_tx_id
        return self.institution_modified_insts_endpoint.call_with_http_info(**kwargs)

    def institution_search(
        self,
        query,
        **kwargs
    ):
        """Search for institutions using a free text query string.  # noqa: E501

        Search for institutions using a free text query string. This is the same search function that is used in the Lookup web application.  By default, only a few basic details about each institution are returned, but the optional `fetch` parameter may be used to fetch additional attributes or references.  NOTE: If the query string starts with the prefix `\"inst:\"`, it is treated as an [LQL query](/lql), allowing more advanced searches. An LQL query will ignore the `approxMatches` and `attributes` parameters, but it will respect the value of `includeCancelled`. In addition, an LQL query will ignore the `orderBy` parameter, since LQL queries always return results in ID order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_search(query, async_req=True)
        >>> result = thread.get()

        Args:
            query (str): The search string.

        Keyword Args:
            approx_matches (bool): Flag to enable more approximate matching in the search, causing more results to be returned. Defaults to `false`. This is ignored for LQL queries.. [optional]
            include_cancelled (bool): Flag to allow cancelled institutions to be included. Defaults to `false`.. [optional]
            attributes (str): A comma-separated list of attributes to consider when searching. If this is `null` (the default) then all attribute schemes marked as searchable will be included. This is ignored for LQL queries.. [optional]
            offset (int): The number of results to skip at the start of the search. Defaults to 0.. [optional]
            limit (int): The maximum number of results to return. Defaults to 100.. [optional]
            order_by (str): The order in which to list the results. This may be either `\"instid\"` or `\"name\"` (the default for non-LQL queries). This is ignored for LQL queries, which always return results in instid order.. [optional]
            fetch (str): A comma-separated list of any additional attributes or references to fetch.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionAllInsts200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['query'] = \
            query
        return self.institution_search_endpoint.call_with_http_info(**kwargs)

    def institution_search_count(
        self,
        query,
        **kwargs
    ):
        """Count the number of institutions that would be returned by a search using a free text query string.  # noqa: E501

        Count the number of institutions that would be returned by a search using a free text query string.  NOTE: If the query string starts with the prefix `\"inst:\"`, it is treated as an [LQL query](/lql), allowing more advanced searches. An LQL query will ignore the `approxMatches` and `attributes` parameters, but it will respect the value of `includeCancelled`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.institution_search_count(query, async_req=True)
        >>> result = thread.get()

        Args:
            query (str): The search string.

        Keyword Args:
            approx_matches (bool): Flag to enable more approximate matching in the search, causing more results to be returned. Defaults to `false`. This is ignored for LQL queries.. [optional]
            include_cancelled (bool): Flag to allow cancelled institutions to be included. Defaults to `false`.. [optional]
            attributes (str): A comma-separated list of attributes to consider when searching. If this is `null` (the default) then all attribute schemes marked as searchable will be included. This is ignored for LQL queries.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GroupSearchCount200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['query'] = \
            query
        return self.institution_search_count_endpoint.call_with_http_info(**kwargs)

