# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotebookInstanceArgs', 'NotebookInstance']

@pulumi.input_type
class NotebookInstanceArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 accelerator_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 additional_code_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_code_repository: Optional[pulumi.Input[str]] = None,
                 direct_internet_access: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_config_name: Optional[pulumi.Input[str]] = None,
                 notebook_instance_name: Optional[pulumi.Input[str]] = None,
                 platform_identifier: Optional[pulumi.Input[str]] = None,
                 root_access: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookInstanceTagArgs']]]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a NotebookInstance resource.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "role_arn", role_arn)
        if accelerator_types is not None:
            pulumi.set(__self__, "accelerator_types", accelerator_types)
        if additional_code_repositories is not None:
            pulumi.set(__self__, "additional_code_repositories", additional_code_repositories)
        if default_code_repository is not None:
            pulumi.set(__self__, "default_code_repository", default_code_repository)
        if direct_internet_access is not None:
            pulumi.set(__self__, "direct_internet_access", direct_internet_access)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_config_name is not None:
            pulumi.set(__self__, "lifecycle_config_name", lifecycle_config_name)
        if notebook_instance_name is not None:
            pulumi.set(__self__, "notebook_instance_name", notebook_instance_name)
        if platform_identifier is not None:
            pulumi.set(__self__, "platform_identifier", platform_identifier)
        if root_access is not None:
            pulumi.set(__self__, "root_access", root_access)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="acceleratorTypes")
    def accelerator_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "accelerator_types")

    @accelerator_types.setter
    def accelerator_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "accelerator_types", value)

    @property
    @pulumi.getter(name="additionalCodeRepositories")
    def additional_code_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "additional_code_repositories")

    @additional_code_repositories.setter
    def additional_code_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_code_repositories", value)

    @property
    @pulumi.getter(name="defaultCodeRepository")
    def default_code_repository(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "default_code_repository")

    @default_code_repository.setter
    def default_code_repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_code_repository", value)

    @property
    @pulumi.getter(name="directInternetAccess")
    def direct_internet_access(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "direct_internet_access")

    @direct_internet_access.setter
    def direct_internet_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_internet_access", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lifecycleConfigName")
    def lifecycle_config_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "lifecycle_config_name")

    @lifecycle_config_name.setter
    def lifecycle_config_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_config_name", value)

    @property
    @pulumi.getter(name="notebookInstanceName")
    def notebook_instance_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "notebook_instance_name")

    @notebook_instance_name.setter
    def notebook_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notebook_instance_name", value)

    @property
    @pulumi.getter(name="platformIdentifier")
    def platform_identifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "platform_identifier")

    @platform_identifier.setter
    def platform_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_identifier", value)

    @property
    @pulumi.getter(name="rootAccess")
    def root_access(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "root_access")

    @root_access.setter
    def root_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_access", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotebookInstanceTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotebookInstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size_in_gb", value)


warnings.warn("""NotebookInstance is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class NotebookInstance(pulumi.CustomResource):
    warnings.warn("""NotebookInstance is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 additional_code_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_code_repository: Optional[pulumi.Input[str]] = None,
                 direct_internet_access: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_config_name: Optional[pulumi.Input[str]] = None,
                 notebook_instance_name: Optional[pulumi.Input[str]] = None,
                 platform_identifier: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 root_access: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotebookInstanceTagArgs']]]]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::NotebookInstance

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotebookInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::NotebookInstance

        :param str resource_name: The name of the resource.
        :param NotebookInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotebookInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 additional_code_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_code_repository: Optional[pulumi.Input[str]] = None,
                 direct_internet_access: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_config_name: Optional[pulumi.Input[str]] = None,
                 notebook_instance_name: Optional[pulumi.Input[str]] = None,
                 platform_identifier: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 root_access: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotebookInstanceTagArgs']]]]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        pulumi.log.warn("""NotebookInstance is deprecated: NotebookInstance is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotebookInstanceArgs.__new__(NotebookInstanceArgs)

            __props__.__dict__["accelerator_types"] = accelerator_types
            __props__.__dict__["additional_code_repositories"] = additional_code_repositories
            __props__.__dict__["default_code_repository"] = default_code_repository
            __props__.__dict__["direct_internet_access"] = direct_internet_access
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["lifecycle_config_name"] = lifecycle_config_name
            __props__.__dict__["notebook_instance_name"] = notebook_instance_name
            __props__.__dict__["platform_identifier"] = platform_identifier
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["root_access"] = root_access
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
        super(NotebookInstance, __self__).__init__(
            'aws-native:sagemaker:NotebookInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NotebookInstance':
        """
        Get an existing NotebookInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NotebookInstanceArgs.__new__(NotebookInstanceArgs)

        __props__.__dict__["accelerator_types"] = None
        __props__.__dict__["additional_code_repositories"] = None
        __props__.__dict__["default_code_repository"] = None
        __props__.__dict__["direct_internet_access"] = None
        __props__.__dict__["instance_type"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["lifecycle_config_name"] = None
        __props__.__dict__["notebook_instance_name"] = None
        __props__.__dict__["platform_identifier"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["root_access"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["subnet_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["volume_size_in_gb"] = None
        return NotebookInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorTypes")
    def accelerator_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "accelerator_types")

    @property
    @pulumi.getter(name="additionalCodeRepositories")
    def additional_code_repositories(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "additional_code_repositories")

    @property
    @pulumi.getter(name="defaultCodeRepository")
    def default_code_repository(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "default_code_repository")

    @property
    @pulumi.getter(name="directInternetAccess")
    def direct_internet_access(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "direct_internet_access")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleConfigName")
    def lifecycle_config_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "lifecycle_config_name")

    @property
    @pulumi.getter(name="notebookInstanceName")
    def notebook_instance_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "notebook_instance_name")

    @property
    @pulumi.getter(name="platformIdentifier")
    def platform_identifier(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "platform_identifier")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="rootAccess")
    def root_access(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "root_access")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.NotebookInstanceTag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeSizeInGB")
    def volume_size_in_gb(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "volume_size_in_gb")

