BUNDLE_NAME = "ietf"

CAPABILITIES = {
    "iana-crypt-hash": "2014-08-06",
    "iana-if-type": "2014-05-08",
    "ietf-datastores": "2018-02-14",
    "ietf-diffserv-action": "2015-04-07",
    "ietf-diffserv-classifier": "2015-04-07",
    "ietf-diffserv-policy": "2015-04-07",
    "ietf-diffserv-target": "2015-04-07",
    "ietf-event-notifications": "2016-10-27",
    "ietf-inet-types": "2013-07-15",
    "ietf-interfaces": "2014-05-08",
    "ietf-interfaces-ext": "",
    "ietf-ip": "2014-06-16",
    "ietf-ipv4-unicast-routing": "2015-05-25",
    "ietf-ipv6-unicast-routing": "2015-05-25",
    "ietf-key-chain": "2015-02-24",
    "ietf-netconf": "2011-06-01",
    "ietf-netconf-acm": "2018-02-14",
    "ietf-netconf-monitoring": "2010-10-04",
    "ietf-netconf-notifications": "2012-02-06",
    "ietf-netconf-with-defaults": "2011-06-01",
    "ietf-ospf": "2015-03-09",
    "ietf-restconf-monitoring": "2017-01-26",
    "ietf-routing": "2015-05-25",
    "ietf-syslog-types": "2015-11-09",
    "ietf-yang-library": "2019-01-04",
    "ietf-yang-push": "2016-10-28",
    "ietf-yang-smiv2": "2012-06-22",
    "ietf-yang-types": "2013-07-15",
    "policy-types": "2013-10-07",
}

ENTITY_LOOKUP = {
    ("urn:ietf:params:xml:ns:yang:ietf-diffserv-classifier", "classifiers"): "ietf_diffserv_classifier.Classifiers",
    ("ietf-diffserv-classifier", "classifiers"): "ietf_diffserv_classifier.Classifiers",
    ("urn:ietf:params:xml:ns:yang:ietf-diffserv-policy", "policies"): "ietf_diffserv_policy.Policies",
    ("ietf-diffserv-policy", "policies"): "ietf_diffserv_policy.Policies",
    ("urn:ietf:params:xml:ns:yang:ietf-event-notifications", "streams"): "ietf_event_notifications.Streams",
    ("ietf-event-notifications", "streams"): "ietf_event_notifications.Streams",
    ("urn:ietf:params:xml:ns:yang:ietf-event-notifications", "filters"): "ietf_event_notifications.Filters",
    ("ietf-event-notifications", "filters"): "ietf_event_notifications.Filters",
    ("urn:ietf:params:xml:ns:yang:ietf-event-notifications", "subscription-config"): "ietf_event_notifications.SubscriptionConfig",
    ("ietf-event-notifications", "subscription-config"): "ietf_event_notifications.SubscriptionConfig",
    ("urn:ietf:params:xml:ns:yang:ietf-event-notifications", "subscriptions"): "ietf_event_notifications.Subscriptions",
    ("ietf-event-notifications", "subscriptions"): "ietf_event_notifications.Subscriptions",
    ("urn:ietf:params:xml:ns:yang:ietf-interfaces", "interfaces"): "ietf_interfaces.Interfaces",
    ("ietf-interfaces", "interfaces"): "ietf_interfaces.Interfaces",
    ("urn:ietf:params:xml:ns:yang:ietf-interfaces", "interfaces-state"): "ietf_interfaces.InterfacesState",
    ("ietf-interfaces", "interfaces-state"): "ietf_interfaces.InterfacesState",
    ("urn:ietf:params:xml:ns:yang:ietf-key-chain", "key-chains"): "ietf_key_chain.KeyChains",
    ("ietf-key-chain", "key-chains"): "ietf_key_chain.KeyChains",
    ("urn:ietf:params:xml:ns:yang:ietf-netconf-acm", "nacm"): "ietf_netconf_acm.Nacm",
    ("ietf-netconf-acm", "nacm"): "ietf_netconf_acm.Nacm",
    ("urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring", "netconf-state"): "ietf_netconf_monitoring.NetconfState",
    ("ietf-netconf-monitoring", "netconf-state"): "ietf_netconf_monitoring.NetconfState",
    ("urn:ietf:params:xml:ns:yang:ietf-restconf-monitoring", "restconf-state"): "ietf_restconf_monitoring.RestconfState",
    ("ietf-restconf-monitoring", "restconf-state"): "ietf_restconf_monitoring.RestconfState",
    ("urn:ietf:params:xml:ns:yang:ietf-routing", "routing-state"): "ietf_routing.RoutingState",
    ("ietf-routing", "routing-state"): "ietf_routing.RoutingState",
    ("urn:ietf:params:xml:ns:yang:ietf-routing", "routing"): "ietf_routing.Routing",
    ("ietf-routing", "routing"): "ietf_routing.Routing",
    ("urn:ietf:params:xml:ns:yang:ietf-yang-library", "yang-library"): "ietf_yang_library.YangLibrary",
    ("ietf-yang-library", "yang-library"): "ietf_yang_library.YangLibrary",
    ("urn:ietf:params:xml:ns:yang:ietf-yang-library", "modules-state"): "ietf_yang_library.ModulesState",
    ("ietf-yang-library", "modules-state"): "ietf_yang_library.ModulesState",
}

NAMESPACE_LOOKUP = {
    "iana-crypt-hash": "urn:ietf:params:xml:ns:yang:iana-crypt-hash",
    "iana-if-type": "urn:ietf:params:xml:ns:yang:iana-if-type",
    "ietf-datastores": "urn:ietf:params:xml:ns:yang:ietf-datastores",
    "ietf-diffserv-action": "urn:ietf:params:xml:ns:yang:ietf-diffserv-action",
    "ietf-diffserv-classifier": "urn:ietf:params:xml:ns:yang:ietf-diffserv-classifier",
    "ietf-diffserv-policy": "urn:ietf:params:xml:ns:yang:ietf-diffserv-policy",
    "ietf-diffserv-target": "urn:ietf:params:xml:ns:yang:ietf-diffserv-target",
    "ietf-event-notifications": "urn:ietf:params:xml:ns:yang:ietf-event-notifications",
    "ietf-inet-types": "urn:ietf:params:xml:ns:yang:ietf-inet-types",
    "ietf-interfaces": "urn:ietf:params:xml:ns:yang:ietf-interfaces",
    "ietf-interfaces-ext": "urn:ietf:params:xml:ns:yang:ietf-interfaces-ext",
    "ietf-ip": "urn:ietf:params:xml:ns:yang:ietf-ip",
    "ietf-ipv4-unicast-routing": "urn:ietf:params:xml:ns:yang:ietf-ipv4-unicast-routing",
    "ietf-ipv6-unicast-routing": "urn:ietf:params:xml:ns:yang:ietf-ipv6-unicast-routing",
    "ietf-key-chain": "urn:ietf:params:xml:ns:yang:ietf-key-chain",
    "ietf-netconf": "urn:ietf:params:xml:ns:netconf:base:1.0",
    "ietf-netconf-acm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm",
    "ietf-netconf-monitoring": "urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring",
    "ietf-netconf-notifications": "urn:ietf:params:xml:ns:yang:ietf-netconf-notifications",
    "ietf-netconf-with-defaults": "urn:ietf:params:xml:ns:yang:ietf-netconf-with-defaults",
    "ietf-ospf": "urn:ietf:params:xml:ns:yang:ietf-ospf",
    "ietf-restconf-monitoring": "urn:ietf:params:xml:ns:yang:ietf-restconf-monitoring",
    "ietf-routing": "urn:ietf:params:xml:ns:yang:ietf-routing",
    "ietf-syslog-types": "urn:ietf:params:xml:ns:yang:ietf-syslog-types",
    "ietf-yang-library": "urn:ietf:params:xml:ns:yang:ietf-yang-library",
    "ietf-yang-push": "urn:ietf:params:xml:ns:yang:ietf-yang-push",
    "ietf-yang-smiv2": "urn:ietf:params:xml:ns:yang:ietf-yang-smiv2",
    "ietf-yang-types": "urn:ietf:params:xml:ns:yang:ietf-yang-types",
    "policy-types": "urn:ietf:params:xml:ns:yang:c3pl-types",
}

IDENTITY_LOOKUP = {
    'iana-if-type:a12MppSwitch':('ydk.models.ietf.iana_if_type', 'A12MppSwitch'),
    'iana-if-type:aal2':('ydk.models.ietf.iana_if_type', 'Aal2'),
    'iana-if-type:aal5':('ydk.models.ietf.iana_if_type', 'Aal5'),
    'iana-if-type:actelisMetaLOOP':('ydk.models.ietf.iana_if_type', 'ActelisMetaLOOP'),
    'iana-if-type:adsl':('ydk.models.ietf.iana_if_type', 'Adsl'),
    'iana-if-type:adsl2':('ydk.models.ietf.iana_if_type', 'Adsl2'),
    'iana-if-type:adsl2plus':('ydk.models.ietf.iana_if_type', 'Adsl2plus'),
    'iana-if-type:aflane8023':('ydk.models.ietf.iana_if_type', 'Aflane8023'),
    'iana-if-type:aflane8025':('ydk.models.ietf.iana_if_type', 'Aflane8025'),
    'iana-if-type:aluELP':('ydk.models.ietf.iana_if_type', 'AluELP'),
    'iana-if-type:aluEpon':('ydk.models.ietf.iana_if_type', 'AluEpon'),
    'iana-if-type:aluEponLogicalLink':('ydk.models.ietf.iana_if_type', 'AluEponLogicalLink'),
    'iana-if-type:aluEponOnu':('ydk.models.ietf.iana_if_type', 'AluEponOnu'),
    'iana-if-type:aluEponPhysicalUni':('ydk.models.ietf.iana_if_type', 'AluEponPhysicalUni'),
    'iana-if-type:aluGponOnu':('ydk.models.ietf.iana_if_type', 'AluGponOnu'),
    'iana-if-type:aluGponPhysicalUni':('ydk.models.ietf.iana_if_type', 'AluGponPhysicalUni'),
    'iana-if-type:arap':('ydk.models.ietf.iana_if_type', 'Arap'),
    'iana-if-type:arcnet':('ydk.models.ietf.iana_if_type', 'Arcnet'),
    'iana-if-type:arcnetPlus':('ydk.models.ietf.iana_if_type', 'ArcnetPlus'),
    'iana-if-type:async':('ydk.models.ietf.iana_if_type', 'Async'),
    'iana-if-type:atm':('ydk.models.ietf.iana_if_type', 'Atm'),
    'iana-if-type:atmDxi':('ydk.models.ietf.iana_if_type', 'AtmDxi'),
    'iana-if-type:atmFuni':('ydk.models.ietf.iana_if_type', 'AtmFuni'),
    'iana-if-type:atmIma':('ydk.models.ietf.iana_if_type', 'AtmIma'),
    'iana-if-type:atmLogical':('ydk.models.ietf.iana_if_type', 'AtmLogical'),
    'iana-if-type:atmRadio':('ydk.models.ietf.iana_if_type', 'AtmRadio'),
    'iana-if-type:atmSubInterface':('ydk.models.ietf.iana_if_type', 'AtmSubInterface'),
    'iana-if-type:atmVciEndPt':('ydk.models.ietf.iana_if_type', 'AtmVciEndPt'),
    'iana-if-type:atmVirtual':('ydk.models.ietf.iana_if_type', 'AtmVirtual'),
    'iana-if-type:atmbond':('ydk.models.ietf.iana_if_type', 'Atmbond'),
    'iana-if-type:aviciOpticalEther':('ydk.models.ietf.iana_if_type', 'AviciOpticalEther'),
    'iana-if-type:basicISDN':('ydk.models.ietf.iana_if_type', 'BasicISDN'),
    'iana-if-type:bgppolicyaccounting':('ydk.models.ietf.iana_if_type', 'Bgppolicyaccounting'),
    'iana-if-type:bits':('ydk.models.ietf.iana_if_type', 'Bits'),
    'iana-if-type:bridge':('ydk.models.ietf.iana_if_type', 'Bridge'),
    'iana-if-type:bsc':('ydk.models.ietf.iana_if_type', 'Bsc'),
    'iana-if-type:cableDownstreamRfPort':('ydk.models.ietf.iana_if_type', 'CableDownstreamRfPort'),
    'iana-if-type:capwapDot11Bss':('ydk.models.ietf.iana_if_type', 'CapwapDot11Bss'),
    'iana-if-type:capwapDot11Profile':('ydk.models.ietf.iana_if_type', 'CapwapDot11Profile'),
    'iana-if-type:capwapWtpVirtualRadio':('ydk.models.ietf.iana_if_type', 'CapwapWtpVirtualRadio'),
    'iana-if-type:cblVectaStar':('ydk.models.ietf.iana_if_type', 'CblVectaStar'),
    'iana-if-type:cctEmul':('ydk.models.ietf.iana_if_type', 'CctEmul'),
    'iana-if-type:ces':('ydk.models.ietf.iana_if_type', 'Ces'),
    'iana-if-type:channel':('ydk.models.ietf.iana_if_type', 'Channel'),
    'iana-if-type:ciscoISLvlan':('ydk.models.ietf.iana_if_type', 'CiscoISLvlan'),
    'iana-if-type:cnr':('ydk.models.ietf.iana_if_type', 'Cnr'),
    'iana-if-type:coffee':('ydk.models.ietf.iana_if_type', 'Coffee'),
    'iana-if-type:compositeLink':('ydk.models.ietf.iana_if_type', 'CompositeLink'),
    'iana-if-type:dcn':('ydk.models.ietf.iana_if_type', 'Dcn'),
    'iana-if-type:ddnX25':('ydk.models.ietf.iana_if_type', 'DdnX25'),
    'iana-if-type:digitalPowerline':('ydk.models.ietf.iana_if_type', 'DigitalPowerline'),
    'iana-if-type:digitalWrapperOverheadChannel':('ydk.models.ietf.iana_if_type', 'DigitalWrapperOverheadChannel'),
    'iana-if-type:dlsw':('ydk.models.ietf.iana_if_type', 'Dlsw'),
    'iana-if-type:docsCableDownstream':('ydk.models.ietf.iana_if_type', 'DocsCableDownstream'),
    'iana-if-type:docsCableMCmtsDownstream':('ydk.models.ietf.iana_if_type', 'DocsCableMCmtsDownstream'),
    'iana-if-type:docsCableMaclayer':('ydk.models.ietf.iana_if_type', 'DocsCableMaclayer'),
    'iana-if-type:docsCableUpstream':('ydk.models.ietf.iana_if_type', 'DocsCableUpstream'),
    'iana-if-type:docsCableUpstreamChannel':('ydk.models.ietf.iana_if_type', 'DocsCableUpstreamChannel'),
    'iana-if-type:docsCableUpstreamRfPort':('ydk.models.ietf.iana_if_type', 'DocsCableUpstreamRfPort'),
    'iana-if-type:ds0':('ydk.models.ietf.iana_if_type', 'Ds0'),
    'iana-if-type:ds0Bundle':('ydk.models.ietf.iana_if_type', 'Ds0Bundle'),
    'iana-if-type:ds1':('ydk.models.ietf.iana_if_type', 'Ds1'),
    'iana-if-type:ds1FDL':('ydk.models.ietf.iana_if_type', 'Ds1FDL'),
    'iana-if-type:ds3':('ydk.models.ietf.iana_if_type', 'Ds3'),
    'iana-if-type:dtm':('ydk.models.ietf.iana_if_type', 'Dtm'),
    'iana-if-type:dvbAsiIn':('ydk.models.ietf.iana_if_type', 'DvbAsiIn'),
    'iana-if-type:dvbAsiOut':('ydk.models.ietf.iana_if_type', 'DvbAsiOut'),
    'iana-if-type:dvbRccDownstream':('ydk.models.ietf.iana_if_type', 'DvbRccDownstream'),
    'iana-if-type:dvbRccMacLayer':('ydk.models.ietf.iana_if_type', 'DvbRccMacLayer'),
    'iana-if-type:dvbRccUpstream':('ydk.models.ietf.iana_if_type', 'DvbRccUpstream'),
    'iana-if-type:dvbRcsMacLayer':('ydk.models.ietf.iana_if_type', 'DvbRcsMacLayer'),
    'iana-if-type:dvbRcsTdma':('ydk.models.ietf.iana_if_type', 'DvbRcsTdma'),
    'iana-if-type:dvbTdm':('ydk.models.ietf.iana_if_type', 'DvbTdm'),
    'iana-if-type:e1':('ydk.models.ietf.iana_if_type', 'E1'),
    'iana-if-type:econet':('ydk.models.ietf.iana_if_type', 'Econet'),
    'iana-if-type:eon':('ydk.models.ietf.iana_if_type', 'Eon'),
    'iana-if-type:eplrs':('ydk.models.ietf.iana_if_type', 'Eplrs'),
    'iana-if-type:escon':('ydk.models.ietf.iana_if_type', 'Escon'),
    'iana-if-type:ethernet3Mbit':('ydk.models.ietf.iana_if_type', 'Ethernet3Mbit'),
    'iana-if-type:ethernetCsmacd':('ydk.models.ietf.iana_if_type', 'EthernetCsmacd'),
    'iana-if-type:fast':('ydk.models.ietf.iana_if_type', 'Fast'),
    'iana-if-type:fastEther':('ydk.models.ietf.iana_if_type', 'FastEther'),
    'iana-if-type:fastEtherFX':('ydk.models.ietf.iana_if_type', 'FastEtherFX'),
    'iana-if-type:fcipLink':('ydk.models.ietf.iana_if_type', 'FcipLink'),
    'iana-if-type:fddi':('ydk.models.ietf.iana_if_type', 'Fddi'),
    'iana-if-type:fibreChannel':('ydk.models.ietf.iana_if_type', 'FibreChannel'),
    'iana-if-type:frDlciEndPt':('ydk.models.ietf.iana_if_type', 'FrDlciEndPt'),
    'iana-if-type:frForward':('ydk.models.ietf.iana_if_type', 'FrForward'),
    'iana-if-type:frameRelay':('ydk.models.ietf.iana_if_type', 'FrameRelay'),
    'iana-if-type:frameRelayInterconnect':('ydk.models.ietf.iana_if_type', 'FrameRelayInterconnect'),
    'iana-if-type:frameRelayMPI':('ydk.models.ietf.iana_if_type', 'FrameRelayMPI'),
    'iana-if-type:frameRelayService':('ydk.models.ietf.iana_if_type', 'FrameRelayService'),
    'iana-if-type:frf16MfrBundle':('ydk.models.ietf.iana_if_type', 'Frf16MfrBundle'),
    'iana-if-type:g703at2mb':('ydk.models.ietf.iana_if_type', 'G703at2mb'),
    'iana-if-type:g703at64k':('ydk.models.ietf.iana_if_type', 'G703at64k'),
    'iana-if-type:g9981':('ydk.models.ietf.iana_if_type', 'G9981'),
    'iana-if-type:g9982':('ydk.models.ietf.iana_if_type', 'G9982'),
    'iana-if-type:g9983':('ydk.models.ietf.iana_if_type', 'G9983'),
    'iana-if-type:gfp':('ydk.models.ietf.iana_if_type', 'Gfp'),
    'iana-if-type:gigabitEthernet':('ydk.models.ietf.iana_if_type', 'GigabitEthernet'),
    'iana-if-type:gpon':('ydk.models.ietf.iana_if_type', 'Gpon'),
    'iana-if-type:gr303IDT':('ydk.models.ietf.iana_if_type', 'Gr303IDT'),
    'iana-if-type:gr303RDT':('ydk.models.ietf.iana_if_type', 'Gr303RDT'),
    'iana-if-type:gtp':('ydk.models.ietf.iana_if_type', 'Gtp'),
    'iana-if-type:h323Gatekeeper':('ydk.models.ietf.iana_if_type', 'H323Gatekeeper'),
    'iana-if-type:h323Proxy':('ydk.models.ietf.iana_if_type', 'H323Proxy'),
    'iana-if-type:hdh1822':('ydk.models.ietf.iana_if_type', 'Hdh1822'),
    'iana-if-type:hdlc':('ydk.models.ietf.iana_if_type', 'Hdlc'),
    'iana-if-type:hdsl2':('ydk.models.ietf.iana_if_type', 'Hdsl2'),
    'iana-if-type:hiperlan2':('ydk.models.ietf.iana_if_type', 'Hiperlan2'),
    'iana-if-type:hippi':('ydk.models.ietf.iana_if_type', 'Hippi'),
    'iana-if-type:hippiInterface':('ydk.models.ietf.iana_if_type', 'HippiInterface'),
    'iana-if-type:homepna':('ydk.models.ietf.iana_if_type', 'Homepna'),
    'iana-if-type:hostPad':('ydk.models.ietf.iana_if_type', 'HostPad'),
    'iana-if-type:hssi':('ydk.models.ietf.iana_if_type', 'Hssi'),
    'iana-if-type:hyperchannel':('ydk.models.ietf.iana_if_type', 'Hyperchannel'),
    'iana-if-type:iana-interface-type':('ydk.models.ietf.iana_if_type', 'IanaInterfaceType'),
    'iana-if-type:ibm370parChan':('ydk.models.ietf.iana_if_type', 'Ibm370parChan'),
    'iana-if-type:idsl':('ydk.models.ietf.iana_if_type', 'Idsl'),
    'iana-if-type:ieee1394':('ydk.models.ietf.iana_if_type', 'Ieee1394'),
    'iana-if-type:ieee80211':('ydk.models.ietf.iana_if_type', 'Ieee80211'),
    'iana-if-type:ieee80212':('ydk.models.ietf.iana_if_type', 'Ieee80212'),
    'iana-if-type:ieee802154':('ydk.models.ietf.iana_if_type', 'Ieee802154'),
    'iana-if-type:ieee80216WMAN':('ydk.models.ietf.iana_if_type', 'Ieee80216WMAN'),
    'iana-if-type:ieee8023adLag':('ydk.models.ietf.iana_if_type', 'Ieee8023adLag'),
    'iana-if-type:if-gsn':('ydk.models.ietf.iana_if_type', 'IfGsn'),
    'iana-if-type:ifPwType':('ydk.models.ietf.iana_if_type', 'IfPwType'),
    'iana-if-type:ifVfiType':('ydk.models.ietf.iana_if_type', 'IfVfiType'),
    'iana-if-type:ilan':('ydk.models.ietf.iana_if_type', 'Ilan'),
    'iana-if-type:imt':('ydk.models.ietf.iana_if_type', 'Imt'),
    'iana-if-type:infiniband':('ydk.models.ietf.iana_if_type', 'Infiniband'),
    'iana-if-type:interleave':('ydk.models.ietf.iana_if_type', 'Interleave'),
    'iana-if-type:ip':('ydk.models.ietf.iana_if_type', 'Ip'),
    'iana-if-type:ipForward':('ydk.models.ietf.iana_if_type', 'IpForward'),
    'iana-if-type:ipOverAtm':('ydk.models.ietf.iana_if_type', 'IpOverAtm'),
    'iana-if-type:ipOverCdlc':('ydk.models.ietf.iana_if_type', 'IpOverCdlc'),
    'iana-if-type:ipOverClaw':('ydk.models.ietf.iana_if_type', 'IpOverClaw'),
    'iana-if-type:ipSwitch':('ydk.models.ietf.iana_if_type', 'IpSwitch'),
    'iana-if-type:isdn':('ydk.models.ietf.iana_if_type', 'Isdn'),
    'iana-if-type:isdns':('ydk.models.ietf.iana_if_type', 'Isdns'),
    'iana-if-type:isdnu':('ydk.models.ietf.iana_if_type', 'Isdnu'),
    'iana-if-type:iso88022llc':('ydk.models.ietf.iana_if_type', 'Iso88022llc'),
    'iana-if-type:iso88023Csmacd':('ydk.models.ietf.iana_if_type', 'Iso88023Csmacd'),
    'iana-if-type:iso88024TokenBus':('ydk.models.ietf.iana_if_type', 'Iso88024TokenBus'),
    'iana-if-type:iso88025CRFPInt':('ydk.models.ietf.iana_if_type', 'Iso88025CRFPInt'),
    'iana-if-type:iso88025Dtr':('ydk.models.ietf.iana_if_type', 'Iso88025Dtr'),
    'iana-if-type:iso88025Fiber':('ydk.models.ietf.iana_if_type', 'Iso88025Fiber'),
    'iana-if-type:iso88025TokenRing':('ydk.models.ietf.iana_if_type', 'Iso88025TokenRing'),
    'iana-if-type:iso88026Man':('ydk.models.ietf.iana_if_type', 'Iso88026Man'),
    'iana-if-type:isup':('ydk.models.ietf.iana_if_type', 'Isup'),
    'iana-if-type:l2vlan':('ydk.models.ietf.iana_if_type', 'L2vlan'),
    'iana-if-type:l3ipvlan':('ydk.models.ietf.iana_if_type', 'L3ipvlan'),
    'iana-if-type:l3ipxvlan':('ydk.models.ietf.iana_if_type', 'L3ipxvlan'),
    'iana-if-type:lapb':('ydk.models.ietf.iana_if_type', 'Lapb'),
    'iana-if-type:lapd':('ydk.models.ietf.iana_if_type', 'Lapd'),
    'iana-if-type:lapf':('ydk.models.ietf.iana_if_type', 'Lapf'),
    'iana-if-type:linegroup':('ydk.models.ietf.iana_if_type', 'Linegroup'),
    'iana-if-type:lmp':('ydk.models.ietf.iana_if_type', 'Lmp'),
    'iana-if-type:localTalk':('ydk.models.ietf.iana_if_type', 'LocalTalk'),
    'iana-if-type:macSecControlledIF':('ydk.models.ietf.iana_if_type', 'MacSecControlledIF'),
    'iana-if-type:macSecUncontrolledIF':('ydk.models.ietf.iana_if_type', 'MacSecUncontrolledIF'),
    'iana-if-type:mediaMailOverIp':('ydk.models.ietf.iana_if_type', 'MediaMailOverIp'),
    'iana-if-type:mfSigLink':('ydk.models.ietf.iana_if_type', 'MfSigLink'),
    'iana-if-type:miox25':('ydk.models.ietf.iana_if_type', 'Miox25'),
    'iana-if-type:mocaVersion1':('ydk.models.ietf.iana_if_type', 'MocaVersion1'),
    'iana-if-type:modem':('ydk.models.ietf.iana_if_type', 'Modem'),
    'iana-if-type:mpc':('ydk.models.ietf.iana_if_type', 'Mpc'),
    'iana-if-type:mpegTransport':('ydk.models.ietf.iana_if_type', 'MpegTransport'),
    'iana-if-type:mpls':('ydk.models.ietf.iana_if_type', 'Mpls'),
    'iana-if-type:mplsTunnel':('ydk.models.ietf.iana_if_type', 'MplsTunnel'),
    'iana-if-type:msdsl':('ydk.models.ietf.iana_if_type', 'Msdsl'),
    'iana-if-type:mvl':('ydk.models.ietf.iana_if_type', 'Mvl'),
    'iana-if-type:myrinet':('ydk.models.ietf.iana_if_type', 'Myrinet'),
    'iana-if-type:nfas':('ydk.models.ietf.iana_if_type', 'Nfas'),
    'iana-if-type:nsip':('ydk.models.ietf.iana_if_type', 'Nsip'),
    'iana-if-type:opticalChannel':('ydk.models.ietf.iana_if_type', 'OpticalChannel'),
    'iana-if-type:opticalChannelGroup':('ydk.models.ietf.iana_if_type', 'OpticalChannelGroup'),
    'iana-if-type:opticalTransport':('ydk.models.ietf.iana_if_type', 'OpticalTransport'),
    'iana-if-type:other':('ydk.models.ietf.iana_if_type', 'Other'),
    'iana-if-type:otnOdu':('ydk.models.ietf.iana_if_type', 'OtnOdu'),
    'iana-if-type:otnOtu':('ydk.models.ietf.iana_if_type', 'OtnOtu'),
    'iana-if-type:para':('ydk.models.ietf.iana_if_type', 'Para'),
    'iana-if-type:pdnEtherLoop1':('ydk.models.ietf.iana_if_type', 'PdnEtherLoop1'),
    'iana-if-type:pdnEtherLoop2':('ydk.models.ietf.iana_if_type', 'PdnEtherLoop2'),
    'iana-if-type:pip':('ydk.models.ietf.iana_if_type', 'Pip'),
    'iana-if-type:plc':('ydk.models.ietf.iana_if_type', 'Plc'),
    'iana-if-type:pon155':('ydk.models.ietf.iana_if_type', 'Pon155'),
    'iana-if-type:pon622':('ydk.models.ietf.iana_if_type', 'Pon622'),
    'iana-if-type:pos':('ydk.models.ietf.iana_if_type', 'Pos'),
    'iana-if-type:ppp':('ydk.models.ietf.iana_if_type', 'Ppp'),
    'iana-if-type:pppMultilinkBundle':('ydk.models.ietf.iana_if_type', 'PppMultilinkBundle'),
    'iana-if-type:primaryISDN':('ydk.models.ietf.iana_if_type', 'PrimaryISDN'),
    'iana-if-type:propAtm':('ydk.models.ietf.iana_if_type', 'PropAtm'),
    'iana-if-type:propBWAp2Mp':('ydk.models.ietf.iana_if_type', 'PropBWAp2Mp'),
    'iana-if-type:propCnls':('ydk.models.ietf.iana_if_type', 'PropCnls'),
    'iana-if-type:propDocsWirelessDownstream':('ydk.models.ietf.iana_if_type', 'PropDocsWirelessDownstream'),
    'iana-if-type:propDocsWirelessMaclayer':('ydk.models.ietf.iana_if_type', 'PropDocsWirelessMaclayer'),
    'iana-if-type:propDocsWirelessUpstream':('ydk.models.ietf.iana_if_type', 'PropDocsWirelessUpstream'),
    'iana-if-type:propMultiplexor':('ydk.models.ietf.iana_if_type', 'PropMultiplexor'),
    'iana-if-type:propPointToPointSerial':('ydk.models.ietf.iana_if_type', 'PropPointToPointSerial'),
    'iana-if-type:propVirtual':('ydk.models.ietf.iana_if_type', 'PropVirtual'),
    'iana-if-type:propWirelessP2P':('ydk.models.ietf.iana_if_type', 'PropWirelessP2P'),
    'iana-if-type:proteon10Mbit':('ydk.models.ietf.iana_if_type', 'Proteon10Mbit'),
    'iana-if-type:proteon80Mbit':('ydk.models.ietf.iana_if_type', 'Proteon80Mbit'),
    'iana-if-type:q2931':('ydk.models.ietf.iana_if_type', 'Q2931'),
    'iana-if-type:qam':('ydk.models.ietf.iana_if_type', 'Qam'),
    'iana-if-type:qllc':('ydk.models.ietf.iana_if_type', 'Qllc'),
    'iana-if-type:radioMAC':('ydk.models.ietf.iana_if_type', 'RadioMAC'),
    'iana-if-type:radsl':('ydk.models.ietf.iana_if_type', 'Radsl'),
    'iana-if-type:reachDSL':('ydk.models.ietf.iana_if_type', 'ReachDSL'),
    'iana-if-type:regular1822':('ydk.models.ietf.iana_if_type', 'Regular1822'),
    'iana-if-type:rfc1483':('ydk.models.ietf.iana_if_type', 'Rfc1483'),
    'iana-if-type:rfc877x25':('ydk.models.ietf.iana_if_type', 'Rfc877x25'),
    'iana-if-type:rpr':('ydk.models.ietf.iana_if_type', 'Rpr'),
    'iana-if-type:rs232':('ydk.models.ietf.iana_if_type', 'Rs232'),
    'iana-if-type:rsrb':('ydk.models.ietf.iana_if_type', 'Rsrb'),
    'iana-if-type:sdlc':('ydk.models.ietf.iana_if_type', 'Sdlc'),
    'iana-if-type:sdsl':('ydk.models.ietf.iana_if_type', 'Sdsl'),
    'iana-if-type:shdsl':('ydk.models.ietf.iana_if_type', 'Shdsl'),
    'iana-if-type:sip':('ydk.models.ietf.iana_if_type', 'Sip'),
    'iana-if-type:sipSig':('ydk.models.ietf.iana_if_type', 'SipSig'),
    'iana-if-type:sipTg':('ydk.models.ietf.iana_if_type', 'SipTg'),
    'iana-if-type:sixToFour':('ydk.models.ietf.iana_if_type', 'SixToFour'),
    'iana-if-type:slip':('ydk.models.ietf.iana_if_type', 'Slip'),
    'iana-if-type:smdsDxi':('ydk.models.ietf.iana_if_type', 'SmdsDxi'),
    'iana-if-type:smdsIcip':('ydk.models.ietf.iana_if_type', 'SmdsIcip'),
    'iana-if-type:softwareLoopback':('ydk.models.ietf.iana_if_type', 'SoftwareLoopback'),
    'iana-if-type:sonet':('ydk.models.ietf.iana_if_type', 'Sonet'),
    'iana-if-type:sonetOverheadChannel':('ydk.models.ietf.iana_if_type', 'SonetOverheadChannel'),
    'iana-if-type:sonetPath':('ydk.models.ietf.iana_if_type', 'SonetPath'),
    'iana-if-type:sonetVT':('ydk.models.ietf.iana_if_type', 'SonetVT'),
    'iana-if-type:srp':('ydk.models.ietf.iana_if_type', 'Srp'),
    'iana-if-type:ss7SigLink':('ydk.models.ietf.iana_if_type', 'Ss7SigLink'),
    'iana-if-type:stackToStack':('ydk.models.ietf.iana_if_type', 'StackToStack'),
    'iana-if-type:starLan':('ydk.models.ietf.iana_if_type', 'StarLan'),
    'iana-if-type:tdlc':('ydk.models.ietf.iana_if_type', 'Tdlc'),
    'iana-if-type:teLink':('ydk.models.ietf.iana_if_type', 'TeLink'),
    'iana-if-type:termPad':('ydk.models.ietf.iana_if_type', 'TermPad'),
    'iana-if-type:tr008':('ydk.models.ietf.iana_if_type', 'Tr008'),
    'iana-if-type:transpHdlc':('ydk.models.ietf.iana_if_type', 'TranspHdlc'),
    'iana-if-type:tunnel':('ydk.models.ietf.iana_if_type', 'Tunnel'),
    'iana-if-type:ultra':('ydk.models.ietf.iana_if_type', 'Ultra'),
    'iana-if-type:usb':('ydk.models.ietf.iana_if_type', 'Usb'),
    'iana-if-type:v11':('ydk.models.ietf.iana_if_type', 'V11'),
    'iana-if-type:v35':('ydk.models.ietf.iana_if_type', 'V35'),
    'iana-if-type:v36':('ydk.models.ietf.iana_if_type', 'V36'),
    'iana-if-type:v37':('ydk.models.ietf.iana_if_type', 'V37'),
    'iana-if-type:vdsl':('ydk.models.ietf.iana_if_type', 'Vdsl'),
    'iana-if-type:vdsl2':('ydk.models.ietf.iana_if_type', 'Vdsl2'),
    'iana-if-type:virtualIpAddress':('ydk.models.ietf.iana_if_type', 'VirtualIpAddress'),
    'iana-if-type:virtualTg':('ydk.models.ietf.iana_if_type', 'VirtualTg'),
    'iana-if-type:vmwareNicTeam':('ydk.models.ietf.iana_if_type', 'VmwareNicTeam'),
    'iana-if-type:vmwareVirtualNic':('ydk.models.ietf.iana_if_type', 'VmwareVirtualNic'),
    'iana-if-type:voiceDID':('ydk.models.ietf.iana_if_type', 'VoiceDID'),
    'iana-if-type:voiceEBS':('ydk.models.ietf.iana_if_type', 'VoiceEBS'),
    'iana-if-type:voiceEM':('ydk.models.ietf.iana_if_type', 'VoiceEM'),
    'iana-if-type:voiceEMFGD':('ydk.models.ietf.iana_if_type', 'VoiceEMFGD'),
    'iana-if-type:voiceEncap':('ydk.models.ietf.iana_if_type', 'VoiceEncap'),
    'iana-if-type:voiceFGDEANA':('ydk.models.ietf.iana_if_type', 'VoiceFGDEANA'),
    'iana-if-type:voiceFGDOS':('ydk.models.ietf.iana_if_type', 'VoiceFGDOS'),
    'iana-if-type:voiceFXO':('ydk.models.ietf.iana_if_type', 'VoiceFXO'),
    'iana-if-type:voiceFXS':('ydk.models.ietf.iana_if_type', 'VoiceFXS'),
    'iana-if-type:voiceOverAtm':('ydk.models.ietf.iana_if_type', 'VoiceOverAtm'),
    'iana-if-type:voiceOverCable':('ydk.models.ietf.iana_if_type', 'VoiceOverCable'),
    'iana-if-type:voiceOverFrameRelay':('ydk.models.ietf.iana_if_type', 'VoiceOverFrameRelay'),
    'iana-if-type:voiceOverIp':('ydk.models.ietf.iana_if_type', 'VoiceOverIp'),
    'iana-if-type:wwanPP':('ydk.models.ietf.iana_if_type', 'WwanPP'),
    'iana-if-type:wwanPP2':('ydk.models.ietf.iana_if_type', 'WwanPP2'),
    'iana-if-type:x213':('ydk.models.ietf.iana_if_type', 'X213'),
    'iana-if-type:x25huntGroup':('ydk.models.ietf.iana_if_type', 'X25huntGroup'),
    'iana-if-type:x25mlp':('ydk.models.ietf.iana_if_type', 'X25mlp'),
    'iana-if-type:x25ple':('ydk.models.ietf.iana_if_type', 'X25ple'),
    'iana-if-type:x86Laps':('ydk.models.ietf.iana_if_type', 'X86Laps'),
    'ietf-datastores:candidate':('ydk.models.ietf.ietf_datastores', 'Candidate'),
    'ietf-datastores:conventional':('ydk.models.ietf.ietf_datastores', 'Conventional'),
    'ietf-datastores:datastore':('ydk.models.ietf.ietf_datastores', 'Datastore'),
    'ietf-datastores:dynamic':('ydk.models.ietf.ietf_datastores', 'Dynamic'),
    'ietf-datastores:intended':('ydk.models.ietf.ietf_datastores', 'Intended'),
    'ietf-datastores:operational':('ydk.models.ietf.ietf_datastores', 'Operational'),
    'ietf-datastores:running':('ydk.models.ietf.ietf_datastores', 'Running'),
    'ietf-datastores:startup':('ydk.models.ietf.ietf_datastores', 'Startup'),
    'ietf-diffserv-action:algorithmic-drop':('ydk.models.ietf.ietf_diffserv_action', 'AlgorithmicDrop'),
    'ietf-diffserv-action:always-drop':('ydk.models.ietf.ietf_diffserv_action', 'AlwaysDrop'),
    'ietf-diffserv-action:drop-type':('ydk.models.ietf.ietf_diffserv_action', 'DropType'),
    'ietf-diffserv-action:marking':('ydk.models.ietf.ietf_diffserv_action', 'Marking'),
    'ietf-diffserv-action:max-rate':('ydk.models.ietf.ietf_diffserv_action', 'MaxRate'),
    'ietf-diffserv-action:meter':('ydk.models.ietf.ietf_diffserv_action', 'Meter'),
    'ietf-diffserv-action:meter-action-drop':('ydk.models.ietf.ietf_diffserv_action', 'MeterActionDrop'),
    'ietf-diffserv-action:meter-action-set':('ydk.models.ietf.ietf_diffserv_action', 'MeterActionSet'),
    'ietf-diffserv-action:meter-action-type':('ydk.models.ietf.ietf_diffserv_action', 'MeterActionType'),
    'ietf-diffserv-action:min-rate':('ydk.models.ietf.ietf_diffserv_action', 'MinRate'),
    'ietf-diffserv-action:priority':('ydk.models.ietf.ietf_diffserv_action', 'Priority'),
    'ietf-diffserv-action:random-detect':('ydk.models.ietf.ietf_diffserv_action', 'RandomDetect'),
    'ietf-diffserv-action:tail-drop':('ydk.models.ietf.ietf_diffserv_action', 'TailDrop'),
    'ietf-diffserv-classifier:classifier-entry-filter-operation-type':('ydk.models.ietf.ietf_diffserv_classifier', 'ClassifierEntryFilterOperationType'),
    'ietf-diffserv-classifier:destination-ip-address':('ydk.models.ietf.ietf_diffserv_classifier', 'DestinationIpAddress'),
    'ietf-diffserv-classifier:destination-port':('ydk.models.ietf.ietf_diffserv_classifier', 'DestinationPort'),
    'ietf-diffserv-classifier:dscp':('ydk.models.ietf.ietf_diffserv_classifier', 'Dscp'),
    'ietf-diffserv-classifier:filter-type':('ydk.models.ietf.ietf_diffserv_classifier', 'FilterType'),
    'ietf-diffserv-classifier:match-all-filter':('ydk.models.ietf.ietf_diffserv_classifier', 'MatchAllFilter'),
    'ietf-diffserv-classifier:match-any-filter':('ydk.models.ietf.ietf_diffserv_classifier', 'MatchAnyFilter'),
    'ietf-diffserv-classifier:protocol':('ydk.models.ietf.ietf_diffserv_classifier', 'Protocol'),
    'ietf-diffserv-classifier:source-ip-address':('ydk.models.ietf.ietf_diffserv_classifier', 'SourceIpAddress'),
    'ietf-diffserv-classifier:source-port':('ydk.models.ietf.ietf_diffserv_classifier', 'SourcePort'),
    'ietf-diffserv-policy:action-type':('ydk.models.ietf.ietf_diffserv_policy', 'ActionType'),
    'ietf-diffserv-target:direction':('ydk.models.ietf.ietf_diffserv_target', 'Direction'),
    'ietf-diffserv-target:inbound':('ydk.models.ietf.ietf_diffserv_target', 'Inbound'),
    'ietf-diffserv-target:outbound':('ydk.models.ietf.ietf_diffserv_target', 'Outbound'),
    'ietf-event-notifications:active':('ydk.models.ietf.ietf_event_notifications', 'Active'),
    'ietf-event-notifications:encode-json':('ydk.models.ietf.ietf_event_notifications', 'EncodeJson'),
    'ietf-event-notifications:encode-xml':('ydk.models.ietf.ietf_event_notifications', 'EncodeXml'),
    'ietf-event-notifications:encodings':('ydk.models.ietf.ietf_event_notifications', 'Encodings'),
    'ietf-event-notifications:error':('ydk.models.ietf.ietf_event_notifications', 'Error'),
    'ietf-event-notifications:error-configured-subscription':('ydk.models.ietf.ietf_event_notifications', 'ErrorConfiguredSubscription'),
    'ietf-event-notifications:error-insufficient-resources':('ydk.models.ietf.ietf_event_notifications', 'ErrorInsufficientResources'),
    'ietf-event-notifications:error-no-such-option':('ydk.models.ietf.ietf_event_notifications', 'ErrorNoSuchOption'),
    'ietf-event-notifications:error-no-such-subscription':('ydk.models.ietf.ietf_event_notifications', 'ErrorNoSuchSubscription'),
    'ietf-event-notifications:error-other':('ydk.models.ietf.ietf_event_notifications', 'ErrorOther'),
    'ietf-event-notifications:in-error':('ydk.models.ietf.ietf_event_notifications', 'InError'),
    'ietf-event-notifications:inactive':('ydk.models.ietf.ietf_event_notifications', 'Inactive'),
    'ietf-event-notifications:internal-error':('ydk.models.ietf.ietf_event_notifications', 'InternalError'),
    'ietf-event-notifications:NETCONF':('ydk.models.ietf.ietf_event_notifications', 'NETCONF'),
    'ietf-event-notifications:netconf':('ydk.models.ietf.ietf_event_notifications', 'Netconf'),
    'ietf-event-notifications:no-resources':('ydk.models.ietf.ietf_event_notifications', 'NoResources'),
    'ietf-event-notifications:ok':('ydk.models.ietf.ietf_event_notifications', 'Ok'),
    'ietf-event-notifications:other':('ydk.models.ietf.ietf_event_notifications', 'Other'),
    'ietf-event-notifications:stream':('ydk.models.ietf.ietf_event_notifications', 'Stream'),
    'ietf-event-notifications:subscription-deleted':('ydk.models.ietf.ietf_event_notifications', 'SubscriptionDeleted'),
    'ietf-event-notifications:subscription-errors':('ydk.models.ietf.ietf_event_notifications', 'SubscriptionErrors'),
    'ietf-event-notifications:subscription-result':('ydk.models.ietf.ietf_event_notifications', 'SubscriptionResult'),
    'ietf-event-notifications:subscription-stream-status':('ydk.models.ietf.ietf_event_notifications', 'SubscriptionStreamStatus'),
    'ietf-event-notifications:suspended':('ydk.models.ietf.ietf_event_notifications', 'Suspended'),
    'ietf-event-notifications:transport':('ydk.models.ietf.ietf_event_notifications', 'Transport'),
    'ietf-interfaces:interface-type':('ydk.models.ietf.ietf_interfaces', 'InterfaceType'),
    'ietf-ipv4-unicast-routing:ipv4-unicast':('ydk.models.ietf.ietf_ipv4_unicast_routing', 'Ipv4Unicast'),
    'ietf-ipv6-unicast-routing:ipv6-unicast':('ydk.models.ietf.ietf_ipv6_unicast_routing', 'Ipv6Unicast'),
    'ietf-netconf-monitoring:netconf-beep':('ydk.models.ietf.ietf_netconf_monitoring', 'NetconfBeep'),
    'ietf-netconf-monitoring:netconf-soap-over-beep':('ydk.models.ietf.ietf_netconf_monitoring', 'NetconfSoapOverBeep'),
    'ietf-netconf-monitoring:netconf-soap-over-https':('ydk.models.ietf.ietf_netconf_monitoring', 'NetconfSoapOverHttps'),
    'ietf-netconf-monitoring:netconf-ssh':('ydk.models.ietf.ietf_netconf_monitoring', 'NetconfSsh'),
    'ietf-netconf-monitoring:netconf-tls':('ydk.models.ietf.ietf_netconf_monitoring', 'NetconfTls'),
    'ietf-netconf-monitoring:rnc':('ydk.models.ietf.ietf_netconf_monitoring', 'Rnc'),
    'ietf-netconf-monitoring:rng':('ydk.models.ietf.ietf_netconf_monitoring', 'Rng'),
    'ietf-netconf-monitoring:schema-format':('ydk.models.ietf.ietf_netconf_monitoring', 'SchemaFormat'),
    'ietf-netconf-monitoring:transport':('ydk.models.ietf.ietf_netconf_monitoring', 'Transport'),
    'ietf-netconf-monitoring:xsd':('ydk.models.ietf.ietf_netconf_monitoring', 'Xsd'),
    'ietf-netconf-monitoring:yang':('ydk.models.ietf.ietf_netconf_monitoring', 'Yang'),
    'ietf-netconf-monitoring:yin':('ydk.models.ietf.ietf_netconf_monitoring', 'Yin'),
    'ietf-ospf:area-type':('ydk.models.ietf.ietf_ospf', 'AreaType'),
    'ietf-ospf:if-link-type':('ydk.models.ietf.ietf_ospf', 'IfLinkType'),
    'ietf-ospf:if-link-type-normal':('ydk.models.ietf.ietf_ospf', 'IfLinkTypeNormal'),
    'ietf-ospf:if-link-type-sham-link':('ydk.models.ietf.ietf_ospf', 'IfLinkTypeShamLink'),
    'ietf-ospf:if-link-type-virtual-link':('ydk.models.ietf.ietf_ospf', 'IfLinkTypeVirtualLink'),
    'ietf-ospf:normal':('ydk.models.ietf.ietf_ospf', 'Normal'),
    'ietf-ospf:nssa':('ydk.models.ietf.ietf_ospf', 'Nssa'),
    'ietf-ospf:operation-mode':('ydk.models.ietf.ietf_ospf', 'OperationMode'),
    'ietf-ospf:ospf':('ydk.models.ietf.ietf_ospf', 'Ospf'),
    'ietf-ospf:ospfv2':('ydk.models.ietf.ietf_ospf', 'Ospfv2'),
    'ietf-ospf:ospfv3':('ydk.models.ietf.ietf_ospf', 'Ospfv3'),
    'ietf-ospf:ships-in-the-night':('ydk.models.ietf.ietf_ospf', 'ShipsInTheNight'),
    'ietf-ospf:stub':('ydk.models.ietf.ietf_ospf', 'Stub'),
    'ietf-routing:address-family':('ydk.models.ietf.ietf_routing', 'AddressFamily'),
    'ietf-routing:default-routing-instance':('ydk.models.ietf.ietf_routing', 'DefaultRoutingInstance'),
    'ietf-routing:direct':('ydk.models.ietf.ietf_routing', 'Direct'),
    'ietf-routing:ipv4':('ydk.models.ietf.ietf_routing', 'Ipv4'),
    'ietf-routing:ipv6':('ydk.models.ietf.ietf_routing', 'Ipv6'),
    'ietf-routing:routing-instance':('ydk.models.ietf.ietf_routing', 'RoutingInstance'),
    'ietf-routing:routing-protocol':('ydk.models.ietf.ietf_routing', 'RoutingProtocol'),
    'ietf-routing:static':('ydk.models.ietf.ietf_routing', 'Static'),
    'ietf-routing:vrf-routing-instance':('ydk.models.ietf.ietf_routing', 'VrfRoutingInstance'),
    'ietf-syslog-types:audit':('ydk.models.ietf.ietf_syslog_types', 'Audit'),
    'ietf-syslog-types:auth':('ydk.models.ietf.ietf_syslog_types', 'Auth'),
    'ietf-syslog-types:authpriv':('ydk.models.ietf.ietf_syslog_types', 'Authpriv'),
    'ietf-syslog-types:console':('ydk.models.ietf.ietf_syslog_types', 'Console'),
    'ietf-syslog-types:cron':('ydk.models.ietf.ietf_syslog_types', 'Cron'),
    'ietf-syslog-types:cron2':('ydk.models.ietf.ietf_syslog_types', 'Cron2'),
    'ietf-syslog-types:daemon':('ydk.models.ietf.ietf_syslog_types', 'Daemon'),
    'ietf-syslog-types:ftp':('ydk.models.ietf.ietf_syslog_types', 'Ftp'),
    'ietf-syslog-types:kern':('ydk.models.ietf.ietf_syslog_types', 'Kern'),
    'ietf-syslog-types:local0':('ydk.models.ietf.ietf_syslog_types', 'Local0'),
    'ietf-syslog-types:local1':('ydk.models.ietf.ietf_syslog_types', 'Local1'),
    'ietf-syslog-types:local2':('ydk.models.ietf.ietf_syslog_types', 'Local2'),
    'ietf-syslog-types:local3':('ydk.models.ietf.ietf_syslog_types', 'Local3'),
    'ietf-syslog-types:local4':('ydk.models.ietf.ietf_syslog_types', 'Local4'),
    'ietf-syslog-types:local5':('ydk.models.ietf.ietf_syslog_types', 'Local5'),
    'ietf-syslog-types:local6':('ydk.models.ietf.ietf_syslog_types', 'Local6'),
    'ietf-syslog-types:local7':('ydk.models.ietf.ietf_syslog_types', 'Local7'),
    'ietf-syslog-types:lpr':('ydk.models.ietf.ietf_syslog_types', 'Lpr'),
    'ietf-syslog-types:mail':('ydk.models.ietf.ietf_syslog_types', 'Mail'),
    'ietf-syslog-types:news':('ydk.models.ietf.ietf_syslog_types', 'News'),
    'ietf-syslog-types:ntp':('ydk.models.ietf.ietf_syslog_types', 'Ntp'),
    'ietf-syslog-types:syslog':('ydk.models.ietf.ietf_syslog_types', 'Syslog'),
    'ietf-syslog-types:syslog-facility':('ydk.models.ietf.ietf_syslog_types', 'SyslogFacility'),
    'ietf-syslog-types:user':('ydk.models.ietf.ietf_syslog_types', 'User'),
    'ietf-syslog-types:uucp':('ydk.models.ietf.ietf_syslog_types', 'Uucp'),
    'ietf-yang-push:custom-stream':('ydk.models.ietf.ietf_yang_push', 'CustomStream'),
    'ietf-yang-push:error-data-not-authorized':('ydk.models.ietf.ietf_yang_push', 'ErrorDataNotAuthorized'),
    'ietf-yang-push:http2':('ydk.models.ietf.ietf_yang_push', 'Http2'),
    'ietf-yang-push:yang-push':('ydk.models.ietf.ietf_yang_push', 'YangPush'),
    'ietf-yang-smiv2:object-identity':('ydk.models.ietf.ietf_yang_smiv2', 'ObjectIdentity'),
    'policy-types:access-control':('ydk.models.ietf.policy_types', 'AccessControl'),
    'policy-types:access-control-class':('ydk.models.ietf.policy_types', 'AccessControlClass'),
    'policy-types:application':('ydk.models.ietf.policy_types', 'Application'),
    'policy-types:appnav':('ydk.models.ietf.policy_types', 'Appnav'),
    'policy-types:appnav-class':('ydk.models.ietf.policy_types', 'AppnavClass'),
    'policy-types:atm-clp':('ydk.models.ietf.policy_types', 'AtmClp'),
    'policy-types:atm-vci':('ydk.models.ietf.policy_types', 'AtmVci'),
    'policy-types:class-map':('ydk.models.ietf.policy_types', 'ClassMap'),
    'policy-types:class-type':('ydk.models.ietf.policy_types', 'ClassType'),
    'policy-types:control':('ydk.models.ietf.policy_types', 'Control'),
    'policy-types:control-class':('ydk.models.ietf.policy_types', 'ControlClass'),
    'policy-types:cos':('ydk.models.ietf.policy_types', 'Cos'),
    'policy-types:cos-inner':('ydk.models.ietf.policy_types', 'CosInner'),
    'policy-types:dei':('ydk.models.ietf.policy_types', 'Dei'),
    'policy-types:dei-inner':('ydk.models.ietf.policy_types', 'DeiInner'),
    'policy-types:discard-class':('ydk.models.ietf.policy_types', 'DiscardClass'),
    'policy-types:dst-mac':('ydk.models.ietf.policy_types', 'DstMac'),
    'policy-types:flow-de':('ydk.models.ietf.policy_types', 'FlowDe'),
    'policy-types:flow-dlci':('ydk.models.ietf.policy_types', 'FlowDlci'),
    'policy-types:flow-ip':('ydk.models.ietf.policy_types', 'FlowIp'),
    'policy-types:flow-record':('ydk.models.ietf.policy_types', 'FlowRecord'),
    'policy-types:input-interface':('ydk.models.ietf.policy_types', 'InputInterface'),
    'policy-types:inspect':('ydk.models.ietf.policy_types', 'Inspect'),
    'policy-types:inspect-class':('ydk.models.ietf.policy_types', 'InspectClass'),
    'policy-types:ip-rtp':('ydk.models.ietf.policy_types', 'IpRtp'),
    'policy-types:ipv4-acl':('ydk.models.ietf.policy_types', 'Ipv4Acl'),
    'policy-types:ipv4-acl-name':('ydk.models.ietf.policy_types', 'Ipv4AclName'),
    'policy-types:ipv6-acl':('ydk.models.ietf.policy_types', 'Ipv6Acl'),
    'policy-types:ipv6-acl-name':('ydk.models.ietf.policy_types', 'Ipv6AclName'),
    'policy-types:metadata':('ydk.models.ietf.policy_types', 'Metadata'),
    'policy-types:mpls-exp-imp':('ydk.models.ietf.policy_types', 'MplsExpImp'),
    'policy-types:mpls-exp-top':('ydk.models.ietf.policy_types', 'MplsExpTop'),
    'policy-types:packet-length':('ydk.models.ietf.policy_types', 'PacketLength'),
    'policy-types:packet-service':('ydk.models.ietf.policy_types', 'PacketService'),
    'policy-types:pbr':('ydk.models.ietf.policy_types', 'Pbr'),
    'policy-types:perf-mon':('ydk.models.ietf.policy_types', 'PerfMon'),
    'policy-types:policy-type':('ydk.models.ietf.policy_types', 'PolicyType'),
    'policy-types:prec':('ydk.models.ietf.policy_types', 'Prec'),
    'policy-types:qos':('ydk.models.ietf.policy_types', 'Qos'),
    'policy-types:qos-class':('ydk.models.ietf.policy_types', 'QosClass'),
    'policy-types:qos-group':('ydk.models.ietf.policy_types', 'QosGroup'),
    'policy-types:security-group-name':('ydk.models.ietf.policy_types', 'SecurityGroupName'),
    'policy-types:security-group-tag':('ydk.models.ietf.policy_types', 'SecurityGroupTag'),
    'policy-types:service':('ydk.models.ietf.policy_types', 'Service'),
    'policy-types:src-mac':('ydk.models.ietf.policy_types', 'SrcMac'),
    'policy-types:vlan':('ydk.models.ietf.policy_types', 'Vlan'),
    'policy-types:vlan-inner':('ydk.models.ietf.policy_types', 'VlanInner'),
    'policy-types:vpls':('ydk.models.ietf.policy_types', 'Vpls'),
    'policy-types:wlan-user-priority':('ydk.models.ietf.policy_types', 'WlanUserPriority'),
}

