# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytest_accept', 'pytest_accept.tests']

package_data = \
{'': ['*']}

install_requires = \
['pytest>=6,<7']

entry_points = \
{'pytest11': ['accept = pytest_accept']}

setup_kwargs = {
    'name': 'pytest-accept',
    'version': '0.1.1',
    'description': 'A pytest-plugin for updating doctest outputs',
    'long_description': '# pytest-accept\n\npytest-accept is a pytest plugin for automatically updating doctest outputs. It\nobserves generated outputs by running doctests, and writes these to the\ndoctests\' documented outputs.\n\nIt\'s designed for a couple of use cases:\n\n- People who work with doctests and don\'t enjoy manually copying and pasting\n  generated outputs from the pytest error log into their doctests\' documented\n  outputs. pytest-accept does the copying & pasting for you.\n- People who generally find writing tests a bit annoying, and prefer to develop\n  by "running the code and seeing whether it works". This library aims to allow\n  testing to become a joyful part of that development loop.\n\npytest-accept is decoupled from the doctests it works with — it can be used with\nexisting doctests, and the doctests it edits are no different to normal\ndoctests.\n\n## Jesse, what the?\n\nHere\'s an example of pytest-accept does: given a file like\n[**`add.py`**](examples/add.py) containing an incorrect documented output:\n\n```python\ndef add(x, y):\n    """\n    Adds two values.\n\n    >>> add(1, 1)\n    3\n\n    >>> add("ab", "c")\n    \'bac\'\n    """\n\n    return x + y\n```\n\n...running doctests using pytest and passing `--accept` replaces the existing\nincorrect values with correct values:\n\n```sh\npytest --doctest-modules examples/add.py --accept\n```\n\n```diff\ndiff --git a/examples/add.py b/examples/add.py\nindex 10a71fd..c2c945f 100644\n--- a/examples/add.py\n+++ b/examples/add.py\n@@ -3,10 +3,10 @@ def add(x, y):\n     Adds two values.\n \n     >>> add(1, 1)\n-    3\n+    2\n \n     >>> add("ab", "c")\n-    \'bac\'\n+    \'abc\'\n     """\n \n     return x + y\n\n```\n\nThis style of testing is fairly well-developed in some languages, although still\ndoesn\'t receive the attention I think it deserves, and historically hasn\'t had\ngood support in python.\n\nConfusingly, it\'s referred to "snapshot testing" or "regression testing" or\n"expect testing" or "literate testing" or "acceptance testing". The best\nexplanation I\'ve seen on this testing style is from Ron Minsky in a [Jane Street\nBlogpost](https://blog.janestreet.com/testing-with-expectations/).\n\n## Installation\n\n```sh\npip install pytest-accept\n```\n\n## What about normal tests?\n\nA previous effort in [**`assert_plugin.py`**](pytest_accept/assert_plugin.py)\nattempted to do this for `assert` statements, and the file contains some notes\non the effort. The biggest problem is pytest stops on the first `assert` failure\nin each test, which is very limiting. (Whereas pytest can be configured to\ncontinue on doctest failures, which this library takes advantage of.)\n\nIt\'s [probably possible to change pytest\'s\nbehavior](https://mail.python.org/pipermail/pytest-dev/2020-March/004918.html)\nhere, but it\'s a significant effort on the pytest codebase.\n\nSome alternatives:\n\n- Use an existing library like\n  [pytest-regtest](https://gitlab.com/uweschmitt/pytest-regtest), which offers\n  file snapshot testing (i.e. not inline).\n- We could write a specific function / fixture, like `accept(result, "abc")`,\n  similar to frameworks like rust\'s excellent\n  [insta](https://github.com/mitsuhiko/insta) (which I developed some features\n  for), or [ocaml\'s ppx_expect](https://github.com/janestreet/ppx_expect).\n  - But this has the disadvantage of coupling the test to the plugin: it\'s not\n    possible to run tests independently of the plugin, or use the plugin on\n    general `assert` tests. And one of the great elegances of pytest is its\n    deferral to a normal `assert` statement.\n- Some of this testing feels like writing a notebook and testing that.\n  [pytest-notebook](https://github.com/chrisjsewell/pytest-notebook) fully\n  implements this.\n\n## Anything else?\n\nNot really! Some things to watch out for:\n\n- It\'ll replace the file at the end of a test. So — to the extent there are\n  useful changes to the file between the start and and the end of a test — it\'ll\n  overwrite them. Passing `--accept-copy` will cause the plugin to instead\n  create a file named `{file}.py.new`.\n  - TODO: Should we disable the plugin on `--pdb` as one way of long-running\n    tests?\n  - It will overwrite the existing values, though these aren\'t generally useful\n    — they\'re designed to match the results of the code.\n- This is early, and there are probably some small bugs. Let me know and I\'ll\n  attempt to fix them.\n- It currently doesn\'t affect the printing of test results; the doctests will\n  still print as failures.\n  - TODO: A future version could print something about them being fixed.\n- Python\'s doctest library is imperfect:\n  - It can\'t handle indents, and probably other things. (We do handle blank\n    lines though, and TODO: check whether the output we paste is valid doctest\n    output).\n  - The syntax for `.*` is an ellipsis `...`, which is also the syntax for\n    continuing a code line, so it can\'t be at the start of a line.\n  - The syntax for all the directives is arguably less than aesthetically\n    pleasing.\n  - It reports line numbers incorrectly in some cases —\xa0two docstring lines\n    separated with continuation character `\\` is counted as one, meaning this\n    library will not have access to the correct line number for doctest inputs\n    and outputs.\n',
    'author': 'Maximilian Roos',
    'author_email': 'm@maxroos.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/max-sixty/pytest-accept',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.10',
}


setup(**setup_kwargs)
