#
# Copyright 2025 Splunk Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
datamodels = {
    "4.18.1": {
        "Alerts": {
            "BaseEvent": [
                "app",
                "dest",
                "severity",
                "signature_id",
                "src",
                "type",
                "user",
            ]
        },
        "Application_State": {
            "BaseEvent": ["dest", "process"],
            "Ports": ["dest_port", "transport"],
            "Services": ["service", "service_id", "start_mode", "status"],
        },
        "Authentication": {
            "BaseEvent": ["action", "app", "src", "src_user", "dest", "user"]
        },
        "Certificates": {
            "SSL": [
                "ssl_end_time",
                "ssl_serial",
                "ssl_start_time",
                "ssl_hash",
                "ssl_issuer",
                "ssl_issuer_common_name",
                "ssl_issuer_email_domain",
                "ssl_subject",
                "ssl_subject_common_name",
                "ssl_subject_email_domain",
            ]
        },
        "Change": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Instance_Changes": ["image_id", "instance_type"],
        },
        "Change_Analysis": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Filesystem_Changes": [
                "file_access_time",
                "file_create_time",
                "file_hash",
                "file_modify_time",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
            ],
        },
        "Compute_Inventory": {
            "BaseEvent": ["dest", "vendor_product"],
            "CPU": ["cpu_cores", "cpu_count", "cpu_mhz"],
            "Memory": ["mem"],
            "Network": ["dns", "interface", "ip", "mac", "name"],
            "OS": ["os"],
            "Snapshot": ["size", "snapshot"],
            "Storage": ["mount", "storage"],
            "User": ["interactive", "password", "user"],
            "Virtual_OS": ["hypervisor"],
        },
        "DLP": {
            "BaseEvent": [
                "action",
                "category",
                "dvc",
                "dlp_type",
                "object",
                "object_path",
                "object_category",
                "signature",
                "severity",
                "src",
                "src_user",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Email": {
            "BaseEvent": [
                "action",
                "dest",
                "src",
                "recipient",
                "recipient_domain",
                "src_user",
                "src_user_domain",
                "vendor_product",
            ],
            "Filtering": ["signature"],
        },
        "Endpoint": {
            "Filesystem": [
                "file_access_time",
                "file_create_time",
                "file_modify_time",
                "action",
                "dest",
                "file_hash",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
                "user",
                "vendor_product",
            ],
            "Ports": [
                "dest_port",
                "transport",
                "src",
                "src_port",
                "dest",
                "user",
                "vendor_product",
            ],
            "Processes": [
                "dest",
                "parent_process",
                "parent_process_name",
                "process",
                "process_name",
                "user",
                "vendor_product",
            ],
            "Registry": [
                "action",
                "dest",
                "registry_path",
                "registry_key_name",
                "registry_value_data",
                "registry_value_name",
                "registry_value_type",
                "user",
                "vendor_product",
            ],
            "Services": [
                "dest",
                "service",
                "service_name",
                "service_id",
                "start_mode",
                "status",
                "user",
                "vendor_product",
            ],
        },
        "Event_Signatures": {"BaseEvent": ["vendor_product"]},
        "Intrusion_Detection": {
            "BaseEvent": [
                "dvc",
                "ids_type",
                "category",
                "signature",
                "severity",
                "src",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Malware": {
            "BaseEvent": [
                "action",
                "category",
                "date",
                "dest",
                "dest_nt_domain",
                "severity",
                "signature",
                "user",
                "vendor_product",
            ],
            "Malware_Operations": [
                "product_version",
                "signature_version",
                "dest",
                "dest_nt_domain",
                "vendor_product",
            ],
        },
        "Network_Resolution": {
            "BaseEvent": [
                "answer",
                "dest",
                "message_type",
                "query",
                "reply_code_id",
                "reply_code",
                "vendor_product",
            ]
        },
        "Network_Sessions": {
            "BaseEvent": [
                "dest_ip",
                "dest_mac",
                "dest_nt_host",
                "dest_dns",
                "user",
                "vendor_product",
            ]
        },
        "Network_Traffic": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "dest_port",
                "dvc",
                "rule",
                "src",
                "src_port",
                "transport",
                "user",
                "vendor_product",
            ]
        },
        "Performance": {
            "BaseEvent": ["dest"],
            "CPU": ["cpu_load_percent"],
            "Facilities": ["temperature"],
            "Memory": ["mem", "mem_free", "mem_used"],
            "Network": ["thruput"],
            "OS": ["signature"],
            "Storage": [
                "storage_free",
                "storage_free_percent",
                "storage_used",
                "storage_used_percent",
            ],
            "Timesync": ["action"],
            "Uptime": ["uptime"],
        },
        "Updates": {
            "BaseEvent": [
                "dest",
                "signature",
                "signature_id",
                "status",
                "vendor_product",
            ]
        },
        "Vulnerabilities": {
            "BaseEvent": [
                "category",
                "cve",
                "dest",
                "dvc",
                "severity",
                "signature",
                "vendor_product",
            ]
        },
        "Web": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "http_content_type",
                "http_method",
                "http_referrer",
                "http_referrer_domain",
                "http_user_agent",
                "src",
                "status",
                "url",
                "url_domain",
                "user",
                "vendor_product",
            ]
        },
    },
    "4.19": {
        "Alerts": {
            "BaseEvent": [
                "app",
                "dest",
                "severity",
                "signature_id",
                "src",
                "type",
                "user",
                "user_name",
            ]
        },
        "Application_State": {
            "BaseEvent": ["dest", "process"],
            "Ports": ["dest_port", "transport"],
            "Services": ["service", "service_id", "start_mode", "status"],
        },
        "Authentication": {
            "BaseEvent": ["action", "app", "src", "src_user", "dest", "user"]
        },
        "Certificates": {
            "SSL": [
                "ssl_end_time",
                "ssl_serial",
                "ssl_start_time",
                "ssl_hash",
                "ssl_issuer",
                "ssl_issuer_common_name",
                "ssl_issuer_email_domain",
                "ssl_subject",
                "ssl_subject_common_name",
                "ssl_subject_email_domain",
            ]
        },
        "Change": {
            "Account_Management": [
                "dest_nt_domain",
                "src_nt_domain",
                "src_user",
                "src_user_name",
            ],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "user_name",
                "vendor_product",
                "action",
            ],
            "Instance_Changes": ["image_id", "instance_type"],
        },
        "Change_Analysis": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Filesystem_Changes": [
                "file_access_time",
                "file_create_time",
                "file_hash",
                "file_modify_time",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
            ],
        },
        "Compute_Inventory": {
            "BaseEvent": ["dest", "vendor_product"],
            "CPU": ["cpu_cores", "cpu_count", "cpu_mhz"],
            "Memory": ["mem"],
            "Network": ["dns", "interface", "ip", "mac", "name"],
            "OS": ["os"],
            "Snapshot": ["size", "snapshot"],
            "Storage": ["mount", "storage"],
            "User": ["interactive", "password", "user"],
            "Virtual_OS": ["hypervisor"],
        },
        "DLP": {
            "BaseEvent": [
                "action",
                "category",
                "dvc",
                "dlp_type",
                "object",
                "object_path",
                "object_category",
                "signature",
                "severity",
                "src",
                "src_user",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Email": {
            "BaseEvent": [
                "action",
                "dest",
                "src",
                "recipient",
                "recipient_domain",
                "src_user",
                "src_user_domain",
                "vendor_product",
            ],
            "Filtering": ["signature"],
        },
        "Endpoint": {
            "Filesystem": [
                "file_access_time",
                "file_create_time",
                "file_modify_time",
                "action",
                "dest",
                "file_hash",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
                "user",
                "vendor_product",
            ],
            "Ports": [
                "dest_port",
                "transport",
                "src",
                "src_port",
                "dest",
                "user",
                "vendor_product",
            ],
            "Processes": [
                "dest",
                "parent_process",
                "parent_process_name",
                "process",
                "process_name",
                "user",
                "vendor_product",
            ],
            "Registry": [
                "action",
                "dest",
                "registry_path",
                "registry_key_name",
                "registry_value_data",
                "registry_value_name",
                "registry_value_type",
                "user",
                "vendor_product",
            ],
            "Services": [
                "dest",
                "service",
                "service_name",
                "service_id",
                "start_mode",
                "status",
                "user",
                "vendor_product",
            ],
        },
        "Event_Signatures": {"BaseEvent": ["vendor_product"]},
        "Intrusion_Detection": {
            "BaseEvent": [
                "dvc",
                "ids_type",
                "category",
                "signature",
                "severity",
                "src",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Malware": {
            "BaseEvent": [
                "action",
                "category",
                "date",
                "dest",
                "dest_nt_domain",
                "severity",
                "signature",
                "user",
                "vendor_product",
            ],
            "Malware_Operations": [
                "product_version",
                "signature_version",
                "dest",
                "dest_nt_domain",
                "vendor_product",
            ],
        },
        "Network_Resolution": {
            "BaseEvent": [
                "answer",
                "dest",
                "message_type",
                "query",
                "reply_code_id",
                "reply_code",
                "vendor_product",
            ]
        },
        "Network_Sessions": {
            "BaseEvent": [
                "dest_ip",
                "dest_mac",
                "dest_nt_host",
                "dest_dns",
                "user",
                "vendor_product",
            ]
        },
        "Network_Traffic": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "dest_port",
                "dvc",
                "rule",
                "src",
                "src_port",
                "transport",
                "user",
                "vendor_product",
            ]
        },
        "Performance": {
            "BaseEvent": ["dest"],
            "CPU": ["cpu_load_percent"],
            "Facilities": ["temperature"],
            "Memory": ["mem", "mem_free", "mem_used"],
            "Network": ["thruput"],
            "OS": ["signature"],
            "Storage": [
                "storage_free",
                "storage_free_percent",
                "storage_used",
                "storage_used_percent",
            ],
            "Timesync": ["action"],
            "Uptime": ["uptime"],
        },
        "Updates": {
            "BaseEvent": [
                "dest",
                "signature",
                "signature_id",
                "status",
                "vendor_product",
            ]
        },
        "Vulnerabilities": {
            "BaseEvent": [
                "category",
                "cve",
                "dest",
                "dvc",
                "severity",
                "signature",
                "vendor_product",
            ]
        },
        "Web": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "http_content_type",
                "http_method",
                "http_referrer",
                "http_referrer_domain",
                "http_user_agent",
                "src",
                "status",
                "url",
                "url_domain",
                "user",
                "vendor_product",
            ]
        },
    },
    "4.20.2": {
        "Alerts": {
            "BaseEvent": [
                "app",
                "dest",
                "severity",
                "signature_id",
                "src",
                "type",
                "user",
                "user_name",
            ]
        },
        "Application_State": {
            "BaseEvent": ["dest", "process"],
            "Ports": ["dest_port", "transport"],
            "Services": ["service", "service_id", "start_mode", "status"],
        },
        "Authentication": {
            "BaseEvent": ["action", "app", "src", "src_user", "dest", "user"]
        },
        "Certificates": {
            "SSL": [
                "ssl_end_time",
                "ssl_serial",
                "ssl_start_time",
                "ssl_hash",
                "ssl_issuer",
                "ssl_issuer_common_name",
                "ssl_issuer_email_domain",
                "ssl_subject",
                "ssl_subject_common_name",
                "ssl_subject_email_domain",
            ]
        },
        "Change": {
            "Account_Management": [
                "dest_nt_domain",
                "src_nt_domain",
                "src_user",
                "src_user_name",
            ],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "user_name",
                "vendor_product",
                "action",
            ],
            "Instance_Changes": ["image_id", "instance_type"],
        },
        "Change_Analysis": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Filesystem_Changes": [
                "file_access_time",
                "file_create_time",
                "file_hash",
                "file_modify_time",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
            ],
        },
        "Compute_Inventory": {
            "BaseEvent": ["dest", "vendor_product"],
            "CPU": ["cpu_cores", "cpu_count", "cpu_mhz"],
            "Memory": ["mem"],
            "Network": ["dns", "interface", "ip", "mac", "name"],
            "OS": ["os"],
            "Snapshot": ["size", "snapshot"],
            "Storage": ["mount", "storage"],
            "User": ["interactive", "password", "user"],
            "Virtual_OS": ["hypervisor"],
        },
        "DLP": {
            "BaseEvent": [
                "action",
                "category",
                "dvc",
                "dlp_type",
                "object",
                "object_path",
                "object_category",
                "signature",
                "severity",
                "src",
                "src_user",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Data_Access": {
            "BaseEvent": [
                "action",
                "app",
                "dest",
                "object",
                "object_category",
                "object_id",
                "object_size",
                "src",
                "tenant_id",
                "user",
                "vendor_product",
            ]
        },
        "Email": {
            "BaseEvent": [
                "action",
                "dest",
                "src",
                "recipient",
                "recipient_domain",
                "src_user",
                "src_user_domain",
                "vendor_product",
            ],
            "Filtering": ["signature"],
        },
        "Endpoint": {
            "Filesystem": [
                "file_access_time",
                "file_create_time",
                "file_modify_time",
                "action",
                "dest",
                "file_hash",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
                "user",
                "vendor_product",
            ],
            "Ports": [
                "dest_port",
                "transport",
                "src",
                "src_port",
                "dest",
                "user",
                "vendor_product",
            ],
            "Processes": [
                "dest",
                "original_file_name",
                "parent_process",
                "parent_process_name",
                "process",
                "process_name",
                "user",
                "vendor_product",
            ],
            "Registry": [
                "action",
                "dest",
                "registry_path",
                "registry_key_name",
                "registry_value_data",
                "registry_value_name",
                "registry_value_type",
                "user",
                "vendor_product",
            ],
            "Services": [
                "dest",
                "service",
                "service_name",
                "service_id",
                "start_mode",
                "status",
                "user",
                "vendor_product",
            ],
        },
        "Event_Signatures": {"BaseEvent": ["vendor_product"]},
        "Intrusion_Detection": {
            "BaseEvent": [
                "dvc",
                "ids_type",
                "category",
                "signature",
                "severity",
                "src",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Malware": {
            "BaseEvent": [
                "action",
                "category",
                "date",
                "dest",
                "dest_nt_domain",
                "severity",
                "signature",
                "user",
                "vendor_product",
            ],
            "Malware_Operations": [
                "product_version",
                "signature_version",
                "dest",
                "dest_nt_domain",
                "vendor_product",
            ],
        },
        "Network_Resolution": {
            "BaseEvent": [
                "answer",
                "dest",
                "message_type",
                "query",
                "reply_code_id",
                "reply_code",
                "vendor_product",
            ]
        },
        "Network_Sessions": {
            "BaseEvent": [
                "dest_ip",
                "dest_mac",
                "dest_nt_host",
                "dest_dns",
                "user",
                "vendor_product",
            ]
        },
        "Network_Traffic": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "dest_port",
                "dvc",
                "rule",
                "src",
                "src_port",
                "transport",
                "user",
                "vendor_product",
            ]
        },
        "Performance": {
            "BaseEvent": ["dest"],
            "CPU": ["cpu_load_percent"],
            "Facilities": ["temperature"],
            "Memory": ["mem", "mem_free", "mem_used"],
            "Network": ["thruput"],
            "OS": ["signature"],
            "Storage": [
                "storage_free",
                "storage_free_percent",
                "storage_used",
                "storage_used_percent",
            ],
            "Timesync": ["action"],
            "Uptime": ["uptime"],
        },
        "Updates": {
            "BaseEvent": [
                "dest",
                "signature",
                "signature_id",
                "status",
                "vendor_product",
            ]
        },
        "Vulnerabilities": {
            "BaseEvent": [
                "category",
                "cve",
                "dest",
                "dvc",
                "severity",
                "signature",
                "vendor_product",
            ]
        },
        "Web": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "http_content_type",
                "http_method",
                "http_referrer",
                "http_referrer_domain",
                "http_user_agent",
                "src",
                "status",
                "url",
                "url_domain",
                "user",
                "vendor_product",
            ]
        },
    },
    "5.0.0": {
        "Alerts": {
            "BaseEvent": [
                "app",
                "dest",
                "severity",
                "signature_id",
                "src",
                "type",
                "user",
                "user_name",
            ]
        },
        "Application_State": {
            "BaseEvent": ["dest", "process"],
            "Ports": ["dest_port", "transport"],
            "Services": ["service", "service_id", "start_mode", "status"],
        },
        "Authentication": {
            "BaseEvent": ["action", "app", "src", "src_user", "dest", "user"]
        },
        "Certificates": {
            "SSL": [
                "ssl_end_time",
                "ssl_serial",
                "ssl_start_time",
                "ssl_hash",
                "ssl_issuer",
                "ssl_issuer_common_name",
                "ssl_issuer_email_domain",
                "ssl_subject",
                "ssl_subject_common_name",
                "ssl_subject_email_domain",
            ]
        },
        "Change": {
            "Account_Management": [
                "dest_nt_domain",
                "src_nt_domain",
                "src_user",
                "src_user_name",
            ],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "user_name",
                "vendor_product",
                "action",
            ],
            "Instance_Changes": ["image_id", "instance_type"],
        },
        "Change_Analysis": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Filesystem_Changes": [
                "file_access_time",
                "file_create_time",
                "file_hash",
                "file_modify_time",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
            ],
        },
        "Compute_Inventory": {
            "BaseEvent": ["dest", "vendor_product"],
            "CPU": ["cpu_cores", "cpu_count", "cpu_mhz"],
            "Memory": ["mem"],
            "Network": ["dns", "interface", "ip", "mac", "name"],
            "OS": ["os"],
            "Snapshot": ["size", "snapshot"],
            "Storage": ["mount", "storage"],
            "User": ["interactive", "password", "user"],
            "Virtual_OS": ["hypervisor"],
        },
        "DLP": {
            "BaseEvent": [
                "action",
                "category",
                "dvc",
                "dlp_type",
                "object",
                "object_path",
                "object_category",
                "signature",
                "severity",
                "src",
                "src_user",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Data_Access": {
            "BaseEvent": [
                "action",
                "app",
                "dest",
                "object",
                "object_category",
                "object_id",
                "object_size",
                "src",
                "vendor_account",
                "user",
                "vendor_product",
            ]
        },
        "Email": {
            "BaseEvent": [
                "action",
                "dest",
                "src",
                "recipient",
                "recipient_domain",
                "src_user",
                "src_user_domain",
                "vendor_product",
            ],
            "Filtering": ["signature"],
        },
        "Endpoint": {
            "Filesystem": [
                "file_access_time",
                "file_create_time",
                "file_modify_time",
                "action",
                "dest",
                "file_hash",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
                "user",
                "vendor_product",
            ],
            "Ports": [
                "dest_port",
                "transport",
                "src",
                "src_port",
                "dest",
                "user",
                "vendor_product",
            ],
            "Processes": [
                "dest",
                "original_file_name",
                "parent_process",
                "parent_process_name",
                "process",
                "process_name",
                "user",
                "vendor_product",
            ],
            "Registry": [
                "action",
                "dest",
                "registry_path",
                "registry_key_name",
                "registry_value_data",
                "registry_value_name",
                "registry_value_type",
                "user",
                "vendor_product",
            ],
            "Services": [
                "dest",
                "service",
                "service_name",
                "service_id",
                "start_mode",
                "status",
                "user",
                "vendor_product",
            ],
        },
        "Event_Signatures": {"BaseEvent": ["vendor_product"]},
        "Intrusion_Detection": {
            "BaseEvent": [
                "dvc",
                "ids_type",
                "category",
                "signature",
                "severity",
                "src",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Malware": {
            "BaseEvent": [
                "action",
                "category",
                "date",
                "dest",
                "dest_nt_domain",
                "severity",
                "signature",
                "user",
                "vendor_product",
            ],
            "Malware_Operations": [
                "product_version",
                "signature_version",
                "dest",
                "dest_nt_domain",
                "vendor_product",
            ],
        },
        "Network_Resolution": {
            "BaseEvent": [
                "answer",
                "dest",
                "message_type",
                "query",
                "reply_code_id",
                "reply_code",
                "vendor_product",
            ]
        },
        "Network_Sessions": {
            "BaseEvent": [
                "dest_ip",
                "dest_mac",
                "dest_nt_host",
                "dest_dns",
                "user",
                "vendor_product",
            ]
        },
        "Network_Traffic": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "dest_port",
                "dvc",
                "rule",
                "src",
                "src_port",
                "transport",
                "user",
                "vendor_product",
            ]
        },
        "Performance": {
            "BaseEvent": ["dest"],
            "CPU": ["cpu_load_percent"],
            "Facilities": ["temperature"],
            "Memory": ["mem", "mem_free", "mem_used"],
            "Network": ["thruput"],
            "OS": ["signature"],
            "Storage": [
                "storage_free",
                "storage_free_percent",
                "storage_used",
                "storage_used_percent",
            ],
            "Timesync": ["action"],
            "Uptime": ["uptime"],
        },
        "Updates": {
            "BaseEvent": [
                "dest",
                "signature",
                "signature_id",
                "status",
                "vendor_product",
            ]
        },
        "Vulnerabilities": {
            "BaseEvent": [
                "category",
                "cve",
                "dest",
                "dvc",
                "severity",
                "signature",
                "vendor_product",
            ]
        },
        "Web": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "http_content_type",
                "http_method",
                "http_referrer",
                "http_referrer_domain",
                "http_user_agent",
                "src",
                "status",
                "url",
                "url_domain",
                "user",
                "vendor_product",
            ]
        },
    },
    "5.3.1": {
        "Alerts": {
            "BaseEvent": [
                "app",
                "dest",
                "severity",
                "signature_id",
                "src",
                "type",
                "user",
            ]
        },
        "Application_State": {
            "BaseEvent": ["dest", "process"],
            "Ports": ["dest_port", "transport"],
            "Services": ["service", "service_id", "start_mode", "status"],
        },
        "Authentication": {
            "BaseEvent": ["action", "app", "src", "src_user", "dest", "user"]
        },
        "Certificates": {
            "SSL": [
                "ssl_end_time",
                "ssl_serial",
                "ssl_start_time",
                "ssl_hash",
                "ssl_issuer",
                "ssl_issuer_common_name",
                "ssl_issuer_email_domain",
                "ssl_subject",
                "ssl_subject_common_name",
                "ssl_subject_email_domain",
            ]
        },
        "Change": {
            "Account_Management": [
                "dest_nt_domain",
                "src_nt_domain",
                "src_user",
            ],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Instance_Changes": ["image_id", "instance_type"],
        },
        "Change_Analysis": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Filesystem_Changes": [
                "file_access_time",
                "file_create_time",
                "file_hash",
                "file_modify_time",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
            ],
        },
        "Compute_Inventory": {
            "BaseEvent": ["dest", "vendor_product"],
            "CPU": ["cpu_cores", "cpu_count", "cpu_mhz"],
            "Memory": ["mem"],
            "Network": ["dns", "interface", "ip", "mac", "name"],
            "OS": ["os"],
            "Snapshot": ["size", "snapshot"],
            "Storage": ["mount", "storage"],
            "User": ["interactive", "password", "user"],
            "Virtual_OS": ["hypervisor"],
        },
        "DLP": {
            "BaseEvent": [
                "action",
                "category",
                "dvc",
                "dlp_type",
                "object",
                "object_path",
                "object_category",
                "signature",
                "severity",
                "src",
                "src_user",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Data_Access": {
            "BaseEvent": [
                "action",
                "app",
                "dest",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_size",
                "src",
                "user_name",
                "vendor_account",
                "user",
                "vendor_product",
            ]
        },
        "Email": {
            "BaseEvent": [
                "action",
                "dest",
                "src",
                "recipient",
                "recipient_domain",
                "src_user",
                "src_user_domain",
                "vendor_product",
            ],
            "Filtering": ["signature"],
        },
        "Endpoint": {
            "Filesystem": [
                "file_access_time",
                "file_create_time",
                "file_modify_time",
                "action",
                "dest",
                "file_hash",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
                "user",
                "vendor_product",
            ],
            "Ports": [
                "dest_port",
                "transport",
                "src",
                "src_port",
                "dest",
                "user",
                "vendor_product",
            ],
            "Processes": [
                "dest",
                "loaded_file",
                "original_file_name",
                "parent_process",
                "parent_process_name",
                "process",
                "process_name",
                "user",
                "vendor_product",
            ],
            "Registry": [
                "action",
                "dest",
                "registry_path",
                "registry_key_name",
                "registry_value_data",
                "registry_value_name",
                "registry_value_type",
                "user",
                "vendor_product",
            ],
            "Services": [
                "dest",
                "service",
                "service_name",
                "service_id",
                "start_mode",
                "status",
                "user",
                "vendor_product",
            ],
        },
        "Event_Signatures": {"BaseEvent": ["vendor_product"]},
        "Intrusion_Detection": {
            "BaseEvent": [
                "dvc",
                "ids_type",
                "category",
                "signature",
                "severity",
                "src",
                "dest",
                "user",
                "vendor_product",
            ]
        },
        "Malware": {
            "BaseEvent": [
                "action",
                "category",
                "date",
                "dest",
                "dest_nt_domain",
                "severity",
                "signature",
                "user",
                "vendor_product",
            ],
            "Malware_Operations": [
                "product_version",
                "signature_version",
                "dest",
                "dest_nt_domain",
                "vendor_product",
            ],
        },
        "Network_Resolution": {
            "BaseEvent": [
                "answer",
                "dest",
                "message_type",
                "query",
                "reply_code_id",
                "reply_code",
                "vendor_product",
            ]
        },
        "Network_Sessions": {
            "BaseEvent": [
                "dest_ip",
                "dest_mac",
                "dest_nt_host",
                "dest_dns",
                "user",
                "vendor_product",
            ]
        },
        "Network_Traffic": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "dest_port",
                "dvc",
                "rule",
                "src",
                "src_port",
                "transport",
                "user",
                "vendor_product",
            ]
        },
        "Performance": {
            "BaseEvent": ["dest"],
            "CPU": ["cpu_load_percent"],
            "Facilities": ["temperature"],
            "Memory": ["mem", "mem_free", "mem_used"],
            "Network": ["thruput"],
            "OS": ["signature"],
            "Storage": [
                "storage_free",
                "storage_free_percent",
                "storage_used",
                "storage_used_percent",
            ],
            "Timesync": ["action"],
            "Uptime": ["uptime"],
        },
        "Updates": {
            "BaseEvent": [
                "dest",
                "signature",
                "signature_id",
                "status",
                "vendor_product",
            ]
        },
        "Vulnerabilities": {
            "BaseEvent": [
                "category",
                "cve",
                "dest",
                "dvc",
                "severity",
                "signature",
                "vendor_product",
            ]
        },
        "Web": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "http_content_type",
                "http_method",
                "http_referrer",
                "http_referrer_domain",
                "http_user_agent",
                "src",
                "status",
                "url",
                "url_domain",
                "user",
                "vendor_product",
            ]
        },
    },
    "5.3.2": {
        "Alerts": {
            "BaseEvent": [
                "app",
                "dest",
                "severity",
                "signature",
                "signature_id",
                "src",
                "type",
                "user",
                "description",
                "id",
            ]
        },
        "Application_State": {
            "BaseEvent": ["dest", "process"],
            "Ports": ["dest_port", "transport"],
            "Services": ["service", "service_id", "start_mode", "status"],
        },
        "Authentication": {
            "BaseEvent": ["action", "app", "src", "dest", "user"],
            "Privileged_Authentication": ["src_user"],
        },
        "Certificates": {
            "SSL": [
                "ssl_end_time",
                "ssl_serial",
                "ssl_start_time",
                "ssl_hash",
                "ssl_issuer",
                "ssl_issuer_common_name",
                "ssl_subject",
                "ssl_subject_common_name",
                "ssl_subject_organization",
                "ssl_validity_window",
            ]
        },
        "Change": {
            "Account_Management": [
                "src_user",
                "object_category",
            ],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_id",
                "status",
                "result",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Instance_Changes": ["image_id", "instance_type"],
        },
        "Change_Analysis": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Filesystem_Changes": [
                "file_access_time",
                "file_create_time",
                "file_hash",
                "file_modify_time",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
            ],
        },
        "Compute_Inventory": {
            "BaseEvent": ["dest", "vendor_product"],
            "CPU": ["cpu_cores", "cpu_count", "cpu_mhz"],
            "Memory": ["mem"],
            "Network": ["dns", "interface", "ip", "mac", "name"],
            "OS": ["os"],
            "Snapshot": ["size", "snapshot"],
            "Storage": ["mount", "storage"],
            "User": ["interactive", "password", "user"],
            "Virtual_OS": ["hypervisor"],
        },
        "DLP": {
            "BaseEvent": [
                "action",
                "category",
                "dvc",
                "dlp_type",
                "object",
                "object_path",
                "object_category",
                "signature",
                "severity",
                "src",
                "src_user",
                "dest",
                "user",
                "vendor_product",
                "app",
            ]
        },
        "Data_Access": {
            "BaseEvent": [
                "action",
                "app",
                "dest",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_size",
                "src",
                "user_name",
                "vendor_account",
                "user",
                "vendor_product",
            ]
        },
        "Email": {
            "BaseEvent": [
                "action",
                "dest",
                "src",
                "recipient",
                "recipient_domain",
                "src_user",
                "src_user_domain",
                "vendor_product",
                "internal_message_id",
                "message_id",
                "protocol",
                "return_addr",
            ],
            "Filtering": ["signature"],
        },
        "Endpoint": {
            "Filesystem": [
                "file_create_time",
                "file_modify_time",
                "action",
                "dest",
                "file_hash",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
                "user",
                "vendor_product",
            ],
            "Ports": [
                "dest_port",
                "transport",
                "src",
                "src_port",
                "transport_dest_port",
                "dest",
                "vendor_product",
                "state",
            ],
            "Processes": [
                "action",
                "dest",
                "parent_process",
                "parent_process_name",
                "process",
                "process_name",
                "process_id",
                "process_path",
                "parent_process_id",
                "parent_process_path",
                "user",
                "vendor_product",
            ],
            "Registry": [
                "action",
                "dest",
                "registry_path",
                "registry_key_name",
                "registry_value_data",
                "registry_value_name",
                "registry_value_type",
                "user",
                "vendor_product",
                "status",
                "registry_hive",
                "registry_value_text",
            ],
            "Services": [
                "dest",
                "service",
                "service_name",
                "service_path",
                "service_id",
                "start_mode",
                "status",
                "user",
                "vendor_product",
            ],
        },
        "Event_Signatures": {"BaseEvent": ["dest", "signature", "signature_id"]},
        "Intrusion_Detection": {
            "BaseEvent": [
                "dvc",
                "ids_type",
                "category",
                "signature",
                "severity",
                "src",
                "dest",
                "vendor_product",
                "action",
            ]
        },
        "Malware": {
            "BaseEvent": [
                "action",
                "category",
                "dest",
                "severity",
                "signature",
                "file_name",
                "file_path",
                "vendor_product",
            ],
            "Malware_Operations": [
                "signature_version",
                "dest",
                "vendor_product",
            ],
        },
        "Network_Resolution": {
            "BaseEvent": [
                "answer",
                "dest",
                "message_type",
                "query",
                "reply_code_id",
                "reply_code",
                "vendor_product",
                "src",
                "transport",
                "answer_count",
                "query_count",
                "query_type",
                "record_type",
                "response_time",
                "transaction_id",
            ]
        },
        "Network_Sessions": {
            "BaseEvent": [
                "dest_ip",
                "dest_mac",
                "vendor_product",
                "action",
                "signature",
            ],
            "DHCP": ["lease_duration"],
            "VPN": ["user"],
        },
        "Network_Traffic": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "dest_port",
                "dvc",
                "src",
                "src_port",
                "transport",
                "vendor_product",
                "app",
                "packets",
                "packets_in",
                "packets_out",
                "protocol",
            ]
        },
        "Performance": {
            "BaseEvent": ["dest"],
            "CPU": ["cpu_load_percent"],
            "Facilities": ["temperature"],
            "Memory": ["mem", "mem_free", "mem_used"],
            "Network": ["thruput"],
            "OS": ["signature"],
            "Storage": [
                "storage_free",
                "storage_free_percent",
                "storage_used",
                "storage_used_percent",
            ],
            "Timesync": ["action"],
            "Uptime": ["uptime"],
        },
        "Ticket_Management": {
            "BaseEvent": [
                "priority",
                "severity",
                "severity_id",
                "status",
                "dest",
                "ticket_id",
            ]
        },
        "Updates": {
            "BaseEvent": [
                "dest",
                "signature",
                "signature_id",
                "status",
                "vendor_product",
                "dvc",
                "file_name",
            ]
        },
        "Vulnerabilities": {
            "BaseEvent": [
                "category",
                "cve",
                "dest",
                "dvc",
                "severity",
                "signature",
                "vendor_product",
                "cvss",
            ]
        },
        "Web": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "http_method",
                "http_user_agent",
                "src",
                "status",
                "url",
                "url_domain",
                "user",
                "vendor_product",
                "category",
                "dest_port",
                "http_user_agent_length",
            ]
        },
    },
    "6.0.0": {
        "Alerts": {
            "BaseEvent": [
                "app",
                "dest",
                "severity",
                "signature",
                "signature_id",
                "src",
                "type",
                "user",
                "description",
                "id",
            ]
        },
        "Application_State": {
            "BaseEvent": ["dest", "process"],
            "Ports": ["dest_port", "transport"],
            "Services": ["service", "service_id", "start_mode", "status"],
        },
        "Authentication": {
            "BaseEvent": ["action", "app", "src", "dest", "user"],
            "Privileged_Authentication": ["src_user"],
        },
        "Certificates": {
            "SSL": [
                "ssl_end_time",
                "ssl_serial",
                "ssl_start_time",
                "ssl_hash",
                "ssl_issuer",
                "ssl_issuer_common_name",
                "ssl_subject",
                "ssl_subject_common_name",
                "ssl_subject_organization",
                "ssl_validity_window",
            ]
        },
        "Change": {
            "Account_Management": [
                "src_user",
                "object_category",
            ],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_id",
                "status",
                "result",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Instance_Changes": ["image_id", "instance_type"],
        },
        "Change_Analysis": {
            "Account_Management": ["dest_nt_domain", "src_nt_domain", "src_user"],
            "BaseEvent": [
                "change_type",
                "command",
                "dest",
                "dvc",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_path",
                "status",
                "result",
                "result_id",
                "src",
                "user",
                "vendor_product",
                "action",
            ],
            "Filesystem_Changes": [
                "file_access_time",
                "file_create_time",
                "file_hash",
                "file_modify_time",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
            ],
        },
        "Compute_Inventory": {
            "BaseEvent": ["dest", "vendor_product"],
            "CPU": ["cpu_cores", "cpu_count", "cpu_mhz"],
            "Memory": ["mem"],
            "Network": ["dns", "interface", "ip", "mac", "name"],
            "OS": ["os"],
            "Snapshot": ["size", "snapshot"],
            "Storage": ["mount", "storage"],
            "User": ["interactive", "password", "user"],
            "Virtual_OS": ["hypervisor"],
        },
        "DLP": {
            "BaseEvent": [
                "action",
                "category",
                "dvc",
                "dlp_type",
                "object",
                "object_path",
                "object_category",
                "signature",
                "severity",
                "src",
                "src_user",
                "dest",
                "user",
                "vendor_product",
                "app",
            ]
        },
        "Data_Access": {
            "BaseEvent": [
                "action",
                "app",
                "dest",
                "object",
                "object_attrs",
                "object_category",
                "object_id",
                "object_size",
                "src",
                "user_name",
                "vendor_account",
                "user",
                "vendor_product",
            ]
        },
        "Email": {
            "BaseEvent": [
                "action",
                "dest",
                "src",
                "recipient",
                "recipient_domain",
                "src_user",
                "src_user_domain",
                "vendor_product",
                "internal_message_id",
                "message_id",
                "protocol",
                "return_addr",
            ],
            "Filtering": ["signature"],
        },
        "Endpoint": {
            "Filesystem": [
                "file_create_time",
                "file_modify_time",
                "action",
                "dest",
                "file_hash",
                "file_name",
                "file_path",
                "file_acl",
                "file_size",
                "user",
                "vendor_product",
            ],
            "Ports": [
                "dest_port",
                "transport",
                "src",
                "src_port",
                "transport_dest_port",
                "dest",
                "vendor_product",
                "state",
            ],
            "Processes": [
                "action",
                "dest",
                "parent_process",
                "parent_process_name",
                "process",
                "process_name",
                "process_id",
                "process_path",
                "parent_process_id",
                "parent_process_path",
                "user",
                "vendor_product",
            ],
            "Registry": [
                "action",
                "dest",
                "registry_path",
                "registry_key_name",
                "registry_value_data",
                "registry_value_name",
                "registry_value_type",
                "user",
                "vendor_product",
                "status",
                "registry_hive",
                "registry_value_text",
            ],
            "Services": [
                "dest",
                "service",
                "service_name",
                "service_path",
                "service_id",
                "start_mode",
                "status",
                "user",
                "vendor_product",
            ],
        },
        "Event_Signatures": {"BaseEvent": ["dest", "signature", "signature_id"]},
        "Intrusion_Detection": {
            "BaseEvent": [
                "dvc",
                "ids_type",
                "category",
                "signature",
                "severity",
                "src",
                "dest",
                "vendor_product",
                "action",
            ]
        },
        "Malware": {
            "BaseEvent": [
                "action",
                "category",
                "dest",
                "severity",
                "signature",
                "file_name",
                "file_path",
                "vendor_product",
            ],
            "Malware_Operations": [
                "signature_version",
                "dest",
                "vendor_product",
            ],
        },
        "Network_Resolution": {
            "BaseEvent": [
                "answer",
                "dest",
                "message_type",
                "query",
                "reply_code_id",
                "reply_code",
                "vendor_product",
                "src",
                "transport",
                "answer_count",
                "query_count",
                "query_type",
                "record_type",
                "response_time",
                "transaction_id",
            ]
        },
        "Network_Sessions": {
            "BaseEvent": [
                "dest_ip",
                "dest_mac",
                "vendor_product",
                "action",
                "signature",
            ],
            "DHCP": ["lease_duration"],
            "VPN": ["user"],
        },
        "Network_Traffic": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "dest_port",
                "dvc",
                "src",
                "src_port",
                "transport",
                "vendor_product",
                "app",
                "packets",
                "packets_in",
                "packets_out",
                "protocol",
            ]
        },
        "Performance": {
            "BaseEvent": ["dest"],
            "CPU": ["cpu_load_percent"],
            "Facilities": ["temperature"],
            "Memory": ["mem", "mem_free", "mem_used"],
            "Network": ["thruput"],
            "OS": ["signature"],
            "Storage": [
                "storage_free",
                "storage_free_percent",
                "storage_used",
                "storage_used_percent",
            ],
            "Timesync": ["action"],
            "Uptime": ["uptime"],
        },
        "Ticket_Management": {
            "BaseEvent": [
                "priority",
                "severity",
                "severity_id",
                "status",
                "dest",
                "ticket_id",
            ]
        },
        "Updates": {
            "BaseEvent": [
                "dest",
                "signature",
                "signature_id",
                "status",
                "vendor_product",
                "dvc",
                "file_name",
            ]
        },
        "Vulnerabilities": {
            "BaseEvent": [
                "category",
                "cve",
                "dest",
                "dvc",
                "severity",
                "signature",
                "vendor_product",
                "cvss",
            ]
        },
        "Web": {
            "BaseEvent": [
                "action",
                "bytes",
                "bytes_in",
                "bytes_out",
                "dest",
                "http_method",
                "http_user_agent",
                "src",
                "status",
                "url",
                "url_domain",
                "user",
                "vendor_product",
                "category",
                "dest_port",
                "http_user_agent_length",
            ]
        },
    },
}
# No recommended/required fields changes between v6.0.0 and v6.2.0
datamodels["6.0.1"] = datamodels["6.0.0"]
datamodels["6.0.2"] = datamodels["6.0.0"]
datamodels["6.1.0"] = datamodels["6.0.2"]
datamodels["6.2.0"] = datamodels["6.1.0"]
datamodels["latest"] = datamodels["6.2.0"]
