# ROADMAP

This is the 1-year roadmap for the project.

## Release schedule
A new release of the project is expected every 3 months.  The release cycle,
upcoming tasks, and any stated goals are subject to change.  The antipicated
release dates are as follows:

**January** 2018 ([0.10.2](https://github.com/theupdateframework/tuf/releases/tag/v0.10.2) released Jan. 31)

**April** 2018 ([0.11.0](https://github.com/theupdateframework/tuf/releases/tag/v0.11.0) released Apr. 30)

**July** 2018 ([0.11.1](https://github.com/theupdateframework/tuf/releases/tag/v0.11.1) released Jun. 19)

**October** 2018


## Latest release
Pre-release v0.11.1 shipped on June 19, 2018.
* [Release notes and Download](https://github.com/theupdateframework/tuf/releases/tag/v0.11.1)
* [PyPI release](https://pypi.org/project/tuf/)
* Packaged by Vladimir Diaz <vladimir.v.diaz@gmail.com, @vladimir-v-diaz>
* PGP fingerprint: 3E87 BB33 9378 BC7B 3DD0  E5B2 5DEE 9B97 B0E2 289A


## Tasks for upcoming releases

In no particular order...

- [x] [CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/1351) badge.
  - [x] silver badge
  - [ ] gold badge (currently at 74%)

- [ ] Support graph of delegations (requires refactor of API and client code).

- [ ] [TAP 3: Multi-role delegations](https://github.com/theupdateframework/taps/blob/master/tap3.md).

- [x] [TAP 4: Multiple repository consensus on entrusted targets](https://github.com/theupdateframework/taps/blob/master/tap4.md).

- [ ] [TAP 5: Setting URLs for roles in the Root metadata file](https://github.com/theupdateframework/taps/blob/master/tap5.md).

- [ ] [TAP 8: Key rotation and explicit self-revocation](https://github.com/theupdateframework/taps/blob/master/tap8.md).

- [x] CLI tool and quickstart guide.

- [x] Improve update speed.

- [x] Fully support Windows.

- [ ] Generalize metadata format in specification.

- [ ] Support post quantum resilient crypto.

- [ ] Resolve TODOs in the code.

- [ ] Support Python's multilingual internationalization and localization
services.

- [ ] 100% code coverage.

- [ ] Continue resolution of outstanding tickets on the issue tracker.

- [ ] Generalize encrypted key files.  Allow different forms of encryption, key derivation functions, etc.

- [ ] Speed up loading and saving of metadata.  Support option to save metadata to memory.

