# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class IntegrationEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        IntegrationEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'self_uri': 'str',
            'correlation_id': 'str',
            'timestamp': 'datetime',
            'level': 'str',
            'event_code': 'str',
            'message': 'MessageInfo',
            'entities': 'list[EventEntity]',
            'context_attributes': 'dict(str, str)',
            'detail_message': 'MessageInfo',
            'user': 'User'
        }

        self.attribute_map = {
            'id': 'id',
            'self_uri': 'selfUri',
            'correlation_id': 'correlationId',
            'timestamp': 'timestamp',
            'level': 'level',
            'event_code': 'eventCode',
            'message': 'message',
            'entities': 'entities',
            'context_attributes': 'contextAttributes',
            'detail_message': 'detailMessage',
            'user': 'user'
        }

        self._id = None
        self._self_uri = None
        self._correlation_id = None
        self._timestamp = None
        self._level = None
        self._event_code = None
        self._message = None
        self._entities = None
        self._context_attributes = None
        self._detail_message = None
        self._user = None

    @property
    def id(self):
        """
        Gets the id of this IntegrationEvent.
        Unique ID for this event

        :return: The id of this IntegrationEvent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IntegrationEvent.
        Unique ID for this event

        :param id: The id of this IntegrationEvent.
        :type: str
        """
        
        self._id = id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this IntegrationEvent.
        The URI for this object

        :return: The self_uri of this IntegrationEvent.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this IntegrationEvent.
        The URI for this object

        :param self_uri: The self_uri of this IntegrationEvent.
        :type: str
        """
        
        self._self_uri = self_uri

    @property
    def correlation_id(self):
        """
        Gets the correlation_id of this IntegrationEvent.
        Correlation ID for the event

        :return: The correlation_id of this IntegrationEvent.
        :rtype: str
        """
        return self._correlation_id

    @correlation_id.setter
    def correlation_id(self, correlation_id):
        """
        Sets the correlation_id of this IntegrationEvent.
        Correlation ID for the event

        :param correlation_id: The correlation_id of this IntegrationEvent.
        :type: str
        """
        
        self._correlation_id = correlation_id

    @property
    def timestamp(self):
        """
        Gets the timestamp of this IntegrationEvent.
        Time the event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The timestamp of this IntegrationEvent.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this IntegrationEvent.
        Time the event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param timestamp: The timestamp of this IntegrationEvent.
        :type: datetime
        """
        
        self._timestamp = timestamp

    @property
    def level(self):
        """
        Gets the level of this IntegrationEvent.
        Indicates the severity of the event.

        :return: The level of this IntegrationEvent.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this IntegrationEvent.
        Indicates the severity of the event.

        :param level: The level of this IntegrationEvent.
        :type: str
        """
        allowed_values = ["INFO", "WARN", "ERROR", "CRITICAL"]
        if level.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for level -> " + level
            self._level = "outdated_sdk_version"
        else:
            self._level = level

    @property
    def event_code(self):
        """
        Gets the event_code of this IntegrationEvent.
        A classification for the event. Suitable for programmatic searching, sorting, or filtering

        :return: The event_code of this IntegrationEvent.
        :rtype: str
        """
        return self._event_code

    @event_code.setter
    def event_code(self, event_code):
        """
        Sets the event_code of this IntegrationEvent.
        A classification for the event. Suitable for programmatic searching, sorting, or filtering

        :param event_code: The event_code of this IntegrationEvent.
        :type: str
        """
        
        self._event_code = event_code

    @property
    def message(self):
        """
        Gets the message of this IntegrationEvent.
        Message indicating what happened

        :return: The message of this IntegrationEvent.
        :rtype: MessageInfo
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this IntegrationEvent.
        Message indicating what happened

        :param message: The message of this IntegrationEvent.
        :type: MessageInfo
        """
        
        self._message = message

    @property
    def entities(self):
        """
        Gets the entities of this IntegrationEvent.
        Collection of entities affected by or pertaining to the event (e.g. a list of Integrations or Bridge connectors)

        :return: The entities of this IntegrationEvent.
        :rtype: list[EventEntity]
        """
        return self._entities

    @entities.setter
    def entities(self, entities):
        """
        Sets the entities of this IntegrationEvent.
        Collection of entities affected by or pertaining to the event (e.g. a list of Integrations or Bridge connectors)

        :param entities: The entities of this IntegrationEvent.
        :type: list[EventEntity]
        """
        
        self._entities = entities

    @property
    def context_attributes(self):
        """
        Gets the context_attributes of this IntegrationEvent.
        Map of context attributes specific to this event.

        :return: The context_attributes of this IntegrationEvent.
        :rtype: dict(str, str)
        """
        return self._context_attributes

    @context_attributes.setter
    def context_attributes(self, context_attributes):
        """
        Sets the context_attributes of this IntegrationEvent.
        Map of context attributes specific to this event.

        :param context_attributes: The context_attributes of this IntegrationEvent.
        :type: dict(str, str)
        """
        
        self._context_attributes = context_attributes

    @property
    def detail_message(self):
        """
        Gets the detail_message of this IntegrationEvent.
        Message with additional details about the event. (e.g. an exception cause.)

        :return: The detail_message of this IntegrationEvent.
        :rtype: MessageInfo
        """
        return self._detail_message

    @detail_message.setter
    def detail_message(self, detail_message):
        """
        Sets the detail_message of this IntegrationEvent.
        Message with additional details about the event. (e.g. an exception cause.)

        :param detail_message: The detail_message of this IntegrationEvent.
        :type: MessageInfo
        """
        
        self._detail_message = detail_message

    @property
    def user(self):
        """
        Gets the user of this IntegrationEvent.
        User that took an action that resulted in the event.

        :return: The user of this IntegrationEvent.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this IntegrationEvent.
        User that took an action that resulted in the event.

        :param user: The user of this IntegrationEvent.
        :type: User
        """
        
        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

