"""
    IoT Reports API

    IoT Reports API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: joe.savage@silabs.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from iotreports_client.api_client import ApiClient, Endpoint as _Endpoint
from iotreports_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from iotreports_client.model.category import Category
from iotreports_client.model.inline_response2004 import InlineResponse2004
from iotreports_client.model.report_type import ReportType


class CategoryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_category(
            self,
            organization_id,
            **kwargs
        ):
            """creates a report category for an organization  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_category(organization_id, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str): id of organization

            Keyword Args:
                category (Category): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Category
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            return self.call_with_http_info(**kwargs)

        self.create_category = _Endpoint(
            settings={
                'response_type': (Category,),
                'auth': [
                    'bearerAuthJWT',
                    'bearerAuthToken'
                ],
                'endpoint_path': '/{organizationId}/categories',
                'operation_id': 'create_category',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'category',
                ],
                'required': [
                    'organization_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'category':
                        (Category,),
                },
                'attribute_map': {
                    'organization_id': 'organizationId',
                },
                'location_map': {
                    'organization_id': 'path',
                    'category': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_category
        )

        def __delete_category(
            self,
            organization_id,
            category_id,
            **kwargs
        ):
            """deletes a report category  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_category(organization_id, category_id, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str): id of organization
                category_id (str): id of category

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            kwargs['category_id'] = \
                category_id
            return self.call_with_http_info(**kwargs)

        self.delete_category = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'bearerAuthJWT',
                    'bearerAuthToken'
                ],
                'endpoint_path': '/{organizationId}/categories/{categoryId}',
                'operation_id': 'delete_category',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'category_id',
                ],
                'required': [
                    'organization_id',
                    'category_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'category_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organizationId',
                    'category_id': 'categoryId',
                },
                'location_map': {
                    'organization_id': 'path',
                    'category_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_category
        )

        def __get_categories(
            self,
            organization_id,
            **kwargs
        ):
            """gets the report categories for an organization  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_categories(organization_id, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str): id of organization

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse2004
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            return self.call_with_http_info(**kwargs)

        self.get_categories = _Endpoint(
            settings={
                'response_type': (InlineResponse2004,),
                'auth': [],
                'endpoint_path': '/{organizationId}/categories',
                'operation_id': 'get_categories',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                ],
                'required': [
                    'organization_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organizationId',
                },
                'location_map': {
                    'organization_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_categories
        )

        def __get_category(
            self,
            organization_id,
            category_id,
            **kwargs
        ):
            """gets a report category  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_category(organization_id, category_id, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str): id of organization
                category_id (str): id of category

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Category
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            kwargs['category_id'] = \
                category_id
            return self.call_with_http_info(**kwargs)

        self.get_category = _Endpoint(
            settings={
                'response_type': (Category,),
                'auth': [],
                'endpoint_path': '/{organizationId}/categories/{categoryId}',
                'operation_id': 'get_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'category_id',
                ],
                'required': [
                    'organization_id',
                    'category_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'category_id':
                        (str,),
                },
                'attribute_map': {
                    'organization_id': 'organizationId',
                    'category_id': 'categoryId',
                },
                'location_map': {
                    'organization_id': 'path',
                    'category_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_category
        )

        def __update_category(
            self,
            organization_id,
            category_id,
            **kwargs
        ):
            """updates a report category  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_category(organization_id, category_id, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str): id of organization
                category_id (str): id of category

            Keyword Args:
                category (Category): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Category
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            kwargs['category_id'] = \
                category_id
            return self.call_with_http_info(**kwargs)

        self.update_category = _Endpoint(
            settings={
                'response_type': (Category,),
                'auth': [],
                'endpoint_path': '/{organizationId}/categories/{categoryId}',
                'operation_id': 'update_category',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'category_id',
                    'category',
                ],
                'required': [
                    'organization_id',
                    'category_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'category_id':
                        (str,),
                    'category':
                        (Category,),
                },
                'attribute_map': {
                    'organization_id': 'organizationId',
                    'category_id': 'categoryId',
                },
                'location_map': {
                    'organization_id': 'path',
                    'category_id': 'path',
                    'category': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_category
        )

        def __update_report_type(
            self,
            organization_id,
            report_type_id,
            **kwargs
        ):
            """updates a report type  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_report_type(organization_id, report_type_id, async_req=True)
            >>> result = thread.get()

            Args:
                organization_id (str): id of organization
                report_type_id (str): id of reportType

            Keyword Args:
                report_type (ReportType): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ReportType
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['organization_id'] = \
                organization_id
            kwargs['report_type_id'] = \
                report_type_id
            return self.call_with_http_info(**kwargs)

        self.update_report_type = _Endpoint(
            settings={
                'response_type': (ReportType,),
                'auth': [
                    'bearerAuthJWT',
                    'bearerAuthToken'
                ],
                'endpoint_path': '/{organizationId}/reportTypes/{reportTypeId}',
                'operation_id': 'update_report_type',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'organization_id',
                    'report_type_id',
                    'report_type',
                ],
                'required': [
                    'organization_id',
                    'report_type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'organization_id':
                        (str,),
                    'report_type_id':
                        (str,),
                    'report_type':
                        (ReportType,),
                },
                'attribute_map': {
                    'organization_id': 'organizationId',
                    'report_type_id': 'reportTypeId',
                },
                'location_map': {
                    'organization_id': 'path',
                    'report_type_id': 'path',
                    'report_type': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_report_type
        )
