# iotreports-client
IoT Reports API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import iotreports_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import iotreports_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import iotreports_client
from pprint import pprint
from iotreports_client.api import category_api
from iotreports_client.model.category import Category
from iotreports_client.model.inline_response2004 import InlineResponse2004
from iotreports_client.model.report_type import ReportType
# Defining the host is optional and defaults to https://iot-reports.silabs.com/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = iotreports_client.Configuration(
    host = "https://iot-reports.silabs.com/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuthJWT
configuration = iotreports_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Configure Bearer authorization (Bearer): bearerAuthToken
configuration = iotreports_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with iotreports_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = category_api.CategoryApi(api_client)
    organization_id = "organizationId_example" # str | id of organization
category = Category(
        id="id_example",
        name="name_example",
        icon="icon_example",
        parent_id="parent_id_example",
        organization_id="organization_id_example",
    ) # Category |  (optional)

    try:
        # creates a report category for an organization
        api_response = api_instance.create_category(organization_id, category=category)
        pprint(api_response)
    except iotreports_client.ApiException as e:
        print("Exception when calling CategoryApi->create_category: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://iot-reports.silabs.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CategoryApi* | [**create_category**](docs/CategoryApi.md#create_category) | **POST** /{organizationId}/categories | creates a report category for an organization
*CategoryApi* | [**delete_category**](docs/CategoryApi.md#delete_category) | **DELETE** /{organizationId}/categories/{categoryId} | deletes a report category
*CategoryApi* | [**get_categories**](docs/CategoryApi.md#get_categories) | **GET** /{organizationId}/categories | gets the report categories for an organization
*CategoryApi* | [**get_category**](docs/CategoryApi.md#get_category) | **GET** /{organizationId}/categories/{categoryId} | gets a report category
*CategoryApi* | [**update_category**](docs/CategoryApi.md#update_category) | **PUT** /{organizationId}/categories/{categoryId} | updates a report category
*CategoryApi* | [**update_report_type**](docs/CategoryApi.md#update_report_type) | **PUT** /{organizationId}/reportTypes/{reportTypeId} | updates a report type
*OrganizationApi* | [**get_organization**](docs/OrganizationApi.md#get_organization) | **GET** /organizations/{organizationId} | gets an organization and optionally other items by organization id
*OrganizationApi* | [**get_organizations**](docs/OrganizationApi.md#get_organizations) | **GET** /organizations | gets list of organizations
*PermissionsApi* | [**create_permissions**](docs/PermissionsApi.md#create_permissions) | **POST** /{organizationId}/permissions | creates permissions for an organization
*PermissionsApi* | [**get_permissions**](docs/PermissionsApi.md#get_permissions) | **GET** /{organizationId}/permissions | gets the permissions for an organization
*PermissionsApi* | [**get_permissions_for_user**](docs/PermissionsApi.md#get_permissions_for_user) | **GET** /user/permissions/{organizationId} | gets the permissions level for a user for an organization
*ReportApi* | [**create_report**](docs/ReportApi.md#create_report) | **POST** /{organizationId}/reports | creates a report for an organization
*ReportApi* | [**delete_report**](docs/ReportApi.md#delete_report) | **DELETE** /{organizationId}/reports/{reportId} | deletes a report
*ReportApi* | [**get_report**](docs/ReportApi.md#get_report) | **GET** /{organizationId}/reports/{reportId} | gets a report
*ReportApi* | [**get_report_and_type**](docs/ReportApi.md#get_report_and_type) | **GET** /{organizationId}/reportAndType/{reportId} | gets a report and the corresponding reportType
*ReportApi* | [**get_reports**](docs/ReportApi.md#get_reports) | **GET** /{organizationId}/reports | gets the reports for an organization
*ReportApi* | [**get_reports_and_categories**](docs/ReportApi.md#get_reports_and_categories) | **GET** /{organizationId}/reportsAndCategories | gets all reports and categories for the specified organization
*ReportApi* | [**update_report**](docs/ReportApi.md#update_report) | **PUT** /{organizationId}/reports/{reportId} | updates a report
*ReportApi* | [**update_report_stream**](docs/ReportApi.md#update_report_stream) | **POST** /{organizationId}/reports/{reportId}/stream | updates a report stream
*ReportTypeApi* | [**create_report_type**](docs/ReportTypeApi.md#create_report_type) | **POST** /{organizationId}/reportTypes | creates a report type for an organization
*ReportTypeApi* | [**delete_report_type**](docs/ReportTypeApi.md#delete_report_type) | **DELETE** /{organizationId}/reportTypes/{reportTypeId} | deletes a report type
*ReportTypeApi* | [**get_report_type**](docs/ReportTypeApi.md#get_report_type) | **GET** /{organizationId}/reportTypes/{reportTypeId} | gets a report type
*ReportTypeApi* | [**get_report_type_type_data**](docs/ReportTypeApi.md#get_report_type_type_data) | **GET** /{organizationId}/reportTypes/{reportTypeId}/typeData | gets a report type&#39;s typeData
*ReportTypeApi* | [**get_report_types**](docs/ReportTypeApi.md#get_report_types) | **GET** /{organizationId}/reportTypes | gets the report types for an organization
*ReportTypeApi* | [**validate_report_schema**](docs/ReportTypeApi.md#validate_report_schema) | **POST** /{organizationId}/reportTypes/{reportTypeId}/validateReportSchema | 
*UserApi* | [**create_user_token**](docs/UserApi.md#create_user_token) | **POST** /user/tokens/{tokenName} | creates API token with specified name for a user
*UserApi* | [**delete_user_token**](docs/UserApi.md#delete_user_token) | **DELETE** /user/tokens/{tokenId} | deletes a user API token
*UserApi* | [**get_user**](docs/UserApi.md#get_user) | **GET** /user | gets user info corresponding to JWT token
*UserApi* | [**get_user_tokens**](docs/UserApi.md#get_user_tokens) | **GET** /user/tokens | gets API tokens for a user
*UserApi* | [**login_user**](docs/UserApi.md#login_user) | **POST** /auth | user login


## Documentation For Models

 - [ApiToken](docs/ApiToken.md)
 - [Category](docs/Category.md)
 - [Credentials](docs/Credentials.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [Organization](docs/Organization.md)
 - [Permissions](docs/Permissions.md)
 - [PermissionsResponse](docs/PermissionsResponse.md)
 - [Report](docs/Report.md)
 - [ReportStreamPayload](docs/ReportStreamPayload.md)
 - [ReportType](docs/ReportType.md)


## Documentation For Authorization


## bearerAuthJWT

- **Type**: Bearer authentication (JWT)


## bearerAuthToken

- **Type**: Bearer authentication (Bearer)


## Author

joe.savage@silabs.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in iotreports_client.apis and iotreports_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from iotreports_client.api.default_api import DefaultApi`
- `from iotreports_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import iotreports_client
from iotreports_client.apis import *
from iotreports_client.models import *
```

