# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/05_calib.ipynb (unless otherwise specified).

__all__ = ['steffl_spica_dates', 'get_star_obs', 'get_spica_obs', 'filter_spica_for_date']

# Cell
steffl_spica_dates = ["2001-04-3", "2002-07-17", "2003-05-19" ]

# Cell
from planetarypy.utils import nasa_datetime_to_iso
from .io import EUV_PDS, FUV_PDS

# Cell
def get_star_obs():
    "Read Greg's file into dataframe and add some meta-columns."
    star_list = Path("/home/maye/Dropbox/Documents/projects/uvis_pdart/calib/stars_list.txt")
    star_obs = pd.read_table(star_list, sep='\s\s+', index_col=False, engine='python')  # engine kw to avoid warning

    star_obs["DET"] = star_obs.filename.str[:3]
    star_obs["DATETIME"] = star_obs.filename.map(
        lambda x: nasa_datetime_to_iso(
            x[3:20].replace("_", "-", 1).replace("_", "T", 1).replace("_", ":")
        )
    )
    star_obs.DATETIME = pd.to_datetime(star_obs.DATETIME)
    star_obs['DATE'] = pd.DatetimeIndex(star_obs.DATETIME.dt.date)
    return star_obs

def get_spica_obs():
    "Filter Greg's list for Spica (alp vir) obs."
    return get_star_obs().query("name=='alp vir'")

def filter_spica_for_date(datestr):
    return get_spica_obs().query("DATE==@datestr")