# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/04_archive.ipynb (unless otherwise specified).

__all__ = ['archive', 'get_archive_file']

# Cell
import xarray as xr
from pathlib import Path
from .io import FUV_CDF, EUV_CDF
archive = Path("~/uvis_archive/observations/").expanduser()

# Cell
def get_archive_file(filename, xarray_only=False):
    path = archive / filename
    if xarray_only:
        return xr.open_dataset(path)
    if Path(filename).name.startswith("EUV"):
        Thisclass = EUV_CDF
    elif Path(filename).name.startswith("FUV"):
        Thisclass = FUV_CDF
    else:
        raise ValueError("Not a EUV/FUV file?")
    return Thisclass(path)