import setuptools
from version import VERSION

with open("README.md", "r") as fh:
    long_description = fh.read()
    print(long_description)

setuptools.setup(
    name="eeg_filters", # Replace with your own username
    version=VERSION,
    author="Yaric Pisarev",
    author_email="yaricp@gmail.com",
    description="Package for filtering EEG signals and EP (evoked potentials).",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yaricp/eeg-filters",
    packages=setuptools.find_packages(),
    install_requires=[
        'numpy>=1.18',
        'scipy>=1.4',
        'matplotlib>=3.1'
    ],
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
)
