# Generated by Django 2.2.2 on 2020-05-21 12:46

from django.db import migrations, models


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ('apiqa_storage', '0004_attachment_tags'),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.AddIndex(
                    model_name='attachment',
                    index=models.Index(fields=['object_id'],
                                       name='attachment_object_id_uuid_idx'),
                ),
                migrations.AddIndex(
                    model_name='attachment',
                    index=models.Index(fields=['object_id'],
                                       name='attachment_object_id_int_idx'),
                ),
            ],
            database_operations=[
                ## Add 2 indexes because object_id can have UUID type or INT type also
                migrations.RunSQL(
                    sql="""
                        CREATE INDEX CONCURRENTLY "attachment_object_id_uuid_idx"
                        ON "apiqa_storage_attachment" (("object_id"::uuid));
                        """,
                    reverse_sql="""
                        DROP INDEX "attachment_object_id_uuid_idx"
                        """
                ),
                migrations.RunSQL(
                    sql="""
                        CREATE INDEX CONCURRENTLY "attachment_object_id_int_idx"
                        ON "apiqa_storage_attachment" (("object_id"::integer));
                        """,
                    reverse_sql="""
                        DROP INDEX "attachment_object_id_int_idx"
                        """
                ),
            ]
        )
    ]
