

# long story
CB_RED    = 'red'
CB_GREEN  = 'green'
CB_BLUE   = 'blue'
CB_ORANGE = 'orange'
CB_PURPLE = 'purple'
CB_BROWN  = 'brown'


colors_string = """AliceBlue 	#F0F8FF	 	Shades	Mix
AntiqueWhite 	#FAEBD7	 	Shades	Mix
Aqua 	#00FFFF	 	Shades	Mix
Aquamarine 	#7FFFD4	 	Shades	Mix
Azure 	#F0FFFF	 	Shades	Mix
Beige 	#F5F5DC	 	Shades	Mix
Bisque 	#FFE4C4	 	Shades	Mix
Black 	#000000	 	Shades	Mix
BlanchedAlmond 	#FFEBCD	 	Shades	Mix
Blue 	#0000FF	 	Shades	Mix
BlueViolet 	#8A2BE2	 	Shades	Mix
Brown 	#A52A2A	 	Shades	Mix
BurlyWood 	#DEB887	 	Shades	Mix
CadetBlue 	#5F9EA0	 	Shades	Mix
Chartreuse 	#7FFF00	 	Shades	Mix
Chocolate 	#D2691E	 	Shades	Mix
Coral 	#FF7F50	 	Shades	Mix
CornflowerBlue 	#6495ED	 	Shades	Mix
Cornsilk 	#FFF8DC	 	Shades	Mix
Crimson 	#DC143C	 	Shades	Mix
Cyan 	#00FFFF	 	Shades	Mix
DarkBlue 	#00008B	 	Shades	Mix
DarkCyan 	#008B8B	 	Shades	Mix
DarkGoldenRod 	#B8860B	 	Shades	Mix
DarkGray 	#A9A9A9	 	Shades	Mix
DarkGreen 	#006400	 	Shades	Mix
DarkKhaki 	#BDB76B	 	Shades	Mix
DarkMagenta 	#8B008B	 	Shades	Mix
DarkOliveGreen 	#556B2F	 	Shades	Mix
DarkOrange 	#FF8C00	 	Shades	Mix
DarkOrchid 	#9932CC	 	Shades	Mix
DarkRed 	#8B0000	 	Shades	Mix
DarkSalmon 	#E9967A	 	Shades	Mix
DarkSeaGreen 	#8FBC8F	 	Shades	Mix
DarkSlateBlue 	#483D8B	 	Shades	Mix
DarkSlateGray 	#2F4F4F	 	Shades	Mix
DarkTurquoise 	#00CED1	 	Shades	Mix
DarkViolet 	#9400D3	 	Shades	Mix
DeepPink 	#FF1493	 	Shades	Mix
DeepSkyBlue 	#00BFFF	 	Shades	Mix
DimGray 	#696969	 	Shades	Mix
DodgerBlue 	#1E90FF	 	Shades	Mix
FireBrick 	#B22222	 	Shades	Mix
FloralWhite 	#FFFAF0	 	Shades	Mix
ForestGreen 	#228B22	 	Shades	Mix
Fuchsia 	#FF00FF	 	Shades	Mix
Gainsboro 	#DCDCDC	 	Shades	Mix
GhostWhite 	#F8F8FF	 	Shades	Mix
Gold 	#FFD700	 	Shades	Mix
GoldenRod 	#DAA520	 	Shades	Mix
Gray 	#808080	 	Shades	Mix
Green 	#008000	 	Shades	Mix
GreenYellow 	#ADFF2F	 	Shades	Mix
HoneyDew 	#F0FFF0	 	Shades	Mix
HotPink 	#FF69B4	 	Shades	Mix
IndianRed  	#CD5C5C	 	Shades	Mix
Indigo  	#4B0082	 	Shades	Mix
Ivory 	#FFFFF0	 	Shades	Mix
Khaki 	#F0E68C	 	Shades	Mix
Lavender 	#E6E6FA	 	Shades	Mix
LavenderBlush 	#FFF0F5	 	Shades	Mix
LawnGreen 	#7CFC00	 	Shades	Mix
LemonChiffon 	#FFFACD	 	Shades	Mix
LightBlue 	#ADD8E6	 	Shades	Mix
LightCoral 	#F08080	 	Shades	Mix
LightCyan 	#E0FFFF	 	Shades	Mix
LightGoldenRodYellow 	#FAFAD2	 	Shades	Mix
LightGray 	#D3D3D3	 	Shades	Mix
LightGreen 	#90EE90	 	Shades	Mix
LightPink 	#FFB6C1	 	Shades	Mix
LightSalmon 	#FFA07A	 	Shades	Mix
LightSeaGreen 	#20B2AA	 	Shades	Mix
LightSkyBlue 	#87CEFA	 	Shades	Mix
LightSlateGray 	#778899	 	Shades	Mix
LightSteelBlue 	#B0C4DE	 	Shades	Mix
LightYellow 	#FFFFE0	 	Shades	Mix
Lime 	#00FF00	 	Shades	Mix
LimeGreen 	#32CD32	 	Shades	Mix
Linen 	#FAF0E6	 	Shades	Mix
Magenta 	#FF00FF	 	Shades	Mix
Maroon 	#800000	 	Shades	Mix
MediumAquaMarine 	#66CDAA	 	Shades	Mix
MediumBlue 	#0000CD	 	Shades	Mix
MediumOrchid 	#BA55D3	 	Shades	Mix
MediumPurple 	#9370DB	 	Shades	Mix
MediumSeaGreen 	#3CB371	 	Shades	Mix
MediumSlateBlue 	#7B68EE	 	Shades	Mix
MediumSpringGreen 	#00FA9A	 	Shades	Mix
MediumTurquoise 	#48D1CC	 	Shades	Mix
MediumVioletRed 	#C71585	 	Shades	Mix
MidnightBlue 	#191970	 	Shades	Mix
MintCream 	#F5FFFA	 	Shades	Mix
MistyRose 	#FFE4E1	 	Shades	Mix
Moccasin 	#FFE4B5	 	Shades	Mix
NavajoWhite 	#FFDEAD	 	Shades	Mix
Navy 	#000080	 	Shades	Mix
OldLace 	#FDF5E6	 	Shades	Mix
Olive 	#808000	 	Shades	Mix
OliveDrab 	#6B8E23	 	Shades	Mix
Orange 	#FFA500	 	Shades	Mix
OrangeRed 	#FF4500	 	Shades	Mix
Orchid 	#DA70D6	 	Shades	Mix
PaleGoldenRod 	#EEE8AA	 	Shades	Mix
PaleGreen 	#98FB98	 	Shades	Mix
PaleTurquoise 	#AFEEEE	 	Shades	Mix
PaleVioletRed 	#DB7093	 	Shades	Mix
PapayaWhip 	#FFEFD5	 	Shades	Mix
PeachPuff 	#FFDAB9	 	Shades	Mix
Peru 	#CD853F	 	Shades	Mix
Pink 	#FFC0CB	 	Shades	Mix
Plum 	#DDA0DD	 	Shades	Mix
PowderBlue 	#B0E0E6	 	Shades	Mix
Purple 	#800080	 	Shades	Mix
RebeccaPurple 	#663399	 	Shades	Mix
Red 	#FF0000	 	Shades	Mix
RosyBrown 	#BC8F8F	 	Shades	Mix
RoyalBlue 	#4169E1	 	Shades	Mix
SaddleBrown 	#8B4513	 	Shades	Mix
Salmon 	#FA8072	 	Shades	Mix
SandyBrown 	#F4A460	 	Shades	Mix
SeaGreen 	#2E8B57	 	Shades	Mix
SeaShell 	#FFF5EE	 	Shades	Mix
Sienna 	#A0522D	 	Shades	Mix
Silver 	#C0C0C0	 	Shades	Mix
SkyBlue 	#87CEEB	 	Shades	Mix
SlateBlue 	#6A5ACD	 	Shades	Mix
SlateGray 	#708090	 	Shades	Mix
Snow 	#FFFAFA	 	Shades	Mix
SpringGreen 	#00FF7F	 	Shades	Mix
SteelBlue 	#4682B4	 	Shades	Mix
Tan 	#D2B48C	 	Shades	Mix
Teal 	#008080	 	Shades	Mix
Thistle 	#D8BFD8	 	Shades	Mix
Tomato 	#FF6347	 	Shades	Mix
Turquoise 	#40E0D0	 	Shades	Mix
Violet 	#EE82EE	 	Shades	Mix
Wheat 	#F5DEB3	 	Shades	Mix
White 	#FFFFFF	 	Shades	Mix
WhiteSmoke 	#F5F5F5	 	Shades	Mix
Yellow 	#FFFF00	 	Shades	Mix
YellowGreen 	#9ACD32	 	Shades	Mix"""

html_colors = []
html_colors_no_whites = []
html_colors_no_lights = []
all_rgb = {}

def rgb_from_hex( hex ):
    assert hex[0] == '#' and len(hex)==7
    return ( int(hex[1:3],16),
             int(hex[3:5],16),
             int(hex[5:7],16) )

for line in colors_string.split('\n'):
    l = line.split()
    colorname = l[0].lower()
    if colorname == 'rebeccapurple': continue ## matplotlib doesnt like this one...
    hex = l[1]

    r,g,b = rgb_from_hex( hex )

    lowername = colorname.lower()
    html_colors.append( lowername )
    all_rgb[ lowername ] = (r,g,b)

    avg_rgb= sum((r,g,b))/3.0


    if 'white' not in lowername:
        html_colors_no_whites.append( lowername )

    if 'white' not in lowername and avg_rgb<210:
        html_colors_no_lights.append( lowername )


## get some colors for objects sorted by frequency
## fiddle with random seed/state to get consistent colors; legacy silliness...
##
import random
initial_random_state = random.getstate()

random.seed(2)

starter_colors = ['red',
                  'green',
                  'blue',
                  'cyan',
                  'magenta',
                  'black',
                  'lime',
                  'purple',
                  'gold',
                  'olive',
                  'maroon',
]
for c in starter_colors:
    assert c in html_colors_no_whites

other_colors = [ x for x in html_colors_no_whites if x not in starter_colors ]
other_colors_no_lights = [ x for x in html_colors_no_lights if x not in starter_colors ]

random.shuffle( other_colors )
rank_colors = starter_colors + other_colors

random.shuffle( other_colors_no_lights )
rank_colors_no_lights = starter_colors + other_colors_no_lights

random.setstate(initial_random_state)

def get_rank_colors( num ):
    n_rank_colors = len(rank_colors)
    colors = []

    for i in range( num ):
        colors.append( rank_colors[ i%n_rank_colors ] )
    return colors

def get_rank_colors_no_lights( num ):
    n_rank_colors = len(rank_colors_no_lights)
    colors = []

    for i in range( num ):
        colors.append( rank_colors_no_lights[ i%n_rank_colors ] )
    return colors


if __name__=='__main__':
    colors = get_rank_colors(20)
    for i,col in enumerate(colors):
        print(i,col,sum(all_rgb[col]))

    colors = get_rank_colors_no_lights(20)
    for i,col in enumerate(colors):
        print(i,col,sum(all_rgb[col]))


