# Installation (Requires Python 3.9 and above)

Use the following command:

```
pip install nrgrank
```
Using NRGRank in a python script:

```
from nrgrank import process_target, process_ligands, nrgrank_main
```

# Preparatory steps

## 1. Preprocessing the target

### Required Arguments
| Argument                 | Description                                     | Possible value(s) |
|--------------------------|-------------------------------------------------|-------------------|
| `target_mol2_path`       | Path to target mol2 file                        | Absolute path     |
| `binding_site_file_path` | Path to binding site file generated by GetCleft | Absolute path     |

### Optional Arguments
| Flag             | Description                                           | Possible value(s) |
|------------------|-------------------------------------------------------|-------------------|
| `create_new_dir` | A new folder will be created to store generated files | True,False        |
| `overwrite`      | Allows overwriting existing files                     | True,False        |

### Example command

```
target_save_dir = process_target(target_mol2_path='foo/bar/target.mol2', binding_site_file_path='foo/bar/bd_site_sph_1.pdb')
```

## 2. Preparing the ligands
   
All ligands for one screen must be in the same mol2 file
      
   ### Required Arguments
   
   For running on a single mol2 file:

   | Flag                      | Description                       | Possible value(s) |
   |---------------------------|-----------------------------------|-------------------|
   | `ligand_path`             | Path to ligand mol2 file          | Absolute path     |
   | `conformers_per_molecule` | Number of conformers per molecule | Int               |

   
   ### Optional Arguments

   | Flag           | Description                                                                          | Possible value(s) |
   |----------------|--------------------------------------------------------------------------------------|-------------------|
   | `overwrite`    | Allows overwriting existing files                                                    | True,False        |
   | `ligand_type`  | Assign a specific ligand type recognised by NRGRank. Can be useful for benchmarking. | (str)             |    
   | `output_dir`   | Folder where generated files will be stored                                          | Absolute path     |
   
   ### Example commands:

   ```
   ligand_save_dir = process_ligands(ligand_path='foo/bar/ligands.mol2', conformers_per_molecule=1)
   ```

---
# NRGRank

### Required Flags
    
| Flag                       | Description                                                                     | Possible value(s) |
|----------------------------|---------------------------------------------------------------------------------|-------------------|
| `target_name`              | Target name that is used to name the output file                                | (str)             |
| `preprocessed_target_path` | Path to preprocessed_target folder (can be path returned from process_target)   | Absolute path     |
| `preprocessed_ligand_path` | Path to preprocessed_ligands folder (can be path returned from process_ligands) | Absolute path     |
| `result_folder_path`       | Path to folder where result file will be written                                | Absolute path     |

### Optional Flags
    
| Flag                        | Description                                                                        | Possible value(s)   |
|-----------------------------|------------------------------------------------------------------------------------|---------------------|
| `ligand_type`               | Type of ligand. Useful when benchmarking with DUD-E                                | active,decoy,ligand |
| `ligand_slice`              | List of 2 numbers containing the index of the first and last ligand to be screened | (list)              |
| `write_info`                | Write a .txt file containing information about the run                             | True,False          |
| `write_csv`                 | Write a the result csv                                                             | True,False          |
| `unique_run_id`             | Adds a unique id to the output                                                     | (str,int)           |
| `result_csv_and_pose_name`  | changes the name of written result csv and folder for ligand poses                 | (str)               |

### Example commands:

   ```
   result_file_path, result_csv_lines = nrgrank_main(target_name='target', 
                      preprocessed_target_path='foo/bar/preprocessed_target', 
                      preprocessed_ligand_path='foo/bar/preprocessed_ligands_1_conf',
                      result_folder_path='foo/bar/results')
   ```

Returns the path to the result file and the lines contained in the result csv