import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Cassandra::Keyspace`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html
 */
export interface CfnKeyspaceProps {
    /**
     * `AWS::Cassandra::Keyspace.KeyspaceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-keyspacename
     */
    readonly keyspaceName?: string;
}
/**
 * A CloudFormation `AWS::Cassandra::Keyspace`
 *
 * @cloudformationResource AWS::Cassandra::Keyspace
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html
 */
export declare class CfnKeyspace extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cassandra::Keyspace";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnKeyspace;
    /**
     * `AWS::Cassandra::Keyspace.KeyspaceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-keyspacename
     */
    keyspaceName: string | undefined;
    /**
     * Create a new `AWS::Cassandra::Keyspace`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnKeyspaceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Cassandra::Table`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html
 */
export interface CfnTableProps {
    /**
     * `AWS::Cassandra::Table.KeyspaceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-keyspacename
     */
    readonly keyspaceName: string;
    /**
     * `AWS::Cassandra::Table.PartitionKeyColumns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-partitionkeycolumns
     */
    readonly partitionKeyColumns: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cassandra::Table.BillingMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-billingmode
     */
    readonly billingMode?: CfnTable.BillingModeProperty | cdk.IResolvable;
    /**
     * `AWS::Cassandra::Table.ClusteringKeyColumns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clusteringkeycolumns
     */
    readonly clusteringKeyColumns?: Array<CfnTable.ClusteringKeyColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cassandra::Table.RegularColumns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-regularcolumns
     */
    readonly regularColumns?: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cassandra::Table.TableName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-tablename
     */
    readonly tableName?: string;
}
/**
 * A CloudFormation `AWS::Cassandra::Table`
 *
 * @cloudformationResource AWS::Cassandra::Table
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html
 */
export declare class CfnTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Cassandra::Table";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnTable;
    /**
     * `AWS::Cassandra::Table.KeyspaceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-keyspacename
     */
    keyspaceName: string;
    /**
     * `AWS::Cassandra::Table.PartitionKeyColumns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-partitionkeycolumns
     */
    partitionKeyColumns: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Cassandra::Table.BillingMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-billingmode
     */
    billingMode: CfnTable.BillingModeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Cassandra::Table.ClusteringKeyColumns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-clusteringkeycolumns
     */
    clusteringKeyColumns: Array<CfnTable.ClusteringKeyColumnProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cassandra::Table.RegularColumns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-regularcolumns
     */
    regularColumns: Array<CfnTable.ColumnProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Cassandra::Table.TableName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-table.html#cfn-cassandra-table-tablename
     */
    tableName: string | undefined;
    /**
     * Create a new `AWS::Cassandra::Table`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTableProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnTable {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html
     */
    interface BillingModeProperty {
        /**
         * `CfnTable.BillingModeProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html#cfn-cassandra-table-billingmode-mode
         */
        readonly mode: string;
        /**
         * `CfnTable.BillingModeProperty.ProvisionedThroughput`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-billingmode.html#cfn-cassandra-table-billingmode-provisionedthroughput
         */
        readonly provisionedThroughput?: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable;
    }
}
export declare namespace CfnTable {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html
     */
    interface ClusteringKeyColumnProperty {
        /**
         * `CfnTable.ClusteringKeyColumnProperty.Column`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html#cfn-cassandra-table-clusteringkeycolumn-column
         */
        readonly column: CfnTable.ColumnProperty | cdk.IResolvable;
        /**
         * `CfnTable.ClusteringKeyColumnProperty.OrderBy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-clusteringkeycolumn.html#cfn-cassandra-table-clusteringkeycolumn-orderby
         */
        readonly orderBy?: string;
    }
}
export declare namespace CfnTable {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html
     */
    interface ColumnProperty {
        /**
         * `CfnTable.ColumnProperty.ColumnName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html#cfn-cassandra-table-column-columnname
         */
        readonly columnName: string;
        /**
         * `CfnTable.ColumnProperty.ColumnType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-column.html#cfn-cassandra-table-column-columntype
         */
        readonly columnType: string;
    }
}
export declare namespace CfnTable {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html
     */
    interface ProvisionedThroughputProperty {
        /**
         * `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html#cfn-cassandra-table-provisionedthroughput-readcapacityunits
         */
        readonly readCapacityUnits: number;
        /**
         * `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cassandra-table-provisionedthroughput.html#cfn-cassandra-table-provisionedthroughput-writecapacityunits
         */
        readonly writeCapacityUnits: number;
    }
}
