import { __assign } from "tslib";
export var waiterServiceDefaults = {
    minDelay: 2,
    maxDelay: 120,
};
export var WaiterState;
(function (WaiterState) {
    WaiterState["ABORTED"] = "ABORTED";
    WaiterState["FAILURE"] = "FAILURE";
    WaiterState["SUCCESS"] = "SUCCESS";
    WaiterState["RETRY"] = "RETRY";
    WaiterState["TIMEOUT"] = "TIMEOUT";
})(WaiterState || (WaiterState = {}));
export var checkExceptions = function (result) {
    if (result.state === WaiterState.ABORTED) {
        var abortError = new Error("" + JSON.stringify(__assign(__assign({}, result), { reason: "Request was aborted" })));
        abortError.name = "AbortError";
        throw abortError;
    }
    else if (result.state === WaiterState.TIMEOUT) {
        var timeoutError = new Error("" + JSON.stringify(__assign(__assign({}, result), { reason: "Waiter has timed out" })));
        timeoutError.name = "TimeoutError";
        throw timeoutError;
    }
    else if (result.state !== WaiterState.SUCCESS) {
        throw new Error("" + JSON.stringify({ result: result }));
    }
    return result;
};
