"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeCredentialsProvider = exports.normalizeRegionProvider = void 0;
const normalizeRegionProvider = (region) => {
    if (typeof region === "string") {
        const promisified = Promise.resolve(region);
        return () => promisified;
    }
    else {
        return region;
    }
};
exports.normalizeRegionProvider = normalizeRegionProvider;
const normalizeCredentialsProvider = (credentials) => {
    if (typeof credentials === "object") {
        const promisified = Promise.resolve(credentials);
        return () => promisified;
    }
    else {
        return credentials;
    }
};
exports.normalizeCredentialsProvider = normalizeCredentialsProvider;
