import { HttpHandler, HttpRequest, HttpResponse } from "@aws-sdk/protocol-http";
import { HttpHandlerOptions } from "@aws-sdk/types";

export interface NodeHttp2HandlerOptions {
    
    requestTimeout?: number;
    
    sessionTimeout?: number;
    
    disableConcurrentStreams?: boolean;
}
export declare class NodeHttp2Handler implements HttpHandler {
    private readonly requestTimeout?;
    private readonly sessionTimeout?;
    private readonly disableConcurrentStreams?;
    readonly metadata: {
        handlerProtocol: string;
    };
    private sessionCache;
    constructor({ requestTimeout, sessionTimeout, disableConcurrentStreams }?: NodeHttp2HandlerOptions);
    destroy(): void;
    handle(request: HttpRequest, { abortSignal }?: HttpHandlerOptions): Promise<{
        response: HttpResponse;
    }>;
    
    private getSession;
    
    private destroySession;
    
    private deleteSessionFromCache;
}
