import { HttpHandler, HttpRequest, HttpResponse } from "@aws-sdk/protocol-http";
import { HttpHandlerOptions } from "@aws-sdk/types";
/**
 * Represents the http2 options that can be passed to a node http2 client.
 */
export interface NodeHttp2HandlerOptions {
    /**
     * The maximum time in milliseconds that a stream may remain idle before it
     * is closed.
     */
    requestTimeout?: number;
    /**
     * The maximum time in milliseconds that a session or socket may remain idle
     * before it is closed.
     * https://nodejs.org/docs/latest-v12.x/api/http2.html#http2_http2session_and_sockets
     */
    sessionTimeout?: number;
    /**
     * Disables processing concurrent streams on a ClientHttp2Session instance. When set
     * to true, the handler will create a new session instance for each request to a URL.
     * **Default:** false.
     * https://nodejs.org/api/http2.html#http2_class_clienthttp2session
     */
    disableConcurrentStreams?: boolean;
}
export declare class NodeHttp2Handler implements HttpHandler {
    private readonly requestTimeout?;
    private readonly sessionTimeout?;
    private readonly disableConcurrentStreams?;
    readonly metadata: {
        handlerProtocol: string;
    };
    private sessionCache;
    constructor({ requestTimeout, sessionTimeout, disableConcurrentStreams }?: NodeHttp2HandlerOptions);
    destroy(): void;
    handle(request: HttpRequest, { abortSignal }?: HttpHandlerOptions): Promise<{
        response: HttpResponse;
    }>;
    /**
     * Returns a session for the given URL.
     *
     * @param authority The URL to create a session for.
     * @param disableConcurrentStreams If true, a new session will be created for each request.
     * @returns A session for the given URL.
     */
    private getSession;
    /**
     * Destroys a session.
     * @param session The session to destroy.
     */
    private destroySession;
    /**
     * Delete a session from the connection pool.
     * @param authority The authority of the session to delete.
     * @param session The session to delete.
     */
    private deleteSessionFromCache;
}
