import { __assign, __awaiter, __generator } from "tslib";
import { HttpRequest } from "@aws-sdk/protocol-http";
import { SignatureV4 } from "@aws-sdk/signature-v4";
import { formatUrl } from "@aws-sdk/util-format-url";
var version = "2016-11-15";
export function copySnapshotPresignedUrlMiddleware(options) {
    var _this = this;
    return function (next) {
        return function (args) { return __awaiter(_this, void 0, void 0, function () {
            var input, region, resolvedEndpoint, request, signer, presignedRequest;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        input = args.input;
                        if (!!input.PresignedUrl) return [3, 4];
                        return [4, options.region()];
                    case 1:
                        region = _a.sent();
                        return [4, options.endpoint()];
                    case 2:
                        resolvedEndpoint = _a.sent();
                        resolvedEndpoint.hostname = "ec2." + input.SourceRegion + ".amazonaws.com";
                        request = new HttpRequest(__assign(__assign({}, resolvedEndpoint), { protocol: "https", headers: {
                                host: resolvedEndpoint.hostname,
                            }, query: {
                                Action: "CopySnapshot",
                                Version: version,
                                SourceRegion: input.SourceRegion,
                                SourceSnapshotId: input.SourceSnapshotId,
                                DestinationRegion: region,
                            } }));
                        signer = new SignatureV4({
                            credentials: options.credentials,
                            region: input.SourceRegion,
                            service: "ec2",
                            sha256: options.sha256,
                            uriEscapePath: options.signingEscapePath,
                        });
                        return [4, signer.presign(request, {
                                expiresIn: 3600,
                            })];
                    case 3:
                        presignedRequest = _a.sent();
                        args = __assign(__assign({}, args), { input: __assign(__assign({}, args.input), { DestinationRegion: region, PresignedUrl: formatUrl(presignedRequest) }) });
                        _a.label = 4;
                    case 4: return [2, next(args)];
                }
            });
        }); };
    };
}
export var copySnapshotPresignedUrlMiddlewareOptions = {
    step: "initialize",
    tags: ["CROSS_REGION_PRESIGNED_URL"],
    name: "crossRegionPresignedUrlMiddleware",
    override: true,
};
export var getCopySnapshotPresignedUrlPlugin = function (config) { return ({
    applyToStack: function (clientStack) {
        clientStack.add(copySnapshotPresignedUrlMiddleware(config), copySnapshotPresignedUrlMiddlewareOptions);
    },
}); };
