import { SSOClient } from "@aws-sdk/client-sso";
import { Profile } from "@aws-sdk/shared-ini-file-loader";
import { CredentialProvider } from "@aws-sdk/types";
import { SourceProfileInit } from "@aws-sdk/util-credentials";

export declare const EXPIRE_WINDOW_MS: number;
export interface SsoCredentialsParameters {
    
    ssoStartUrl: string;
    
    ssoAccountId: string;
    
    ssoRegion: string;
    
    ssoRoleName: string;
}
export interface FromSSOInit extends SourceProfileInit {
    ssoClient?: SSOClient;
}

export declare const fromSSO: (init?: FromSSOInit & Partial<SsoCredentialsParameters>) => CredentialProvider;

export interface SsoProfile extends Profile {
    sso_start_url: string;
    sso_account_id: string;
    sso_region: string;
    sso_role_name: string;
}

export declare const validateSsoProfile: (profile: Partial<SsoProfile>) => SsoProfile;

export declare const isSsoProfile: (arg: Profile) => arg is Partial<SsoProfile>;
