import { MetadataBearer as $MetadataBearer, SmithyException as __SmithyException } from "@aws-sdk/types";

export interface AccountInfo {
    
    accountId?: string;
    
    accountName?: string;
    
    emailAddress?: string;
}
export declare namespace AccountInfo {
    
    const filterSensitiveLog: (obj: AccountInfo) => any;
}
export interface GetRoleCredentialsRequest {
    
    roleName: string | undefined;
    
    accountId: string | undefined;
    
    accessToken: string | undefined;
}
export declare namespace GetRoleCredentialsRequest {
    
    const filterSensitiveLog: (obj: GetRoleCredentialsRequest) => any;
}

export interface RoleCredentials {
    
    accessKeyId?: string;
    
    secretAccessKey?: string;
    
    sessionToken?: string;
    
    expiration?: number;
}
export declare namespace RoleCredentials {
    
    const filterSensitiveLog: (obj: RoleCredentials) => any;
}
export interface GetRoleCredentialsResponse {
    
    roleCredentials?: RoleCredentials;
}
export declare namespace GetRoleCredentialsResponse {
    
    const filterSensitiveLog: (obj: GetRoleCredentialsResponse) => any;
}

export interface InvalidRequestException extends __SmithyException, $MetadataBearer {
    name: "InvalidRequestException";
    $fault: "client";
    message?: string;
}
export declare namespace InvalidRequestException {
    
    const filterSensitiveLog: (obj: InvalidRequestException) => any;
}

export interface ResourceNotFoundException extends __SmithyException, $MetadataBearer {
    name: "ResourceNotFoundException";
    $fault: "client";
    message?: string;
}
export declare namespace ResourceNotFoundException {
    
    const filterSensitiveLog: (obj: ResourceNotFoundException) => any;
}

export interface TooManyRequestsException extends __SmithyException, $MetadataBearer {
    name: "TooManyRequestsException";
    $fault: "client";
    message?: string;
}
export declare namespace TooManyRequestsException {
    
    const filterSensitiveLog: (obj: TooManyRequestsException) => any;
}

export interface UnauthorizedException extends __SmithyException, $MetadataBearer {
    name: "UnauthorizedException";
    $fault: "client";
    message?: string;
}
export declare namespace UnauthorizedException {
    
    const filterSensitiveLog: (obj: UnauthorizedException) => any;
}
export interface ListAccountRolesRequest {
    
    nextToken?: string;
    
    maxResults?: number;
    
    accessToken: string | undefined;
    
    accountId: string | undefined;
}
export declare namespace ListAccountRolesRequest {
    
    const filterSensitiveLog: (obj: ListAccountRolesRequest) => any;
}

export interface RoleInfo {
    
    roleName?: string;
    
    accountId?: string;
}
export declare namespace RoleInfo {
    
    const filterSensitiveLog: (obj: RoleInfo) => any;
}
export interface ListAccountRolesResponse {
    
    nextToken?: string;
    
    roleList?: RoleInfo[];
}
export declare namespace ListAccountRolesResponse {
    
    const filterSensitiveLog: (obj: ListAccountRolesResponse) => any;
}
export interface ListAccountsRequest {
    
    nextToken?: string;
    
    maxResults?: number;
    
    accessToken: string | undefined;
}
export declare namespace ListAccountsRequest {
    
    const filterSensitiveLog: (obj: ListAccountsRequest) => any;
}
export interface ListAccountsResponse {
    
    nextToken?: string;
    
    accountList?: AccountInfo[];
}
export declare namespace ListAccountsResponse {
    
    const filterSensitiveLog: (obj: ListAccountsResponse) => any;
}
export interface LogoutRequest {
    
    accessToken: string | undefined;
}
export declare namespace LogoutRequest {
    
    const filterSensitiveLog: (obj: LogoutRequest) => any;
}
