import { EndpointsInputConfig, EndpointsResolvedConfig, RegionInputConfig, RegionResolvedConfig } from "@aws-sdk/config-resolver";
import { HostHeaderInputConfig, HostHeaderResolvedConfig } from "@aws-sdk/middleware-host-header";
import { RetryInputConfig, RetryResolvedConfig } from "@aws-sdk/middleware-retry";
import { UserAgentInputConfig, UserAgentResolvedConfig } from "@aws-sdk/middleware-user-agent";
import { HttpHandler as __HttpHandler } from "@aws-sdk/protocol-http";
import { Client as __Client, SmithyConfiguration as __SmithyConfiguration, SmithyResolvedConfiguration as __SmithyResolvedConfiguration } from "@aws-sdk/smithy-client";
import { Decoder as __Decoder, Encoder as __Encoder, HashConstructor as __HashConstructor, HttpHandlerOptions as __HttpHandlerOptions, Logger as __Logger, Provider as __Provider, Provider, RegionInfoProvider, StreamCollector as __StreamCollector, UrlParser as __UrlParser, UserAgent as __UserAgent } from "@aws-sdk/types";
import { GetRoleCredentialsCommandInput, GetRoleCredentialsCommandOutput } from "./commands/GetRoleCredentialsCommand";
import { ListAccountRolesCommandInput, ListAccountRolesCommandOutput } from "./commands/ListAccountRolesCommand";
import { ListAccountsCommandInput, ListAccountsCommandOutput } from "./commands/ListAccountsCommand";
import { LogoutCommandInput, LogoutCommandOutput } from "./commands/LogoutCommand";
export declare type ServiceInputTypes = GetRoleCredentialsCommandInput | ListAccountRolesCommandInput | ListAccountsCommandInput | LogoutCommandInput;
export declare type ServiceOutputTypes = GetRoleCredentialsCommandOutput | ListAccountRolesCommandOutput | ListAccountsCommandOutput | LogoutCommandOutput;
export interface ClientDefaults extends Partial<__SmithyResolvedConfiguration<__HttpHandlerOptions>> {
    
    requestHandler?: __HttpHandler;
    
    sha256?: __HashConstructor;
    
    urlParser?: __UrlParser;
    
    bodyLengthChecker?: (body: any) => number | undefined;
    
    streamCollector?: __StreamCollector;
    
    base64Decoder?: __Decoder;
    
    base64Encoder?: __Encoder;
    
    utf8Decoder?: __Decoder;
    
    utf8Encoder?: __Encoder;
    
    runtime?: string;
    
    disableHostPrefix?: boolean;
    
    maxAttempts?: number | __Provider<number>;
    
    retryMode?: string | __Provider<string>;
    
    logger?: __Logger;
    
    useDualstackEndpoint?: boolean | __Provider<boolean>;
    
    useFipsEndpoint?: boolean | __Provider<boolean>;
    
    serviceId?: string;
    
    region?: string | __Provider<string>;
    
    regionInfoProvider?: RegionInfoProvider;
    
    defaultUserAgentProvider?: Provider<__UserAgent>;
}
declare type SSOClientConfigType = Partial<__SmithyConfiguration<__HttpHandlerOptions>> & ClientDefaults & RegionInputConfig & EndpointsInputConfig & RetryInputConfig & HostHeaderInputConfig & UserAgentInputConfig;

export interface SSOClientConfig extends SSOClientConfigType {
}
declare type SSOClientResolvedConfigType = __SmithyResolvedConfiguration<__HttpHandlerOptions> & Required<ClientDefaults> & RegionResolvedConfig & EndpointsResolvedConfig & RetryResolvedConfig & HostHeaderResolvedConfig & UserAgentResolvedConfig;

export interface SSOClientResolvedConfig extends SSOClientResolvedConfigType {
}

export declare class SSOClient extends __Client<__HttpHandlerOptions, ServiceInputTypes, ServiceOutputTypes, SSOClientResolvedConfig> {
    
    readonly config: SSOClientResolvedConfig;
    constructor(configuration: SSOClientConfig);
    
    destroy(): void;
}
export {};
