import { _InstanceType, ActiveInstance, AllocationState, AllowsMultipleInstanceTypes, AlternatePathHint, AnalysisAclRule, AnalysisComponent, AnalysisRouteTableRoute, AnalysisSecurityGroupRule, AttachmentStatus, AttributeValue, AutoPlacement, CurrencyCodeValues, CustomerGateway, DhcpOptions, EgressOnlyInternetGateway, FleetExcessCapacityTerminationPolicy, HostnameType, HostRecovery, IamInstanceProfile, IamInstanceProfileAssociation, InstanceEventWindow, PathComponent, PortRange, ReservedInstancesListing, Tag, Tenancy } from "./models_0";
import { BlockDeviceMapping, CapacityReservationPreference, CapacityReservationTargetResponse, DefaultTargetCapacityType, DestinationFileFormat, ExportTask, FleetCapacityReservationUsageStrategy, FleetLaunchTemplateOverrides, FleetLaunchTemplateSpecification, FleetOnDemandAllocationStrategy, FleetReplacementStrategy, FleetType, GroupIdentifier, InstanceIpv6Address, InstanceLifecycle, InternetGateway, Ipam, IpamPool, IpamScope, KeyType, LaunchTemplate, LaunchTemplateAndOverridesResponse, LaunchTemplateVersion, LocalGatewayRouteTableVpcAssociation, LogDestinationType, ManagedPrefixList, NatGateway, NetworkAcl, NetworkInsightsAccessScope, NetworkInsightsPath, NetworkInterface, NetworkInterfaceAttachment, NetworkInterfacePermission, NetworkInterfaceStatus, Placement, PlacementGroup, PlatformValues, ReplaceRootVolumeTask, SpotAllocationStrategy, SpotInstanceInterruptionBehavior, TargetCapacityUnitType, TrafficType } from "./models_1";
import { ConversionTaskState, Filter, FleetStateCode, IdFormat, ImportInstanceTaskDetails, ImportVolumeTaskDetails, InstanceTagNotificationAttribute } from "./models_2";

export interface ConversionTask {
    
    ConversionTaskId?: string;
    
    ExpirationTime?: string;
    
    ImportInstance?: ImportInstanceTaskDetails;
    
    ImportVolume?: ImportVolumeTaskDetails;
    
    State?: ConversionTaskState | string;
    
    StatusMessage?: string;
    
    Tags?: Tag[];
}
export declare namespace ConversionTask {
    
    const filterSensitiveLog: (obj: ConversionTask) => any;
}
export interface DescribeConversionTasksResult {
    
    ConversionTasks?: ConversionTask[];
}
export declare namespace DescribeConversionTasksResult {
    
    const filterSensitiveLog: (obj: DescribeConversionTasksResult) => any;
}

export interface DescribeCustomerGatewaysRequest {
    
    CustomerGatewayIds?: string[];
    
    Filters?: Filter[];
    
    DryRun?: boolean;
}
export declare namespace DescribeCustomerGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeCustomerGatewaysRequest) => any;
}

export interface DescribeCustomerGatewaysResult {
    
    CustomerGateways?: CustomerGateway[];
}
export declare namespace DescribeCustomerGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeCustomerGatewaysResult) => any;
}
export interface DescribeDhcpOptionsRequest {
    
    DhcpOptionsIds?: string[];
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeDhcpOptionsRequest {
    
    const filterSensitiveLog: (obj: DescribeDhcpOptionsRequest) => any;
}
export interface DescribeDhcpOptionsResult {
    
    DhcpOptions?: DhcpOptions[];
    
    NextToken?: string;
}
export declare namespace DescribeDhcpOptionsResult {
    
    const filterSensitiveLog: (obj: DescribeDhcpOptionsResult) => any;
}
export interface DescribeEgressOnlyInternetGatewaysRequest {
    
    DryRun?: boolean;
    
    EgressOnlyInternetGatewayIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: Filter[];
}
export declare namespace DescribeEgressOnlyInternetGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeEgressOnlyInternetGatewaysRequest) => any;
}
export interface DescribeEgressOnlyInternetGatewaysResult {
    
    EgressOnlyInternetGateways?: EgressOnlyInternetGateway[];
    
    NextToken?: string;
}
export declare namespace DescribeEgressOnlyInternetGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeEgressOnlyInternetGatewaysResult) => any;
}
export interface DescribeElasticGpusRequest {
    
    ElasticGpuIds?: string[];
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeElasticGpusRequest {
    
    const filterSensitiveLog: (obj: DescribeElasticGpusRequest) => any;
}
export declare enum ElasticGpuStatus {
    Impaired = "IMPAIRED",
    Ok = "OK"
}

export interface ElasticGpuHealth {
    
    Status?: ElasticGpuStatus | string;
}
export declare namespace ElasticGpuHealth {
    
    const filterSensitiveLog: (obj: ElasticGpuHealth) => any;
}
export declare enum ElasticGpuState {
    Attached = "ATTACHED"
}

export interface ElasticGpus {
    
    ElasticGpuId?: string;
    
    AvailabilityZone?: string;
    
    ElasticGpuType?: string;
    
    ElasticGpuHealth?: ElasticGpuHealth;
    
    ElasticGpuState?: ElasticGpuState | string;
    
    InstanceId?: string;
    
    Tags?: Tag[];
}
export declare namespace ElasticGpus {
    
    const filterSensitiveLog: (obj: ElasticGpus) => any;
}
export interface DescribeElasticGpusResult {
    
    ElasticGpuSet?: ElasticGpus[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeElasticGpusResult {
    
    const filterSensitiveLog: (obj: DescribeElasticGpusResult) => any;
}
export interface DescribeExportImageTasksRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    ExportImageTaskIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeExportImageTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeExportImageTasksRequest) => any;
}

export interface ExportTaskS3Location {
    
    S3Bucket?: string;
    
    S3Prefix?: string;
}
export declare namespace ExportTaskS3Location {
    
    const filterSensitiveLog: (obj: ExportTaskS3Location) => any;
}

export interface ExportImageTask {
    
    Description?: string;
    
    ExportImageTaskId?: string;
    
    ImageId?: string;
    
    Progress?: string;
    
    S3ExportLocation?: ExportTaskS3Location;
    
    Status?: string;
    
    StatusMessage?: string;
    
    Tags?: Tag[];
}
export declare namespace ExportImageTask {
    
    const filterSensitiveLog: (obj: ExportImageTask) => any;
}
export interface DescribeExportImageTasksResult {
    
    ExportImageTasks?: ExportImageTask[];
    
    NextToken?: string;
}
export declare namespace DescribeExportImageTasksResult {
    
    const filterSensitiveLog: (obj: DescribeExportImageTasksResult) => any;
}
export interface DescribeExportTasksRequest {
    
    ExportTaskIds?: string[];
    
    Filters?: Filter[];
}
export declare namespace DescribeExportTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeExportTasksRequest) => any;
}
export interface DescribeExportTasksResult {
    
    ExportTasks?: ExportTask[];
}
export declare namespace DescribeExportTasksResult {
    
    const filterSensitiveLog: (obj: DescribeExportTasksResult) => any;
}
export interface DescribeFastSnapshotRestoresRequest {
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeFastSnapshotRestoresRequest {
    
    const filterSensitiveLog: (obj: DescribeFastSnapshotRestoresRequest) => any;
}
export declare type FastSnapshotRestoreStateCode = "disabled" | "disabling" | "enabled" | "enabling" | "optimizing";

export interface DescribeFastSnapshotRestoreSuccessItem {
    
    SnapshotId?: string;
    
    AvailabilityZone?: string;
    
    State?: FastSnapshotRestoreStateCode | string;
    
    StateTransitionReason?: string;
    
    OwnerId?: string;
    
    OwnerAlias?: string;
    
    EnablingTime?: Date;
    
    OptimizingTime?: Date;
    
    EnabledTime?: Date;
    
    DisablingTime?: Date;
    
    DisabledTime?: Date;
}
export declare namespace DescribeFastSnapshotRestoreSuccessItem {
    
    const filterSensitiveLog: (obj: DescribeFastSnapshotRestoreSuccessItem) => any;
}
export interface DescribeFastSnapshotRestoresResult {
    
    FastSnapshotRestores?: DescribeFastSnapshotRestoreSuccessItem[];
    
    NextToken?: string;
}
export declare namespace DescribeFastSnapshotRestoresResult {
    
    const filterSensitiveLog: (obj: DescribeFastSnapshotRestoresResult) => any;
}
export declare enum FleetEventType {
    FLEET_CHANGE = "fleet-change",
    INSTANCE_CHANGE = "instance-change",
    SERVICE_ERROR = "service-error"
}
export interface DescribeFleetHistoryRequest {
    
    DryRun?: boolean;
    
    EventType?: FleetEventType | string;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    FleetId: string | undefined;
    
    StartTime: Date | undefined;
}
export declare namespace DescribeFleetHistoryRequest {
    
    const filterSensitiveLog: (obj: DescribeFleetHistoryRequest) => any;
}

export interface EventInformation {
    
    EventDescription?: string;
    
    EventSubType?: string;
    
    InstanceId?: string;
}
export declare namespace EventInformation {
    
    const filterSensitiveLog: (obj: EventInformation) => any;
}

export interface HistoryRecordEntry {
    
    EventInformation?: EventInformation;
    
    EventType?: FleetEventType | string;
    
    Timestamp?: Date;
}
export declare namespace HistoryRecordEntry {
    
    const filterSensitiveLog: (obj: HistoryRecordEntry) => any;
}
export interface DescribeFleetHistoryResult {
    
    HistoryRecords?: HistoryRecordEntry[];
    
    LastEvaluatedTime?: Date;
    
    NextToken?: string;
    
    FleetId?: string;
    
    StartTime?: Date;
}
export declare namespace DescribeFleetHistoryResult {
    
    const filterSensitiveLog: (obj: DescribeFleetHistoryResult) => any;
}
export interface DescribeFleetInstancesRequest {
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    FleetId: string | undefined;
    
    Filters?: Filter[];
}
export declare namespace DescribeFleetInstancesRequest {
    
    const filterSensitiveLog: (obj: DescribeFleetInstancesRequest) => any;
}
export interface DescribeFleetInstancesResult {
    
    ActiveInstances?: ActiveInstance[];
    
    NextToken?: string;
    
    FleetId?: string;
}
export declare namespace DescribeFleetInstancesResult {
    
    const filterSensitiveLog: (obj: DescribeFleetInstancesResult) => any;
}
export interface DescribeFleetsRequest {
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    FleetIds?: string[];
    
    Filters?: Filter[];
}
export declare namespace DescribeFleetsRequest {
    
    const filterSensitiveLog: (obj: DescribeFleetsRequest) => any;
}
export declare enum FleetActivityStatus {
    ERROR = "error",
    FULFILLED = "fulfilled",
    PENDING_FULFILLMENT = "pending_fulfillment",
    PENDING_TERMINATION = "pending_termination"
}

export interface DescribeFleetError {
    
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    
    Lifecycle?: InstanceLifecycle | string;
    
    ErrorCode?: string;
    
    ErrorMessage?: string;
}
export declare namespace DescribeFleetError {
    
    const filterSensitiveLog: (obj: DescribeFleetError) => any;
}

export interface DescribeFleetsInstances {
    
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    
    Lifecycle?: InstanceLifecycle | string;
    
    InstanceIds?: string[];
    
    InstanceType?: _InstanceType | string;
    
    Platform?: PlatformValues | string;
}
export declare namespace DescribeFleetsInstances {
    
    const filterSensitiveLog: (obj: DescribeFleetsInstances) => any;
}

export interface FleetLaunchTemplateConfig {
    
    LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
    
    Overrides?: FleetLaunchTemplateOverrides[];
}
export declare namespace FleetLaunchTemplateConfig {
    
    const filterSensitiveLog: (obj: FleetLaunchTemplateConfig) => any;
}

export interface CapacityReservationOptions {
    
    UsageStrategy?: FleetCapacityReservationUsageStrategy | string;
}
export declare namespace CapacityReservationOptions {
    
    const filterSensitiveLog: (obj: CapacityReservationOptions) => any;
}

export interface OnDemandOptions {
    
    AllocationStrategy?: FleetOnDemandAllocationStrategy | string;
    
    CapacityReservationOptions?: CapacityReservationOptions;
    
    SingleInstanceType?: boolean;
    
    SingleAvailabilityZone?: boolean;
    
    MinTargetCapacity?: number;
    
    MaxTotalPrice?: string;
}
export declare namespace OnDemandOptions {
    
    const filterSensitiveLog: (obj: OnDemandOptions) => any;
}

export interface FleetSpotCapacityRebalance {
    
    ReplacementStrategy?: FleetReplacementStrategy | string;
    
    TerminationDelay?: number;
}
export declare namespace FleetSpotCapacityRebalance {
    
    const filterSensitiveLog: (obj: FleetSpotCapacityRebalance) => any;
}

export interface FleetSpotMaintenanceStrategies {
    
    CapacityRebalance?: FleetSpotCapacityRebalance;
}
export declare namespace FleetSpotMaintenanceStrategies {
    
    const filterSensitiveLog: (obj: FleetSpotMaintenanceStrategies) => any;
}

export interface SpotOptions {
    
    AllocationStrategy?: SpotAllocationStrategy | string;
    
    MaintenanceStrategies?: FleetSpotMaintenanceStrategies;
    
    InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior | string;
    
    InstancePoolsToUseCount?: number;
    
    SingleInstanceType?: boolean;
    
    SingleAvailabilityZone?: boolean;
    
    MinTargetCapacity?: number;
    
    MaxTotalPrice?: string;
}
export declare namespace SpotOptions {
    
    const filterSensitiveLog: (obj: SpotOptions) => any;
}

export interface TargetCapacitySpecification {
    
    TotalTargetCapacity?: number;
    
    OnDemandTargetCapacity?: number;
    
    SpotTargetCapacity?: number;
    
    DefaultTargetCapacityType?: DefaultTargetCapacityType | string;
    
    TargetCapacityUnitType?: TargetCapacityUnitType | string;
}
export declare namespace TargetCapacitySpecification {
    
    const filterSensitiveLog: (obj: TargetCapacitySpecification) => any;
}

export interface FleetData {
    
    ActivityStatus?: FleetActivityStatus | string;
    
    CreateTime?: Date;
    
    FleetId?: string;
    
    FleetState?: FleetStateCode | string;
    
    ClientToken?: string;
    
    ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy | string;
    
    FulfilledCapacity?: number;
    
    FulfilledOnDemandCapacity?: number;
    
    LaunchTemplateConfigs?: FleetLaunchTemplateConfig[];
    
    TargetCapacitySpecification?: TargetCapacitySpecification;
    
    TerminateInstancesWithExpiration?: boolean;
    
    Type?: FleetType | string;
    
    ValidFrom?: Date;
    
    ValidUntil?: Date;
    
    ReplaceUnhealthyInstances?: boolean;
    
    SpotOptions?: SpotOptions;
    
    OnDemandOptions?: OnDemandOptions;
    
    Tags?: Tag[];
    
    Errors?: DescribeFleetError[];
    
    Instances?: DescribeFleetsInstances[];
    
    Context?: string;
}
export declare namespace FleetData {
    
    const filterSensitiveLog: (obj: FleetData) => any;
}
export interface DescribeFleetsResult {
    
    NextToken?: string;
    
    Fleets?: FleetData[];
}
export declare namespace DescribeFleetsResult {
    
    const filterSensitiveLog: (obj: DescribeFleetsResult) => any;
}
export interface DescribeFlowLogsRequest {
    
    DryRun?: boolean;
    
    Filter?: Filter[];
    
    FlowLogIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeFlowLogsRequest {
    
    const filterSensitiveLog: (obj: DescribeFlowLogsRequest) => any;
}

export interface DestinationOptionsResponse {
    
    FileFormat?: DestinationFileFormat | string;
    
    HiveCompatiblePartitions?: boolean;
    
    PerHourPartition?: boolean;
}
export declare namespace DestinationOptionsResponse {
    
    const filterSensitiveLog: (obj: DestinationOptionsResponse) => any;
}

export interface FlowLog {
    
    CreationTime?: Date;
    
    DeliverLogsErrorMessage?: string;
    
    DeliverLogsPermissionArn?: string;
    
    DeliverLogsStatus?: string;
    
    FlowLogId?: string;
    
    FlowLogStatus?: string;
    
    LogGroupName?: string;
    
    ResourceId?: string;
    
    TrafficType?: TrafficType | string;
    
    LogDestinationType?: LogDestinationType | string;
    
    LogDestination?: string;
    
    LogFormat?: string;
    
    Tags?: Tag[];
    
    MaxAggregationInterval?: number;
    
    DestinationOptions?: DestinationOptionsResponse;
}
export declare namespace FlowLog {
    
    const filterSensitiveLog: (obj: FlowLog) => any;
}
export interface DescribeFlowLogsResult {
    
    FlowLogs?: FlowLog[];
    
    NextToken?: string;
}
export declare namespace DescribeFlowLogsResult {
    
    const filterSensitiveLog: (obj: DescribeFlowLogsResult) => any;
}
export declare type FpgaImageAttributeName = "description" | "loadPermission" | "name" | "productCodes";
export interface DescribeFpgaImageAttributeRequest {
    
    DryRun?: boolean;
    
    FpgaImageId: string | undefined;
    
    Attribute: FpgaImageAttributeName | string | undefined;
}
export declare namespace DescribeFpgaImageAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeFpgaImageAttributeRequest) => any;
}
export declare type PermissionGroup = "all";

export interface LoadPermission {
    
    UserId?: string;
    
    Group?: PermissionGroup | string;
}
export declare namespace LoadPermission {
    
    const filterSensitiveLog: (obj: LoadPermission) => any;
}
export declare type ProductCodeValues = "devpay" | "marketplace";

export interface ProductCode {
    
    ProductCodeId?: string;
    
    ProductCodeType?: ProductCodeValues | string;
}
export declare namespace ProductCode {
    
    const filterSensitiveLog: (obj: ProductCode) => any;
}

export interface FpgaImageAttribute {
    
    FpgaImageId?: string;
    
    Name?: string;
    
    Description?: string;
    
    LoadPermissions?: LoadPermission[];
    
    ProductCodes?: ProductCode[];
}
export declare namespace FpgaImageAttribute {
    
    const filterSensitiveLog: (obj: FpgaImageAttribute) => any;
}
export interface DescribeFpgaImageAttributeResult {
    
    FpgaImageAttribute?: FpgaImageAttribute;
}
export declare namespace DescribeFpgaImageAttributeResult {
    
    const filterSensitiveLog: (obj: DescribeFpgaImageAttributeResult) => any;
}
export interface DescribeFpgaImagesRequest {
    
    DryRun?: boolean;
    
    FpgaImageIds?: string[];
    
    Owners?: string[];
    
    Filters?: Filter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeFpgaImagesRequest {
    
    const filterSensitiveLog: (obj: DescribeFpgaImagesRequest) => any;
}

export interface PciId {
    
    DeviceId?: string;
    
    VendorId?: string;
    
    SubsystemId?: string;
    
    SubsystemVendorId?: string;
}
export declare namespace PciId {
    
    const filterSensitiveLog: (obj: PciId) => any;
}
export declare type FpgaImageStateCode = "available" | "failed" | "pending" | "unavailable";

export interface FpgaImageState {
    
    Code?: FpgaImageStateCode | string;
    
    Message?: string;
}
export declare namespace FpgaImageState {
    
    const filterSensitiveLog: (obj: FpgaImageState) => any;
}

export interface FpgaImage {
    
    FpgaImageId?: string;
    
    FpgaImageGlobalId?: string;
    
    Name?: string;
    
    Description?: string;
    
    ShellVersion?: string;
    
    PciId?: PciId;
    
    State?: FpgaImageState;
    
    CreateTime?: Date;
    
    UpdateTime?: Date;
    
    OwnerId?: string;
    
    OwnerAlias?: string;
    
    ProductCodes?: ProductCode[];
    
    Tags?: Tag[];
    
    Public?: boolean;
    
    DataRetentionSupport?: boolean;
}
export declare namespace FpgaImage {
    
    const filterSensitiveLog: (obj: FpgaImage) => any;
}
export interface DescribeFpgaImagesResult {
    
    FpgaImages?: FpgaImage[];
    
    NextToken?: string;
}
export declare namespace DescribeFpgaImagesResult {
    
    const filterSensitiveLog: (obj: DescribeFpgaImagesResult) => any;
}
export interface DescribeHostReservationOfferingsRequest {
    
    Filter?: Filter[];
    
    MaxDuration?: number;
    
    MaxResults?: number;
    
    MinDuration?: number;
    
    NextToken?: string;
    
    OfferingId?: string;
}
export declare namespace DescribeHostReservationOfferingsRequest {
    
    const filterSensitiveLog: (obj: DescribeHostReservationOfferingsRequest) => any;
}
export declare enum PaymentOption {
    ALL_UPFRONT = "AllUpfront",
    NO_UPFRONT = "NoUpfront",
    PARTIAL_UPFRONT = "PartialUpfront"
}

export interface HostOffering {
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    Duration?: number;
    
    HourlyPrice?: string;
    
    InstanceFamily?: string;
    
    OfferingId?: string;
    
    PaymentOption?: PaymentOption | string;
    
    UpfrontPrice?: string;
}
export declare namespace HostOffering {
    
    const filterSensitiveLog: (obj: HostOffering) => any;
}
export interface DescribeHostReservationOfferingsResult {
    
    NextToken?: string;
    
    OfferingSet?: HostOffering[];
}
export declare namespace DescribeHostReservationOfferingsResult {
    
    const filterSensitiveLog: (obj: DescribeHostReservationOfferingsResult) => any;
}
export interface DescribeHostReservationsRequest {
    
    Filter?: Filter[];
    
    HostReservationIdSet?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeHostReservationsRequest {
    
    const filterSensitiveLog: (obj: DescribeHostReservationsRequest) => any;
}
export declare enum ReservationState {
    ACTIVE = "active",
    PAYMENT_FAILED = "payment-failed",
    PAYMENT_PENDING = "payment-pending",
    RETIRED = "retired"
}

export interface HostReservation {
    
    Count?: number;
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    Duration?: number;
    
    End?: Date;
    
    HostIdSet?: string[];
    
    HostReservationId?: string;
    
    HourlyPrice?: string;
    
    InstanceFamily?: string;
    
    OfferingId?: string;
    
    PaymentOption?: PaymentOption | string;
    
    Start?: Date;
    
    State?: ReservationState | string;
    
    UpfrontPrice?: string;
    
    Tags?: Tag[];
}
export declare namespace HostReservation {
    
    const filterSensitiveLog: (obj: HostReservation) => any;
}
export interface DescribeHostReservationsResult {
    
    HostReservationSet?: HostReservation[];
    
    NextToken?: string;
}
export declare namespace DescribeHostReservationsResult {
    
    const filterSensitiveLog: (obj: DescribeHostReservationsResult) => any;
}
export interface DescribeHostsRequest {
    
    Filter?: Filter[];
    
    HostIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeHostsRequest {
    
    const filterSensitiveLog: (obj: DescribeHostsRequest) => any;
}

export interface InstanceCapacity {
    
    AvailableCapacity?: number;
    
    InstanceType?: string;
    
    TotalCapacity?: number;
}
export declare namespace InstanceCapacity {
    
    const filterSensitiveLog: (obj: InstanceCapacity) => any;
}

export interface AvailableCapacity {
    
    AvailableInstanceCapacity?: InstanceCapacity[];
    
    AvailableVCpus?: number;
}
export declare namespace AvailableCapacity {
    
    const filterSensitiveLog: (obj: AvailableCapacity) => any;
}

export interface HostProperties {
    
    Cores?: number;
    
    InstanceType?: string;
    
    InstanceFamily?: string;
    
    Sockets?: number;
    
    TotalVCpus?: number;
}
export declare namespace HostProperties {
    
    const filterSensitiveLog: (obj: HostProperties) => any;
}

export interface HostInstance {
    
    InstanceId?: string;
    
    InstanceType?: string;
    
    OwnerId?: string;
}
export declare namespace HostInstance {
    
    const filterSensitiveLog: (obj: HostInstance) => any;
}

export interface Host {
    
    AutoPlacement?: AutoPlacement | string;
    
    AvailabilityZone?: string;
    
    AvailableCapacity?: AvailableCapacity;
    
    ClientToken?: string;
    
    HostId?: string;
    
    HostProperties?: HostProperties;
    
    HostReservationId?: string;
    
    Instances?: HostInstance[];
    
    State?: AllocationState | string;
    
    AllocationTime?: Date;
    
    ReleaseTime?: Date;
    
    Tags?: Tag[];
    
    HostRecovery?: HostRecovery | string;
    
    AllowsMultipleInstanceTypes?: AllowsMultipleInstanceTypes | string;
    
    OwnerId?: string;
    
    AvailabilityZoneId?: string;
    
    MemberOfServiceLinkedResourceGroup?: boolean;
}
export declare namespace Host {
    
    const filterSensitiveLog: (obj: Host) => any;
}
export interface DescribeHostsResult {
    
    Hosts?: Host[];
    
    NextToken?: string;
}
export declare namespace DescribeHostsResult {
    
    const filterSensitiveLog: (obj: DescribeHostsResult) => any;
}
export interface DescribeIamInstanceProfileAssociationsRequest {
    
    AssociationIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeIamInstanceProfileAssociationsRequest {
    
    const filterSensitiveLog: (obj: DescribeIamInstanceProfileAssociationsRequest) => any;
}
export interface DescribeIamInstanceProfileAssociationsResult {
    
    IamInstanceProfileAssociations?: IamInstanceProfileAssociation[];
    
    NextToken?: string;
}
export declare namespace DescribeIamInstanceProfileAssociationsResult {
    
    const filterSensitiveLog: (obj: DescribeIamInstanceProfileAssociationsResult) => any;
}
export interface DescribeIdentityIdFormatRequest {
    
    PrincipalArn: string | undefined;
    
    Resource?: string;
}
export declare namespace DescribeIdentityIdFormatRequest {
    
    const filterSensitiveLog: (obj: DescribeIdentityIdFormatRequest) => any;
}
export interface DescribeIdentityIdFormatResult {
    
    Statuses?: IdFormat[];
}
export declare namespace DescribeIdentityIdFormatResult {
    
    const filterSensitiveLog: (obj: DescribeIdentityIdFormatResult) => any;
}
export interface DescribeIdFormatRequest {
    
    Resource?: string;
}
export declare namespace DescribeIdFormatRequest {
    
    const filterSensitiveLog: (obj: DescribeIdFormatRequest) => any;
}
export interface DescribeIdFormatResult {
    
    Statuses?: IdFormat[];
}
export declare namespace DescribeIdFormatResult {
    
    const filterSensitiveLog: (obj: DescribeIdFormatResult) => any;
}
export declare type ImageAttributeName = "blockDeviceMapping" | "bootMode" | "description" | "kernel" | "launchPermission" | "productCodes" | "ramdisk" | "sriovNetSupport";

export interface DescribeImageAttributeRequest {
    
    Attribute: ImageAttributeName | string | undefined;
    
    ImageId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DescribeImageAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeImageAttributeRequest) => any;
}

export interface LaunchPermission {
    
    Group?: PermissionGroup | string;
    
    UserId?: string;
    
    OrganizationArn?: string;
    
    OrganizationalUnitArn?: string;
}
export declare namespace LaunchPermission {
    
    const filterSensitiveLog: (obj: LaunchPermission) => any;
}

export interface ImageAttribute {
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    ImageId?: string;
    
    LaunchPermissions?: LaunchPermission[];
    
    ProductCodes?: ProductCode[];
    
    Description?: AttributeValue;
    
    KernelId?: AttributeValue;
    
    RamdiskId?: AttributeValue;
    
    SriovNetSupport?: AttributeValue;
    
    BootMode?: AttributeValue;
}
export declare namespace ImageAttribute {
    
    const filterSensitiveLog: (obj: ImageAttribute) => any;
}
export interface DescribeImagesRequest {
    
    ExecutableUsers?: string[];
    
    Filters?: Filter[];
    
    ImageIds?: string[];
    
    Owners?: string[];
    
    IncludeDeprecated?: boolean;
    
    DryRun?: boolean;
}
export declare namespace DescribeImagesRequest {
    
    const filterSensitiveLog: (obj: DescribeImagesRequest) => any;
}
export declare type ArchitectureValues = "arm64" | "i386" | "x86_64" | "x86_64_mac";
export declare type BootModeValues = "legacy-bios" | "uefi";
export declare type HypervisorType = "ovm" | "xen";
export declare type ImageTypeValues = "kernel" | "machine" | "ramdisk";
export declare type DeviceType = "ebs" | "instance-store";
export declare type ImageState = "available" | "deregistered" | "error" | "failed" | "invalid" | "pending" | "transient";

export interface StateReason {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace StateReason {
    
    const filterSensitiveLog: (obj: StateReason) => any;
}
export declare type VirtualizationType = "hvm" | "paravirtual";

export interface Image {
    
    Architecture?: ArchitectureValues | string;
    
    CreationDate?: string;
    
    ImageId?: string;
    
    ImageLocation?: string;
    
    ImageType?: ImageTypeValues | string;
    
    Public?: boolean;
    
    KernelId?: string;
    
    OwnerId?: string;
    
    Platform?: PlatformValues | string;
    
    PlatformDetails?: string;
    
    UsageOperation?: string;
    
    ProductCodes?: ProductCode[];
    
    RamdiskId?: string;
    
    State?: ImageState | string;
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    Description?: string;
    
    EnaSupport?: boolean;
    
    Hypervisor?: HypervisorType | string;
    
    ImageOwnerAlias?: string;
    
    Name?: string;
    
    RootDeviceName?: string;
    
    RootDeviceType?: DeviceType | string;
    
    SriovNetSupport?: string;
    
    StateReason?: StateReason;
    
    Tags?: Tag[];
    
    VirtualizationType?: VirtualizationType | string;
    
    BootMode?: BootModeValues | string;
    
    DeprecationTime?: string;
}
export declare namespace Image {
    
    const filterSensitiveLog: (obj: Image) => any;
}
export interface DescribeImagesResult {
    
    Images?: Image[];
}
export declare namespace DescribeImagesResult {
    
    const filterSensitiveLog: (obj: DescribeImagesResult) => any;
}
export interface DescribeImportImageTasksRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    ImportTaskIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeImportImageTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeImportImageTasksRequest) => any;
}

export interface ImportImageLicenseConfigurationResponse {
    
    LicenseConfigurationArn?: string;
}
export declare namespace ImportImageLicenseConfigurationResponse {
    
    const filterSensitiveLog: (obj: ImportImageLicenseConfigurationResponse) => any;
}

export interface UserBucketDetails {
    
    S3Bucket?: string;
    
    S3Key?: string;
}
export declare namespace UserBucketDetails {
    
    const filterSensitiveLog: (obj: UserBucketDetails) => any;
}

export interface SnapshotDetail {
    
    Description?: string;
    
    DeviceName?: string;
    
    DiskImageSize?: number;
    
    Format?: string;
    
    Progress?: string;
    
    SnapshotId?: string;
    
    Status?: string;
    
    StatusMessage?: string;
    
    Url?: string;
    
    UserBucket?: UserBucketDetails;
}
export declare namespace SnapshotDetail {
    
    const filterSensitiveLog: (obj: SnapshotDetail) => any;
}

export interface ImportImageTask {
    
    Architecture?: string;
    
    Description?: string;
    
    Encrypted?: boolean;
    
    Hypervisor?: string;
    
    ImageId?: string;
    
    ImportTaskId?: string;
    
    KmsKeyId?: string;
    
    LicenseType?: string;
    
    Platform?: string;
    
    Progress?: string;
    
    SnapshotDetails?: SnapshotDetail[];
    
    Status?: string;
    
    StatusMessage?: string;
    
    Tags?: Tag[];
    
    LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
    
    UsageOperation?: string;
    
    BootMode?: BootModeValues | string;
}
export declare namespace ImportImageTask {
    
    const filterSensitiveLog: (obj: ImportImageTask) => any;
}
export interface DescribeImportImageTasksResult {
    
    ImportImageTasks?: ImportImageTask[];
    
    NextToken?: string;
}
export declare namespace DescribeImportImageTasksResult {
    
    const filterSensitiveLog: (obj: DescribeImportImageTasksResult) => any;
}
export interface DescribeImportSnapshotTasksRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    ImportTaskIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeImportSnapshotTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeImportSnapshotTasksRequest) => any;
}

export interface SnapshotTaskDetail {
    
    Description?: string;
    
    DiskImageSize?: number;
    
    Encrypted?: boolean;
    
    Format?: string;
    
    KmsKeyId?: string;
    
    Progress?: string;
    
    SnapshotId?: string;
    
    Status?: string;
    
    StatusMessage?: string;
    
    Url?: string;
    
    UserBucket?: UserBucketDetails;
}
export declare namespace SnapshotTaskDetail {
    
    const filterSensitiveLog: (obj: SnapshotTaskDetail) => any;
}

export interface ImportSnapshotTask {
    
    Description?: string;
    
    ImportTaskId?: string;
    
    SnapshotTaskDetail?: SnapshotTaskDetail;
    
    Tags?: Tag[];
}
export declare namespace ImportSnapshotTask {
    
    const filterSensitiveLog: (obj: ImportSnapshotTask) => any;
}
export interface DescribeImportSnapshotTasksResult {
    
    ImportSnapshotTasks?: ImportSnapshotTask[];
    
    NextToken?: string;
}
export declare namespace DescribeImportSnapshotTasksResult {
    
    const filterSensitiveLog: (obj: DescribeImportSnapshotTasksResult) => any;
}
export declare type InstanceAttributeName = "blockDeviceMapping" | "disableApiTermination" | "ebsOptimized" | "enaSupport" | "enclaveOptions" | "groupSet" | "instanceInitiatedShutdownBehavior" | "instanceType" | "kernel" | "productCodes" | "ramdisk" | "rootDeviceName" | "sourceDestCheck" | "sriovNetSupport" | "userData";
export interface DescribeInstanceAttributeRequest {
    
    Attribute: InstanceAttributeName | string | undefined;
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
}
export declare namespace DescribeInstanceAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceAttributeRequest) => any;
}

export interface EbsInstanceBlockDevice {
    
    AttachTime?: Date;
    
    DeleteOnTermination?: boolean;
    
    Status?: AttachmentStatus | string;
    
    VolumeId?: string;
}
export declare namespace EbsInstanceBlockDevice {
    
    const filterSensitiveLog: (obj: EbsInstanceBlockDevice) => any;
}

export interface InstanceBlockDeviceMapping {
    
    DeviceName?: string;
    
    Ebs?: EbsInstanceBlockDevice;
}
export declare namespace InstanceBlockDeviceMapping {
    
    const filterSensitiveLog: (obj: InstanceBlockDeviceMapping) => any;
}

export interface AttributeBooleanValue {
    
    Value?: boolean;
}
export declare namespace AttributeBooleanValue {
    
    const filterSensitiveLog: (obj: AttributeBooleanValue) => any;
}

export interface EnclaveOptions {
    
    Enabled?: boolean;
}
export declare namespace EnclaveOptions {
    
    const filterSensitiveLog: (obj: EnclaveOptions) => any;
}

export interface InstanceAttribute {
    
    Groups?: GroupIdentifier[];
    
    BlockDeviceMappings?: InstanceBlockDeviceMapping[];
    
    DisableApiTermination?: AttributeBooleanValue;
    
    EnaSupport?: AttributeBooleanValue;
    
    EnclaveOptions?: EnclaveOptions;
    
    EbsOptimized?: AttributeBooleanValue;
    
    InstanceId?: string;
    
    InstanceInitiatedShutdownBehavior?: AttributeValue;
    
    InstanceType?: AttributeValue;
    
    KernelId?: AttributeValue;
    
    ProductCodes?: ProductCode[];
    
    RamdiskId?: AttributeValue;
    
    RootDeviceName?: AttributeValue;
    
    SourceDestCheck?: AttributeBooleanValue;
    
    SriovNetSupport?: AttributeValue;
    
    UserData?: AttributeValue;
}
export declare namespace InstanceAttribute {
    
    const filterSensitiveLog: (obj: InstanceAttribute) => any;
}
export interface DescribeInstanceCreditSpecificationsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    InstanceIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeInstanceCreditSpecificationsRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceCreditSpecificationsRequest) => any;
}

export interface InstanceCreditSpecification {
    
    InstanceId?: string;
    
    CpuCredits?: string;
}
export declare namespace InstanceCreditSpecification {
    
    const filterSensitiveLog: (obj: InstanceCreditSpecification) => any;
}
export interface DescribeInstanceCreditSpecificationsResult {
    
    InstanceCreditSpecifications?: InstanceCreditSpecification[];
    
    NextToken?: string;
}
export declare namespace DescribeInstanceCreditSpecificationsResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceCreditSpecificationsResult) => any;
}
export interface DescribeInstanceEventNotificationAttributesRequest {
    
    DryRun?: boolean;
}
export declare namespace DescribeInstanceEventNotificationAttributesRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceEventNotificationAttributesRequest) => any;
}
export interface DescribeInstanceEventNotificationAttributesResult {
    
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export declare namespace DescribeInstanceEventNotificationAttributesResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceEventNotificationAttributesResult) => any;
}

export interface DescribeInstanceEventWindowsRequest {
    
    DryRun?: boolean;
    
    InstanceEventWindowIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeInstanceEventWindowsRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceEventWindowsRequest) => any;
}
export interface DescribeInstanceEventWindowsResult {
    
    InstanceEventWindows?: InstanceEventWindow[];
    
    NextToken?: string;
}
export declare namespace DescribeInstanceEventWindowsResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceEventWindowsResult) => any;
}
export interface DescribeInstancesRequest {
    
    Filters?: Filter[];
    
    InstanceIds?: string[];
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeInstancesRequest {
    
    const filterSensitiveLog: (obj: DescribeInstancesRequest) => any;
}

export interface CapacityReservationSpecificationResponse {
    
    CapacityReservationPreference?: CapacityReservationPreference | string;
    
    CapacityReservationTarget?: CapacityReservationTargetResponse;
}
export declare namespace CapacityReservationSpecificationResponse {
    
    const filterSensitiveLog: (obj: CapacityReservationSpecificationResponse) => any;
}

export interface CpuOptions {
    
    CoreCount?: number;
    
    ThreadsPerCore?: number;
}
export declare namespace CpuOptions {
    
    const filterSensitiveLog: (obj: CpuOptions) => any;
}

export interface ElasticGpuAssociation {
    
    ElasticGpuId?: string;
    
    ElasticGpuAssociationId?: string;
    
    ElasticGpuAssociationState?: string;
    
    ElasticGpuAssociationTime?: string;
}
export declare namespace ElasticGpuAssociation {
    
    const filterSensitiveLog: (obj: ElasticGpuAssociation) => any;
}

export interface ElasticInferenceAcceleratorAssociation {
    
    ElasticInferenceAcceleratorArn?: string;
    
    ElasticInferenceAcceleratorAssociationId?: string;
    
    ElasticInferenceAcceleratorAssociationState?: string;
    
    ElasticInferenceAcceleratorAssociationTime?: Date;
}
export declare namespace ElasticInferenceAcceleratorAssociation {
    
    const filterSensitiveLog: (obj: ElasticInferenceAcceleratorAssociation) => any;
}

export interface HibernationOptions {
    
    Configured?: boolean;
}
export declare namespace HibernationOptions {
    
    const filterSensitiveLog: (obj: HibernationOptions) => any;
}
export declare type InstanceLifecycleType = "scheduled" | "spot";

export interface LicenseConfiguration {
    
    LicenseConfigurationArn?: string;
}
export declare namespace LicenseConfiguration {
    
    const filterSensitiveLog: (obj: LicenseConfiguration) => any;
}
export declare type InstanceMetadataEndpointState = "disabled" | "enabled";
export declare enum InstanceMetadataProtocolState {
    disabled = "disabled",
    enabled = "enabled"
}
export declare enum HttpTokensState {
    optional = "optional",
    required = "required"
}
export declare type InstanceMetadataOptionsState = "applied" | "pending";

export interface InstanceMetadataOptionsResponse {
    
    State?: InstanceMetadataOptionsState | string;
    
    HttpTokens?: HttpTokensState | string;
    
    HttpPutResponseHopLimit?: number;
    
    HttpEndpoint?: InstanceMetadataEndpointState | string;
    
    HttpProtocolIpv6?: InstanceMetadataProtocolState | string;
}
export declare namespace InstanceMetadataOptionsResponse {
    
    const filterSensitiveLog: (obj: InstanceMetadataOptionsResponse) => any;
}
export declare type MonitoringState = "disabled" | "disabling" | "enabled" | "pending";

export interface Monitoring {
    
    State?: MonitoringState | string;
}
export declare namespace Monitoring {
    
    const filterSensitiveLog: (obj: Monitoring) => any;
}

export interface InstanceNetworkInterfaceAssociation {
    
    CarrierIp?: string;
    
    CustomerOwnedIp?: string;
    
    IpOwnerId?: string;
    
    PublicDnsName?: string;
    
    PublicIp?: string;
}
export declare namespace InstanceNetworkInterfaceAssociation {
    
    const filterSensitiveLog: (obj: InstanceNetworkInterfaceAssociation) => any;
}

export interface InstanceNetworkInterfaceAttachment {
    
    AttachTime?: Date;
    
    AttachmentId?: string;
    
    DeleteOnTermination?: boolean;
    
    DeviceIndex?: number;
    
    Status?: AttachmentStatus | string;
    
    NetworkCardIndex?: number;
}
export declare namespace InstanceNetworkInterfaceAttachment {
    
    const filterSensitiveLog: (obj: InstanceNetworkInterfaceAttachment) => any;
}

export interface InstanceIpv4Prefix {
    
    Ipv4Prefix?: string;
}
export declare namespace InstanceIpv4Prefix {
    
    const filterSensitiveLog: (obj: InstanceIpv4Prefix) => any;
}

export interface InstanceIpv6Prefix {
    
    Ipv6Prefix?: string;
}
export declare namespace InstanceIpv6Prefix {
    
    const filterSensitiveLog: (obj: InstanceIpv6Prefix) => any;
}

export interface InstancePrivateIpAddress {
    
    Association?: InstanceNetworkInterfaceAssociation;
    
    Primary?: boolean;
    
    PrivateDnsName?: string;
    
    PrivateIpAddress?: string;
}
export declare namespace InstancePrivateIpAddress {
    
    const filterSensitiveLog: (obj: InstancePrivateIpAddress) => any;
}

export interface InstanceNetworkInterface {
    
    Association?: InstanceNetworkInterfaceAssociation;
    
    Attachment?: InstanceNetworkInterfaceAttachment;
    
    Description?: string;
    
    Groups?: GroupIdentifier[];
    
    Ipv6Addresses?: InstanceIpv6Address[];
    
    MacAddress?: string;
    
    NetworkInterfaceId?: string;
    
    OwnerId?: string;
    
    PrivateDnsName?: string;
    
    PrivateIpAddress?: string;
    
    PrivateIpAddresses?: InstancePrivateIpAddress[];
    
    SourceDestCheck?: boolean;
    
    Status?: NetworkInterfaceStatus | string;
    
    SubnetId?: string;
    
    VpcId?: string;
    
    InterfaceType?: string;
    
    Ipv4Prefixes?: InstanceIpv4Prefix[];
    
    Ipv6Prefixes?: InstanceIpv6Prefix[];
}
export declare namespace InstanceNetworkInterface {
    
    const filterSensitiveLog: (obj: InstanceNetworkInterface) => any;
}

export interface PrivateDnsNameOptionsResponse {
    
    HostnameType?: HostnameType | string;
    
    EnableResourceNameDnsARecord?: boolean;
    
    EnableResourceNameDnsAAAARecord?: boolean;
}
export declare namespace PrivateDnsNameOptionsResponse {
    
    const filterSensitiveLog: (obj: PrivateDnsNameOptionsResponse) => any;
}
export declare type InstanceStateName = "pending" | "running" | "shutting-down" | "stopped" | "stopping" | "terminated";

export interface InstanceState {
    
    Code?: number;
    
    Name?: InstanceStateName | string;
}
export declare namespace InstanceState {
    
    const filterSensitiveLog: (obj: InstanceState) => any;
}

export interface Instance {
    
    AmiLaunchIndex?: number;
    
    ImageId?: string;
    
    InstanceId?: string;
    
    InstanceType?: _InstanceType | string;
    
    KernelId?: string;
    
    KeyName?: string;
    
    LaunchTime?: Date;
    
    Monitoring?: Monitoring;
    
    Placement?: Placement;
    
    Platform?: PlatformValues | string;
    
    PrivateDnsName?: string;
    
    PrivateIpAddress?: string;
    
    ProductCodes?: ProductCode[];
    
    PublicDnsName?: string;
    
    PublicIpAddress?: string;
    
    RamdiskId?: string;
    
    State?: InstanceState;
    
    StateTransitionReason?: string;
    
    SubnetId?: string;
    
    VpcId?: string;
    
    Architecture?: ArchitectureValues | string;
    
    BlockDeviceMappings?: InstanceBlockDeviceMapping[];
    
    ClientToken?: string;
    
    EbsOptimized?: boolean;
    
    EnaSupport?: boolean;
    
    Hypervisor?: HypervisorType | string;
    
    IamInstanceProfile?: IamInstanceProfile;
    
    InstanceLifecycle?: InstanceLifecycleType | string;
    
    ElasticGpuAssociations?: ElasticGpuAssociation[];
    
    ElasticInferenceAcceleratorAssociations?: ElasticInferenceAcceleratorAssociation[];
    
    NetworkInterfaces?: InstanceNetworkInterface[];
    
    OutpostArn?: string;
    
    RootDeviceName?: string;
    
    RootDeviceType?: DeviceType | string;
    
    SecurityGroups?: GroupIdentifier[];
    
    SourceDestCheck?: boolean;
    
    SpotInstanceRequestId?: string;
    
    SriovNetSupport?: string;
    
    StateReason?: StateReason;
    
    Tags?: Tag[];
    
    VirtualizationType?: VirtualizationType | string;
    
    CpuOptions?: CpuOptions;
    
    CapacityReservationId?: string;
    
    CapacityReservationSpecification?: CapacityReservationSpecificationResponse;
    
    HibernationOptions?: HibernationOptions;
    
    Licenses?: LicenseConfiguration[];
    
    MetadataOptions?: InstanceMetadataOptionsResponse;
    
    EnclaveOptions?: EnclaveOptions;
    
    BootMode?: BootModeValues | string;
    
    PlatformDetails?: string;
    
    UsageOperation?: string;
    
    UsageOperationUpdateTime?: Date;
    
    PrivateDnsNameOptions?: PrivateDnsNameOptionsResponse;
    
    Ipv6Address?: string;
}
export declare namespace Instance {
    
    const filterSensitiveLog: (obj: Instance) => any;
}

export interface Reservation {
    
    Groups?: GroupIdentifier[];
    
    Instances?: Instance[];
    
    OwnerId?: string;
    
    RequesterId?: string;
    
    ReservationId?: string;
}
export declare namespace Reservation {
    
    const filterSensitiveLog: (obj: Reservation) => any;
}
export interface DescribeInstancesResult {
    
    Reservations?: Reservation[];
    
    NextToken?: string;
}
export declare namespace DescribeInstancesResult {
    
    const filterSensitiveLog: (obj: DescribeInstancesResult) => any;
}
export interface DescribeInstanceStatusRequest {
    
    Filters?: Filter[];
    
    InstanceIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
    
    IncludeAllInstances?: boolean;
}
export declare namespace DescribeInstanceStatusRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceStatusRequest) => any;
}
export declare type EventCode = "instance-reboot" | "instance-retirement" | "instance-stop" | "system-maintenance" | "system-reboot";

export interface InstanceStatusEvent {
    
    InstanceEventId?: string;
    
    Code?: EventCode | string;
    
    Description?: string;
    
    NotAfter?: Date;
    
    NotBefore?: Date;
    
    NotBeforeDeadline?: Date;
}
export declare namespace InstanceStatusEvent {
    
    const filterSensitiveLog: (obj: InstanceStatusEvent) => any;
}
export declare type StatusName = "reachability";
export declare type StatusType = "failed" | "initializing" | "insufficient-data" | "passed";

export interface InstanceStatusDetails {
    
    ImpairedSince?: Date;
    
    Name?: StatusName | string;
    
    Status?: StatusType | string;
}
export declare namespace InstanceStatusDetails {
    
    const filterSensitiveLog: (obj: InstanceStatusDetails) => any;
}
export declare type SummaryStatus = "impaired" | "initializing" | "insufficient-data" | "not-applicable" | "ok";

export interface InstanceStatusSummary {
    
    Details?: InstanceStatusDetails[];
    
    Status?: SummaryStatus | string;
}
export declare namespace InstanceStatusSummary {
    
    const filterSensitiveLog: (obj: InstanceStatusSummary) => any;
}

export interface InstanceStatus {
    
    AvailabilityZone?: string;
    
    OutpostArn?: string;
    
    Events?: InstanceStatusEvent[];
    
    InstanceId?: string;
    
    InstanceState?: InstanceState;
    
    InstanceStatus?: InstanceStatusSummary;
    
    SystemStatus?: InstanceStatusSummary;
}
export declare namespace InstanceStatus {
    
    const filterSensitiveLog: (obj: InstanceStatus) => any;
}
export interface DescribeInstanceStatusResult {
    
    InstanceStatuses?: InstanceStatus[];
    
    NextToken?: string;
}
export declare namespace DescribeInstanceStatusResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceStatusResult) => any;
}
export declare type LocationType = "availability-zone" | "availability-zone-id" | "region";
export interface DescribeInstanceTypeOfferingsRequest {
    
    DryRun?: boolean;
    
    LocationType?: LocationType | string;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeInstanceTypeOfferingsRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceTypeOfferingsRequest) => any;
}

export interface InstanceTypeOffering {
    
    InstanceType?: _InstanceType | string;
    
    LocationType?: LocationType | string;
    
    Location?: string;
}
export declare namespace InstanceTypeOffering {
    
    const filterSensitiveLog: (obj: InstanceTypeOffering) => any;
}
export interface DescribeInstanceTypeOfferingsResult {
    
    InstanceTypeOfferings?: InstanceTypeOffering[];
    
    NextToken?: string;
}
export declare namespace DescribeInstanceTypeOfferingsResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceTypeOfferingsResult) => any;
}
export interface DescribeInstanceTypesRequest {
    
    DryRun?: boolean;
    
    InstanceTypes?: (_InstanceType | string)[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeInstanceTypesRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceTypesRequest) => any;
}

export interface EbsOptimizedInfo {
    
    BaselineBandwidthInMbps?: number;
    
    BaselineThroughputInMBps?: number;
    
    BaselineIops?: number;
    
    MaximumBandwidthInMbps?: number;
    
    MaximumThroughputInMBps?: number;
    
    MaximumIops?: number;
}
export declare namespace EbsOptimizedInfo {
    
    const filterSensitiveLog: (obj: EbsOptimizedInfo) => any;
}
export declare type EbsOptimizedSupport = "default" | "supported" | "unsupported";
export declare type EbsEncryptionSupport = "supported" | "unsupported";
export declare enum EbsNvmeSupport {
    REQUIRED = "required",
    SUPPORTED = "supported",
    UNSUPPORTED = "unsupported"
}

export interface EbsInfo {
    
    EbsOptimizedSupport?: EbsOptimizedSupport | string;
    
    EncryptionSupport?: EbsEncryptionSupport | string;
    
    EbsOptimizedInfo?: EbsOptimizedInfo;
    
    NvmeSupport?: EbsNvmeSupport | string;
}
export declare namespace EbsInfo {
    
    const filterSensitiveLog: (obj: EbsInfo) => any;
}

export interface FpgaDeviceMemoryInfo {
    
    SizeInMiB?: number;
}
export declare namespace FpgaDeviceMemoryInfo {
    
    const filterSensitiveLog: (obj: FpgaDeviceMemoryInfo) => any;
}

export interface FpgaDeviceInfo {
    
    Name?: string;
    
    Manufacturer?: string;
    
    Count?: number;
    
    MemoryInfo?: FpgaDeviceMemoryInfo;
}
export declare namespace FpgaDeviceInfo {
    
    const filterSensitiveLog: (obj: FpgaDeviceInfo) => any;
}

export interface FpgaInfo {
    
    Fpgas?: FpgaDeviceInfo[];
    
    TotalFpgaMemoryInMiB?: number;
}
export declare namespace FpgaInfo {
    
    const filterSensitiveLog: (obj: FpgaInfo) => any;
}

export interface GpuDeviceMemoryInfo {
    
    SizeInMiB?: number;
}
export declare namespace GpuDeviceMemoryInfo {
    
    const filterSensitiveLog: (obj: GpuDeviceMemoryInfo) => any;
}

export interface GpuDeviceInfo {
    
    Name?: string;
    
    Manufacturer?: string;
    
    Count?: number;
    
    MemoryInfo?: GpuDeviceMemoryInfo;
}
export declare namespace GpuDeviceInfo {
    
    const filterSensitiveLog: (obj: GpuDeviceInfo) => any;
}

export interface GpuInfo {
    
    Gpus?: GpuDeviceInfo[];
    
    TotalGpuMemoryInMiB?: number;
}
export declare namespace GpuInfo {
    
    const filterSensitiveLog: (obj: GpuInfo) => any;
}
export declare enum InstanceTypeHypervisor {
    NITRO = "nitro",
    XEN = "xen"
}

export interface InferenceDeviceInfo {
    
    Count?: number;
    
    Name?: string;
    
    Manufacturer?: string;
}
export declare namespace InferenceDeviceInfo {
    
    const filterSensitiveLog: (obj: InferenceDeviceInfo) => any;
}

export interface InferenceAcceleratorInfo {
    
    Accelerators?: InferenceDeviceInfo[];
}
export declare namespace InferenceAcceleratorInfo {
    
    const filterSensitiveLog: (obj: InferenceAcceleratorInfo) => any;
}
export declare type DiskType = "hdd" | "ssd";

export interface DiskInfo {
    
    SizeInGB?: number;
    
    Count?: number;
    
    Type?: DiskType | string;
}
export declare namespace DiskInfo {
    
    const filterSensitiveLog: (obj: DiskInfo) => any;
}
export declare enum InstanceStorageEncryptionSupport {
    required = "required",
    unsupported = "unsupported"
}
export declare enum EphemeralNvmeSupport {
    REQUIRED = "required",
    SUPPORTED = "supported",
    UNSUPPORTED = "unsupported"
}

export interface InstanceStorageInfo {
    
    TotalSizeInGB?: number;
    
    Disks?: DiskInfo[];
    
    NvmeSupport?: EphemeralNvmeSupport | string;
    
    EncryptionSupport?: InstanceStorageEncryptionSupport | string;
}
export declare namespace InstanceStorageInfo {
    
    const filterSensitiveLog: (obj: InstanceStorageInfo) => any;
}

export interface MemoryInfo {
    
    SizeInMiB?: number;
}
export declare namespace MemoryInfo {
    
    const filterSensitiveLog: (obj: MemoryInfo) => any;
}

export interface EfaInfo {
    
    MaximumEfaInterfaces?: number;
}
export declare namespace EfaInfo {
    
    const filterSensitiveLog: (obj: EfaInfo) => any;
}
export declare type EnaSupport = "required" | "supported" | "unsupported";

export interface NetworkCardInfo {
    
    NetworkCardIndex?: number;
    
    NetworkPerformance?: string;
    
    MaximumNetworkInterfaces?: number;
}
export declare namespace NetworkCardInfo {
    
    const filterSensitiveLog: (obj: NetworkCardInfo) => any;
}

export interface NetworkInfo {
    
    NetworkPerformance?: string;
    
    MaximumNetworkInterfaces?: number;
    
    MaximumNetworkCards?: number;
    
    DefaultNetworkCardIndex?: number;
    
    NetworkCards?: NetworkCardInfo[];
    
    Ipv4AddressesPerInterface?: number;
    
    Ipv6AddressesPerInterface?: number;
    
    Ipv6Supported?: boolean;
    
    EnaSupport?: EnaSupport | string;
    
    EfaSupported?: boolean;
    
    EfaInfo?: EfaInfo;
    
    EncryptionInTransitSupported?: boolean;
}
export declare namespace NetworkInfo {
    
    const filterSensitiveLog: (obj: NetworkInfo) => any;
}
export declare type PlacementGroupStrategy = "cluster" | "partition" | "spread";

export interface PlacementGroupInfo {
    
    SupportedStrategies?: (PlacementGroupStrategy | string)[];
}
export declare namespace PlacementGroupInfo {
    
    const filterSensitiveLog: (obj: PlacementGroupInfo) => any;
}
export declare type ArchitectureType = "arm64" | "i386" | "x86_64" | "x86_64_mac";

export interface ProcessorInfo {
    
    SupportedArchitectures?: (ArchitectureType | string)[];
    
    SustainedClockSpeedInGhz?: number;
}
export declare namespace ProcessorInfo {
    
    const filterSensitiveLog: (obj: ProcessorInfo) => any;
}
export declare type BootModeType = "legacy-bios" | "uefi";
export declare type RootDeviceType = "ebs" | "instance-store";
export declare type UsageClassType = "on-demand" | "spot";

export interface VCpuInfo {
    
    DefaultVCpus?: number;
    
    DefaultCores?: number;
    
    DefaultThreadsPerCore?: number;
    
    ValidCores?: number[];
    
    ValidThreadsPerCore?: number[];
}
export declare namespace VCpuInfo {
    
    const filterSensitiveLog: (obj: VCpuInfo) => any;
}

export interface InstanceTypeInfo {
    
    InstanceType?: _InstanceType | string;
    
    CurrentGeneration?: boolean;
    
    FreeTierEligible?: boolean;
    
    SupportedUsageClasses?: (UsageClassType | string)[];
    
    SupportedRootDeviceTypes?: (RootDeviceType | string)[];
    
    SupportedVirtualizationTypes?: (VirtualizationType | string)[];
    
    BareMetal?: boolean;
    
    Hypervisor?: InstanceTypeHypervisor | string;
    
    ProcessorInfo?: ProcessorInfo;
    
    VCpuInfo?: VCpuInfo;
    
    MemoryInfo?: MemoryInfo;
    
    InstanceStorageSupported?: boolean;
    
    InstanceStorageInfo?: InstanceStorageInfo;
    
    EbsInfo?: EbsInfo;
    
    NetworkInfo?: NetworkInfo;
    
    GpuInfo?: GpuInfo;
    
    FpgaInfo?: FpgaInfo;
    
    PlacementGroupInfo?: PlacementGroupInfo;
    
    InferenceAcceleratorInfo?: InferenceAcceleratorInfo;
    
    HibernationSupported?: boolean;
    
    BurstablePerformanceSupported?: boolean;
    
    DedicatedHostsSupported?: boolean;
    
    AutoRecoverySupported?: boolean;
    
    SupportedBootModes?: (BootModeType | string)[];
}
export declare namespace InstanceTypeInfo {
    
    const filterSensitiveLog: (obj: InstanceTypeInfo) => any;
}
export interface DescribeInstanceTypesResult {
    
    InstanceTypes?: InstanceTypeInfo[];
    
    NextToken?: string;
}
export declare namespace DescribeInstanceTypesResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceTypesResult) => any;
}
export interface DescribeInternetGatewaysRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    InternetGatewayIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeInternetGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeInternetGatewaysRequest) => any;
}
export interface DescribeInternetGatewaysResult {
    
    InternetGateways?: InternetGateway[];
    
    NextToken?: string;
}
export declare namespace DescribeInternetGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeInternetGatewaysResult) => any;
}
export interface DescribeIpamPoolsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    IpamPoolIds?: string[];
}
export declare namespace DescribeIpamPoolsRequest {
    
    const filterSensitiveLog: (obj: DescribeIpamPoolsRequest) => any;
}
export interface DescribeIpamPoolsResult {
    
    NextToken?: string;
    
    IpamPools?: IpamPool[];
}
export declare namespace DescribeIpamPoolsResult {
    
    const filterSensitiveLog: (obj: DescribeIpamPoolsResult) => any;
}
export interface DescribeIpamsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    IpamIds?: string[];
}
export declare namespace DescribeIpamsRequest {
    
    const filterSensitiveLog: (obj: DescribeIpamsRequest) => any;
}
export interface DescribeIpamsResult {
    
    NextToken?: string;
    
    Ipams?: Ipam[];
}
export declare namespace DescribeIpamsResult {
    
    const filterSensitiveLog: (obj: DescribeIpamsResult) => any;
}
export interface DescribeIpamScopesRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    IpamScopeIds?: string[];
}
export declare namespace DescribeIpamScopesRequest {
    
    const filterSensitiveLog: (obj: DescribeIpamScopesRequest) => any;
}
export interface DescribeIpamScopesResult {
    
    NextToken?: string;
    
    IpamScopes?: IpamScope[];
}
export declare namespace DescribeIpamScopesResult {
    
    const filterSensitiveLog: (obj: DescribeIpamScopesResult) => any;
}
export interface DescribeIpv6PoolsRequest {
    
    PoolIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
    
    DryRun?: boolean;
    
    Filters?: Filter[];
}
export declare namespace DescribeIpv6PoolsRequest {
    
    const filterSensitiveLog: (obj: DescribeIpv6PoolsRequest) => any;
}

export interface PoolCidrBlock {
    
    Cidr?: string;
}
export declare namespace PoolCidrBlock {
    
    const filterSensitiveLog: (obj: PoolCidrBlock) => any;
}

export interface Ipv6Pool {
    
    PoolId?: string;
    
    Description?: string;
    
    PoolCidrBlocks?: PoolCidrBlock[];
    
    Tags?: Tag[];
}
export declare namespace Ipv6Pool {
    
    const filterSensitiveLog: (obj: Ipv6Pool) => any;
}
export interface DescribeIpv6PoolsResult {
    
    Ipv6Pools?: Ipv6Pool[];
    
    NextToken?: string;
}
export declare namespace DescribeIpv6PoolsResult {
    
    const filterSensitiveLog: (obj: DescribeIpv6PoolsResult) => any;
}
export interface DescribeKeyPairsRequest {
    
    Filters?: Filter[];
    
    KeyNames?: string[];
    
    KeyPairIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DescribeKeyPairsRequest {
    
    const filterSensitiveLog: (obj: DescribeKeyPairsRequest) => any;
}

export interface KeyPairInfo {
    
    KeyPairId?: string;
    
    KeyFingerprint?: string;
    
    KeyName?: string;
    
    KeyType?: KeyType | string;
    
    Tags?: Tag[];
}
export declare namespace KeyPairInfo {
    
    const filterSensitiveLog: (obj: KeyPairInfo) => any;
}
export interface DescribeKeyPairsResult {
    
    KeyPairs?: KeyPairInfo[];
}
export declare namespace DescribeKeyPairsResult {
    
    const filterSensitiveLog: (obj: DescribeKeyPairsResult) => any;
}
export interface DescribeLaunchTemplatesRequest {
    
    DryRun?: boolean;
    
    LaunchTemplateIds?: string[];
    
    LaunchTemplateNames?: string[];
    
    Filters?: Filter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeLaunchTemplatesRequest {
    
    const filterSensitiveLog: (obj: DescribeLaunchTemplatesRequest) => any;
}
export interface DescribeLaunchTemplatesResult {
    
    LaunchTemplates?: LaunchTemplate[];
    
    NextToken?: string;
}
export declare namespace DescribeLaunchTemplatesResult {
    
    const filterSensitiveLog: (obj: DescribeLaunchTemplatesResult) => any;
}
export interface DescribeLaunchTemplateVersionsRequest {
    
    DryRun?: boolean;
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    Versions?: string[];
    
    MinVersion?: string;
    
    MaxVersion?: string;
    
    NextToken?: string;
    
    MaxResults?: number;
    
    Filters?: Filter[];
}
export declare namespace DescribeLaunchTemplateVersionsRequest {
    
    const filterSensitiveLog: (obj: DescribeLaunchTemplateVersionsRequest) => any;
}
export interface DescribeLaunchTemplateVersionsResult {
    
    LaunchTemplateVersions?: LaunchTemplateVersion[];
    
    NextToken?: string;
}
export declare namespace DescribeLaunchTemplateVersionsResult {
    
    const filterSensitiveLog: (obj: DescribeLaunchTemplateVersionsResult) => any;
}
export interface DescribeLocalGatewayRouteTablesRequest {
    
    LocalGatewayRouteTableIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeLocalGatewayRouteTablesRequest {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayRouteTablesRequest) => any;
}

export interface LocalGatewayRouteTable {
    
    LocalGatewayRouteTableId?: string;
    
    LocalGatewayRouteTableArn?: string;
    
    LocalGatewayId?: string;
    
    OutpostArn?: string;
    
    OwnerId?: string;
    
    State?: string;
    
    Tags?: Tag[];
}
export declare namespace LocalGatewayRouteTable {
    
    const filterSensitiveLog: (obj: LocalGatewayRouteTable) => any;
}
export interface DescribeLocalGatewayRouteTablesResult {
    
    LocalGatewayRouteTables?: LocalGatewayRouteTable[];
    
    NextToken?: string;
}
export declare namespace DescribeLocalGatewayRouteTablesResult {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayRouteTablesResult) => any;
}
export interface DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest {
    
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest) => any;
}

export interface LocalGatewayRouteTableVirtualInterfaceGroupAssociation {
    
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationId?: string;
    
    LocalGatewayVirtualInterfaceGroupId?: string;
    
    LocalGatewayId?: string;
    
    LocalGatewayRouteTableId?: string;
    
    LocalGatewayRouteTableArn?: string;
    
    OwnerId?: string;
    
    State?: string;
    
    Tags?: Tag[];
}
export declare namespace LocalGatewayRouteTableVirtualInterfaceGroupAssociation {
    
    const filterSensitiveLog: (obj: LocalGatewayRouteTableVirtualInterfaceGroupAssociation) => any;
}
export interface DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult {
    
    LocalGatewayRouteTableVirtualInterfaceGroupAssociations?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation[];
    
    NextToken?: string;
}
export declare namespace DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult) => any;
}
export interface DescribeLocalGatewayRouteTableVpcAssociationsRequest {
    
    LocalGatewayRouteTableVpcAssociationIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeLocalGatewayRouteTableVpcAssociationsRequest {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayRouteTableVpcAssociationsRequest) => any;
}
export interface DescribeLocalGatewayRouteTableVpcAssociationsResult {
    
    LocalGatewayRouteTableVpcAssociations?: LocalGatewayRouteTableVpcAssociation[];
    
    NextToken?: string;
}
export declare namespace DescribeLocalGatewayRouteTableVpcAssociationsResult {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayRouteTableVpcAssociationsResult) => any;
}
export interface DescribeLocalGatewaysRequest {
    
    LocalGatewayIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeLocalGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewaysRequest) => any;
}

export interface LocalGateway {
    
    LocalGatewayId?: string;
    
    OutpostArn?: string;
    
    OwnerId?: string;
    
    State?: string;
    
    Tags?: Tag[];
}
export declare namespace LocalGateway {
    
    const filterSensitiveLog: (obj: LocalGateway) => any;
}
export interface DescribeLocalGatewaysResult {
    
    LocalGateways?: LocalGateway[];
    
    NextToken?: string;
}
export declare namespace DescribeLocalGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewaysResult) => any;
}
export interface DescribeLocalGatewayVirtualInterfaceGroupsRequest {
    
    LocalGatewayVirtualInterfaceGroupIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeLocalGatewayVirtualInterfaceGroupsRequest {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayVirtualInterfaceGroupsRequest) => any;
}

export interface LocalGatewayVirtualInterfaceGroup {
    
    LocalGatewayVirtualInterfaceGroupId?: string;
    
    LocalGatewayVirtualInterfaceIds?: string[];
    
    LocalGatewayId?: string;
    
    OwnerId?: string;
    
    Tags?: Tag[];
}
export declare namespace LocalGatewayVirtualInterfaceGroup {
    
    const filterSensitiveLog: (obj: LocalGatewayVirtualInterfaceGroup) => any;
}
export interface DescribeLocalGatewayVirtualInterfaceGroupsResult {
    
    LocalGatewayVirtualInterfaceGroups?: LocalGatewayVirtualInterfaceGroup[];
    
    NextToken?: string;
}
export declare namespace DescribeLocalGatewayVirtualInterfaceGroupsResult {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayVirtualInterfaceGroupsResult) => any;
}
export interface DescribeLocalGatewayVirtualInterfacesRequest {
    
    LocalGatewayVirtualInterfaceIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeLocalGatewayVirtualInterfacesRequest {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayVirtualInterfacesRequest) => any;
}

export interface LocalGatewayVirtualInterface {
    
    LocalGatewayVirtualInterfaceId?: string;
    
    LocalGatewayId?: string;
    
    Vlan?: number;
    
    LocalAddress?: string;
    
    PeerAddress?: string;
    
    LocalBgpAsn?: number;
    
    PeerBgpAsn?: number;
    
    OwnerId?: string;
    
    Tags?: Tag[];
}
export declare namespace LocalGatewayVirtualInterface {
    
    const filterSensitiveLog: (obj: LocalGatewayVirtualInterface) => any;
}
export interface DescribeLocalGatewayVirtualInterfacesResult {
    
    LocalGatewayVirtualInterfaces?: LocalGatewayVirtualInterface[];
    
    NextToken?: string;
}
export declare namespace DescribeLocalGatewayVirtualInterfacesResult {
    
    const filterSensitiveLog: (obj: DescribeLocalGatewayVirtualInterfacesResult) => any;
}
export interface DescribeManagedPrefixListsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    PrefixListIds?: string[];
}
export declare namespace DescribeManagedPrefixListsRequest {
    
    const filterSensitiveLog: (obj: DescribeManagedPrefixListsRequest) => any;
}
export interface DescribeManagedPrefixListsResult {
    
    NextToken?: string;
    
    PrefixLists?: ManagedPrefixList[];
}
export declare namespace DescribeManagedPrefixListsResult {
    
    const filterSensitiveLog: (obj: DescribeManagedPrefixListsResult) => any;
}
export interface DescribeMovingAddressesRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    PublicIps?: string[];
}
export declare namespace DescribeMovingAddressesRequest {
    
    const filterSensitiveLog: (obj: DescribeMovingAddressesRequest) => any;
}
export declare type MoveStatus = "movingToVpc" | "restoringToClassic";

export interface MovingAddressStatus {
    
    MoveStatus?: MoveStatus | string;
    
    PublicIp?: string;
}
export declare namespace MovingAddressStatus {
    
    const filterSensitiveLog: (obj: MovingAddressStatus) => any;
}
export interface DescribeMovingAddressesResult {
    
    MovingAddressStatuses?: MovingAddressStatus[];
    
    NextToken?: string;
}
export declare namespace DescribeMovingAddressesResult {
    
    const filterSensitiveLog: (obj: DescribeMovingAddressesResult) => any;
}
export interface DescribeNatGatewaysRequest {
    
    DryRun?: boolean;
    
    Filter?: Filter[];
    
    MaxResults?: number;
    
    NatGatewayIds?: string[];
    
    NextToken?: string;
}
export declare namespace DescribeNatGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeNatGatewaysRequest) => any;
}
export interface DescribeNatGatewaysResult {
    
    NatGateways?: NatGateway[];
    
    NextToken?: string;
}
export declare namespace DescribeNatGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeNatGatewaysResult) => any;
}
export interface DescribeNetworkAclsRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    NetworkAclIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeNetworkAclsRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkAclsRequest) => any;
}
export interface DescribeNetworkAclsResult {
    
    NetworkAcls?: NetworkAcl[];
    
    NextToken?: string;
}
export declare namespace DescribeNetworkAclsResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkAclsResult) => any;
}
export interface DescribeNetworkInsightsAccessScopeAnalysesRequest {
    
    NetworkInsightsAccessScopeAnalysisIds?: string[];
    
    NetworkInsightsAccessScopeId?: string;
    
    AnalysisStartTimeBegin?: Date;
    
    AnalysisStartTimeEnd?: Date;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    DryRun?: boolean;
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsAccessScopeAnalysesRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsAccessScopeAnalysesRequest) => any;
}
export declare enum FindingsFound {
    false = "false",
    true = "true",
    unknown = "unknown"
}
export declare type AnalysisStatus = "failed" | "running" | "succeeded";

export interface NetworkInsightsAccessScopeAnalysis {
    
    NetworkInsightsAccessScopeAnalysisId?: string;
    
    NetworkInsightsAccessScopeAnalysisArn?: string;
    
    NetworkInsightsAccessScopeId?: string;
    
    Status?: AnalysisStatus | string;
    
    StatusMessage?: string;
    
    WarningMessage?: string;
    
    StartDate?: Date;
    
    EndDate?: Date;
    
    FindingsFound?: FindingsFound | string;
    
    AnalyzedEniCount?: number;
    
    Tags?: Tag[];
}
export declare namespace NetworkInsightsAccessScopeAnalysis {
    
    const filterSensitiveLog: (obj: NetworkInsightsAccessScopeAnalysis) => any;
}
export interface DescribeNetworkInsightsAccessScopeAnalysesResult {
    
    NetworkInsightsAccessScopeAnalyses?: NetworkInsightsAccessScopeAnalysis[];
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsAccessScopeAnalysesResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsAccessScopeAnalysesResult) => any;
}
export interface DescribeNetworkInsightsAccessScopesRequest {
    
    NetworkInsightsAccessScopeIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    DryRun?: boolean;
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsAccessScopesRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsAccessScopesRequest) => any;
}
export interface DescribeNetworkInsightsAccessScopesResult {
    
    NetworkInsightsAccessScopes?: NetworkInsightsAccessScope[];
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsAccessScopesResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsAccessScopesResult) => any;
}
export interface DescribeNetworkInsightsAnalysesRequest {
    
    NetworkInsightsAnalysisIds?: string[];
    
    NetworkInsightsPathId?: string;
    
    AnalysisStartTime?: Date;
    
    AnalysisEndTime?: Date;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    DryRun?: boolean;
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsAnalysesRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsAnalysesRequest) => any;
}

export interface AnalysisLoadBalancerListener {
    
    LoadBalancerPort?: number;
    
    InstancePort?: number;
}
export declare namespace AnalysisLoadBalancerListener {
    
    const filterSensitiveLog: (obj: AnalysisLoadBalancerListener) => any;
}

export interface AnalysisLoadBalancerTarget {
    
    Address?: string;
    
    AvailabilityZone?: string;
    
    Instance?: AnalysisComponent;
    
    Port?: number;
}
export declare namespace AnalysisLoadBalancerTarget {
    
    const filterSensitiveLog: (obj: AnalysisLoadBalancerTarget) => any;
}

export interface Explanation {
    
    Acl?: AnalysisComponent;
    
    AclRule?: AnalysisAclRule;
    
    Address?: string;
    
    Addresses?: string[];
    
    AttachedTo?: AnalysisComponent;
    
    AvailabilityZones?: string[];
    
    Cidrs?: string[];
    
    Component?: AnalysisComponent;
    
    CustomerGateway?: AnalysisComponent;
    
    Destination?: AnalysisComponent;
    
    DestinationVpc?: AnalysisComponent;
    
    Direction?: string;
    
    ExplanationCode?: string;
    
    IngressRouteTable?: AnalysisComponent;
    
    InternetGateway?: AnalysisComponent;
    
    LoadBalancerArn?: string;
    
    ClassicLoadBalancerListener?: AnalysisLoadBalancerListener;
    
    LoadBalancerListenerPort?: number;
    
    LoadBalancerTarget?: AnalysisLoadBalancerTarget;
    
    LoadBalancerTargetGroup?: AnalysisComponent;
    
    LoadBalancerTargetGroups?: AnalysisComponent[];
    
    LoadBalancerTargetPort?: number;
    
    ElasticLoadBalancerListener?: AnalysisComponent;
    
    MissingComponent?: string;
    
    NatGateway?: AnalysisComponent;
    
    NetworkInterface?: AnalysisComponent;
    
    PacketField?: string;
    
    VpcPeeringConnection?: AnalysisComponent;
    
    Port?: number;
    
    PortRanges?: PortRange[];
    
    PrefixList?: AnalysisComponent;
    
    Protocols?: string[];
    
    RouteTableRoute?: AnalysisRouteTableRoute;
    
    RouteTable?: AnalysisComponent;
    
    SecurityGroup?: AnalysisComponent;
    
    SecurityGroupRule?: AnalysisSecurityGroupRule;
    
    SecurityGroups?: AnalysisComponent[];
    
    SourceVpc?: AnalysisComponent;
    
    State?: string;
    
    Subnet?: AnalysisComponent;
    
    SubnetRouteTable?: AnalysisComponent;
    
    Vpc?: AnalysisComponent;
    
    VpcEndpoint?: AnalysisComponent;
    
    VpnConnection?: AnalysisComponent;
    
    VpnGateway?: AnalysisComponent;
}
export declare namespace Explanation {
    
    const filterSensitiveLog: (obj: Explanation) => any;
}

export interface NetworkInsightsAnalysis {
    
    NetworkInsightsAnalysisId?: string;
    
    NetworkInsightsAnalysisArn?: string;
    
    NetworkInsightsPathId?: string;
    
    FilterInArns?: string[];
    
    StartDate?: Date;
    
    Status?: AnalysisStatus | string;
    
    StatusMessage?: string;
    
    WarningMessage?: string;
    
    NetworkPathFound?: boolean;
    
    ForwardPathComponents?: PathComponent[];
    
    ReturnPathComponents?: PathComponent[];
    
    Explanations?: Explanation[];
    
    AlternatePathHints?: AlternatePathHint[];
    
    Tags?: Tag[];
}
export declare namespace NetworkInsightsAnalysis {
    
    const filterSensitiveLog: (obj: NetworkInsightsAnalysis) => any;
}
export interface DescribeNetworkInsightsAnalysesResult {
    
    NetworkInsightsAnalyses?: NetworkInsightsAnalysis[];
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsAnalysesResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsAnalysesResult) => any;
}
export interface DescribeNetworkInsightsPathsRequest {
    
    NetworkInsightsPathIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    DryRun?: boolean;
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsPathsRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsPathsRequest) => any;
}
export interface DescribeNetworkInsightsPathsResult {
    
    NetworkInsightsPaths?: NetworkInsightsPath[];
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInsightsPathsResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkInsightsPathsResult) => any;
}
export declare type NetworkInterfaceAttribute = "attachment" | "description" | "groupSet" | "sourceDestCheck";

export interface DescribeNetworkInterfaceAttributeRequest {
    
    Attribute?: NetworkInterfaceAttribute | string;
    
    DryRun?: boolean;
    
    NetworkInterfaceId: string | undefined;
}
export declare namespace DescribeNetworkInterfaceAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkInterfaceAttributeRequest) => any;
}

export interface DescribeNetworkInterfaceAttributeResult {
    
    Attachment?: NetworkInterfaceAttachment;
    
    Description?: AttributeValue;
    
    Groups?: GroupIdentifier[];
    
    NetworkInterfaceId?: string;
    
    SourceDestCheck?: AttributeBooleanValue;
}
export declare namespace DescribeNetworkInterfaceAttributeResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkInterfaceAttributeResult) => any;
}

export interface DescribeNetworkInterfacePermissionsRequest {
    
    NetworkInterfacePermissionIds?: string[];
    
    Filters?: Filter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeNetworkInterfacePermissionsRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkInterfacePermissionsRequest) => any;
}

export interface DescribeNetworkInterfacePermissionsResult {
    
    NetworkInterfacePermissions?: NetworkInterfacePermission[];
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInterfacePermissionsResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkInterfacePermissionsResult) => any;
}

export interface DescribeNetworkInterfacesRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    NetworkInterfaceIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeNetworkInterfacesRequest {
    
    const filterSensitiveLog: (obj: DescribeNetworkInterfacesRequest) => any;
}

export interface DescribeNetworkInterfacesResult {
    
    NetworkInterfaces?: NetworkInterface[];
    
    NextToken?: string;
}
export declare namespace DescribeNetworkInterfacesResult {
    
    const filterSensitiveLog: (obj: DescribeNetworkInterfacesResult) => any;
}
export interface DescribePlacementGroupsRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    GroupNames?: string[];
    
    GroupIds?: string[];
}
export declare namespace DescribePlacementGroupsRequest {
    
    const filterSensitiveLog: (obj: DescribePlacementGroupsRequest) => any;
}
export interface DescribePlacementGroupsResult {
    
    PlacementGroups?: PlacementGroup[];
}
export declare namespace DescribePlacementGroupsResult {
    
    const filterSensitiveLog: (obj: DescribePlacementGroupsResult) => any;
}
export interface DescribePrefixListsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    PrefixListIds?: string[];
}
export declare namespace DescribePrefixListsRequest {
    
    const filterSensitiveLog: (obj: DescribePrefixListsRequest) => any;
}

export interface PrefixList {
    
    Cidrs?: string[];
    
    PrefixListId?: string;
    
    PrefixListName?: string;
}
export declare namespace PrefixList {
    
    const filterSensitiveLog: (obj: PrefixList) => any;
}
export interface DescribePrefixListsResult {
    
    NextToken?: string;
    
    PrefixLists?: PrefixList[];
}
export declare namespace DescribePrefixListsResult {
    
    const filterSensitiveLog: (obj: DescribePrefixListsResult) => any;
}
export interface DescribePrincipalIdFormatRequest {
    
    DryRun?: boolean;
    
    Resources?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribePrincipalIdFormatRequest {
    
    const filterSensitiveLog: (obj: DescribePrincipalIdFormatRequest) => any;
}

export interface PrincipalIdFormat {
    
    Arn?: string;
    
    Statuses?: IdFormat[];
}
export declare namespace PrincipalIdFormat {
    
    const filterSensitiveLog: (obj: PrincipalIdFormat) => any;
}
export interface DescribePrincipalIdFormatResult {
    
    Principals?: PrincipalIdFormat[];
    
    NextToken?: string;
}
export declare namespace DescribePrincipalIdFormatResult {
    
    const filterSensitiveLog: (obj: DescribePrincipalIdFormatResult) => any;
}
export interface DescribePublicIpv4PoolsRequest {
    
    PoolIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
    
    Filters?: Filter[];
}
export declare namespace DescribePublicIpv4PoolsRequest {
    
    const filterSensitiveLog: (obj: DescribePublicIpv4PoolsRequest) => any;
}

export interface PublicIpv4PoolRange {
    
    FirstAddress?: string;
    
    LastAddress?: string;
    
    AddressCount?: number;
    
    AvailableAddressCount?: number;
}
export declare namespace PublicIpv4PoolRange {
    
    const filterSensitiveLog: (obj: PublicIpv4PoolRange) => any;
}

export interface PublicIpv4Pool {
    
    PoolId?: string;
    
    Description?: string;
    
    PoolAddressRanges?: PublicIpv4PoolRange[];
    
    TotalAddressCount?: number;
    
    TotalAvailableAddressCount?: number;
    
    NetworkBorderGroup?: string;
    
    Tags?: Tag[];
}
export declare namespace PublicIpv4Pool {
    
    const filterSensitiveLog: (obj: PublicIpv4Pool) => any;
}
export interface DescribePublicIpv4PoolsResult {
    
    PublicIpv4Pools?: PublicIpv4Pool[];
    
    NextToken?: string;
}
export declare namespace DescribePublicIpv4PoolsResult {
    
    const filterSensitiveLog: (obj: DescribePublicIpv4PoolsResult) => any;
}
export interface DescribeRegionsRequest {
    
    Filters?: Filter[];
    
    RegionNames?: string[];
    
    DryRun?: boolean;
    
    AllRegions?: boolean;
}
export declare namespace DescribeRegionsRequest {
    
    const filterSensitiveLog: (obj: DescribeRegionsRequest) => any;
}

export interface Region {
    
    Endpoint?: string;
    
    RegionName?: string;
    
    OptInStatus?: string;
}
export declare namespace Region {
    
    const filterSensitiveLog: (obj: Region) => any;
}
export interface DescribeRegionsResult {
    
    Regions?: Region[];
}
export declare namespace DescribeRegionsResult {
    
    const filterSensitiveLog: (obj: DescribeRegionsResult) => any;
}
export interface DescribeReplaceRootVolumeTasksRequest {
    
    ReplaceRootVolumeTaskIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeReplaceRootVolumeTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeReplaceRootVolumeTasksRequest) => any;
}
export interface DescribeReplaceRootVolumeTasksResult {
    
    ReplaceRootVolumeTasks?: ReplaceRootVolumeTask[];
    
    NextToken?: string;
}
export declare namespace DescribeReplaceRootVolumeTasksResult {
    
    const filterSensitiveLog: (obj: DescribeReplaceRootVolumeTasksResult) => any;
}
export declare enum OfferingClassType {
    CONVERTIBLE = "convertible",
    STANDARD = "standard"
}
export declare type OfferingTypeValues = "All Upfront" | "Heavy Utilization" | "Light Utilization" | "Medium Utilization" | "No Upfront" | "Partial Upfront";

export interface DescribeReservedInstancesRequest {
    
    Filters?: Filter[];
    
    OfferingClass?: OfferingClassType | string;
    
    ReservedInstancesIds?: string[];
    
    DryRun?: boolean;
    
    OfferingType?: OfferingTypeValues | string;
}
export declare namespace DescribeReservedInstancesRequest {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesRequest) => any;
}
export declare type RIProductDescription = "Linux/UNIX" | "Linux/UNIX (Amazon VPC)" | "Windows" | "Windows (Amazon VPC)";
export declare type RecurringChargeFrequency = "Hourly";

export interface RecurringCharge {
    
    Amount?: number;
    
    Frequency?: RecurringChargeFrequency | string;
}
export declare namespace RecurringCharge {
    
    const filterSensitiveLog: (obj: RecurringCharge) => any;
}
export declare enum Scope {
    AVAILABILITY_ZONE = "Availability Zone",
    REGIONAL = "Region"
}
export declare type ReservedInstanceState = "active" | "payment-failed" | "payment-pending" | "queued" | "queued-deleted" | "retired";

export interface ReservedInstances {
    
    AvailabilityZone?: string;
    
    Duration?: number;
    
    End?: Date;
    
    FixedPrice?: number;
    
    InstanceCount?: number;
    
    InstanceType?: _InstanceType | string;
    
    ProductDescription?: RIProductDescription | string;
    
    ReservedInstancesId?: string;
    
    Start?: Date;
    
    State?: ReservedInstanceState | string;
    
    UsagePrice?: number;
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    InstanceTenancy?: Tenancy | string;
    
    OfferingClass?: OfferingClassType | string;
    
    OfferingType?: OfferingTypeValues | string;
    
    RecurringCharges?: RecurringCharge[];
    
    Scope?: Scope | string;
    
    Tags?: Tag[];
}
export declare namespace ReservedInstances {
    
    const filterSensitiveLog: (obj: ReservedInstances) => any;
}

export interface DescribeReservedInstancesResult {
    
    ReservedInstances?: ReservedInstances[];
}
export declare namespace DescribeReservedInstancesResult {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesResult) => any;
}

export interface DescribeReservedInstancesListingsRequest {
    
    Filters?: Filter[];
    
    ReservedInstancesId?: string;
    
    ReservedInstancesListingId?: string;
}
export declare namespace DescribeReservedInstancesListingsRequest {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesListingsRequest) => any;
}

export interface DescribeReservedInstancesListingsResult {
    
    ReservedInstancesListings?: ReservedInstancesListing[];
}
export declare namespace DescribeReservedInstancesListingsResult {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesListingsResult) => any;
}

export interface DescribeReservedInstancesModificationsRequest {
    
    Filters?: Filter[];
    
    ReservedInstancesModificationIds?: string[];
    
    NextToken?: string;
}
export declare namespace DescribeReservedInstancesModificationsRequest {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesModificationsRequest) => any;
}

export interface ReservedInstancesConfiguration {
    
    AvailabilityZone?: string;
    
    InstanceCount?: number;
    
    InstanceType?: _InstanceType | string;
    
    Platform?: string;
    
    Scope?: Scope | string;
}
export declare namespace ReservedInstancesConfiguration {
    
    const filterSensitiveLog: (obj: ReservedInstancesConfiguration) => any;
}

export interface ReservedInstancesModificationResult {
    
    ReservedInstancesId?: string;
    
    TargetConfiguration?: ReservedInstancesConfiguration;
}
export declare namespace ReservedInstancesModificationResult {
    
    const filterSensitiveLog: (obj: ReservedInstancesModificationResult) => any;
}

export interface ReservedInstancesId {
    
    ReservedInstancesId?: string;
}
export declare namespace ReservedInstancesId {
    
    const filterSensitiveLog: (obj: ReservedInstancesId) => any;
}

export interface ReservedInstancesModification {
    
    ClientToken?: string;
    
    CreateDate?: Date;
    
    EffectiveDate?: Date;
    
    ModificationResults?: ReservedInstancesModificationResult[];
    
    ReservedInstancesIds?: ReservedInstancesId[];
    
    ReservedInstancesModificationId?: string;
    
    Status?: string;
    
    StatusMessage?: string;
    
    UpdateDate?: Date;
}
export declare namespace ReservedInstancesModification {
    
    const filterSensitiveLog: (obj: ReservedInstancesModification) => any;
}
