import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { UnassignIpv6AddressesRequest, UnassignIpv6AddressesResult } from "../models/models_6";
export interface UnassignIpv6AddressesCommandInput extends UnassignIpv6AddressesRequest {
}
export interface UnassignIpv6AddressesCommandOutput extends UnassignIpv6AddressesResult, __MetadataBearer {
}

export declare class UnassignIpv6AddressesCommand extends $Command<UnassignIpv6AddressesCommandInput, UnassignIpv6AddressesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: UnassignIpv6AddressesCommandInput;
    constructor(input: UnassignIpv6AddressesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<UnassignIpv6AddressesCommandInput, UnassignIpv6AddressesCommandOutput>;
    private serialize;
    private deserialize;
}
