import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { StartInstancesRequest, StartInstancesResult } from "../models/models_6";
export interface StartInstancesCommandInput extends StartInstancesRequest {
}
export interface StartInstancesCommandOutput extends StartInstancesResult, __MetadataBearer {
}

export declare class StartInstancesCommand extends $Command<StartInstancesCommandInput, StartInstancesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: StartInstancesCommandInput;
    constructor(input: StartInstancesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<StartInstancesCommandInput, StartInstancesCommandOutput>;
    private serialize;
    private deserialize;
}
