import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { PurchaseScheduledInstancesRequest, PurchaseScheduledInstancesResult } from "../models/models_5";
export interface PurchaseScheduledInstancesCommandInput extends PurchaseScheduledInstancesRequest {
}
export interface PurchaseScheduledInstancesCommandOutput extends PurchaseScheduledInstancesResult, __MetadataBearer {
}

export declare class PurchaseScheduledInstancesCommand extends $Command<PurchaseScheduledInstancesCommandInput, PurchaseScheduledInstancesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: PurchaseScheduledInstancesCommandInput;
    constructor(input: PurchaseScheduledInstancesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<PurchaseScheduledInstancesCommandInput, PurchaseScheduledInstancesCommandOutput>;
    private serialize;
    private deserialize;
}
